static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright (C) 2011 Barak Itkin <lightningismyname@gmail.org>               \n"
" *                                                                            \n"
" * Based on \"Spread\" (Noise) GIMP plugin                                    \n"
" * Copyright (C) 1997 Brian Degenhardt and Federico Mena Quintero             \n"
" *                                                                            \n"
" * The workshop/whirl-pinch.c and common/pixelise.c were used as              \n"
" * templates for this op file.                                                \n"
" */                                                                           \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int    (amount_x, _(\"Horizontal\"), 5)                              \n"
"    description (_(\"Horizontal spread amount\"))                             \n"
"    value_range (0, 512)                                                      \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"x\")                                             \n"
"                                                                              \n"
"property_int    (amount_y, _(\"Vertical\"), 5)                                \n"
"    description (_(\"Vertical spread amount\"))                               \n"
"    value_range (0, 512)                                                      \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"y\")                                             \n"
"                                                                              \n"
"property_seed (seed, _(\"Random seed\"), rand)                                \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME     noise_spread                                         \n"
"#define GEGL_OP_C_SOURCE noise-spread.c                                       \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"calc_sample_coords (gint        src_x,                                        \n"
"                    gint        src_y,                                        \n"
"                    gint        amount_x,                                     \n"
"                    gint        amount_y,                                     \n"
"                    GeglRandom *rand,                                         \n"
"                    gint       *x,                                            \n"
"                    gint       *y)                                            \n"
"{                                                                             \n"
"  gdouble angle;                                                              \n"
"  gint    xdist, ydist;                                                       \n"
"                                                                              \n"
"  /* get random angle, x distance, and y distance */                          \n"
"  xdist = amount_x > 0 ? gegl_random_int_range (rand, src_x, src_y, 0, 0,     \n"
"                                                -amount_x, amount_x + 1) : 0; \n"
"  ydist = amount_y > 0 ? gegl_random_int_range (rand, src_x, src_y, 0, 1,     \n"
"                                                -amount_y, amount_y + 1) : 0; \n"
"  angle = gegl_random_float_range (rand, src_x, src_y, 0, 2, -G_PI, G_PI);    \n"
"                                                                              \n"
"  *x = src_x + floor (sin (angle) * xdist);                                   \n"
"  *y = src_y + floor (cos (angle) * ydist);                                   \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties          *o       = GEGL_PROPERTIES (operation);             \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  const Babl              *format;                                            \n"
"                                                                              \n"
"  op_area->left   =                                                           \n"
"  op_area->right  = (o->amount_x + 1) / 2;                                    \n"
"  op_area->top    =                                                           \n"
"  op_area->bottom = (o->amount_y + 1) / 2;                                    \n"
"                                                                              \n"
"  format = gegl_operation_get_source_format (operation, \"input\");           \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties         *o;                                                  \n"
"  const Babl         *format;                                                 \n"
"  gint                bpp;                                                    \n"
"  GeglBufferIterator *gi;                                                     \n"
"  gint                amount_x;                                               \n"
"  gint                amount_y;                                               \n"
"                                                                              \n"
"  o = GEGL_PROPERTIES (operation);                                            \n"
"                                                                              \n"
"  amount_x = (o->amount_x + 1) / 2;                                           \n"
"  amount_y = (o->amount_y + 1) / 2;                                           \n"
"                                                                              \n"
"  format = gegl_operation_get_source_format (operation, \"input\");           \n"
"  bpp = babl_format_get_bytes_per_pixel (format);                             \n"
"                                                                              \n"
"  gi = gegl_buffer_iterator_new (output, result, 0, format,                   \n"
"                                 GEGL_ACCESS_WRITE, GEGL_ABYSS_CLAMP);        \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (gi))                                      \n"
"    {                                                                         \n"
"      gchar        *data = gi->data[0];                                       \n"
"      GeglRectangle roi  = gi->roi[0];                                        \n"
"      gint          i, j;                                                     \n"
"                                                                              \n"
"      for (j = roi.y; j < roi.y + roi.height ; j++)                           \n"
"        for (i = roi.x; i < roi.x + roi.width ; i++)                          \n"
"          {                                                                   \n"
"            gint x, y;                                                        \n"
"                                                                              \n"
"            calc_sample_coords (i, j, amount_x, amount_y, o->rand, &x, &y);   \n"
"                                                                              \n"
"            gegl_buffer_sample_at_level (input, x, y, NULL, data, format, level,\n"
"                                GEGL_SAMPLER_NEAREST, GEGL_ABYSS_CLAMP);      \n"
"            data += bpp;                                                      \n"
"          }                                                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"  filter_class->process    = process;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:noise-spread\",                                   \n"
"    \"title\",       _(\"Noise Spread\"),                                     \n"
"    \"categories\",  \"noise\",                                               \n"
"    \"reference-hash\", \"c53483232973300e961be9819026f997\",                 \n"
"    \"description\", _(\"Move pixels around randomly\"),                      \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
