--TEST--
sni_server with separate pk and cert
--SKIPIF--
<?php
if (!extension_loaded("openssl")) die("skip openssl not loaded");
if (OPENSSL_VERSION_NUMBER >= 0x10100000) die("skip OpenSSL < v1.1.0 required");
--FILE--
<?php
$serverCode = <<<'CODE'
	$flags = STREAM_SERVER_BIND|STREAM_SERVER_LISTEN;
	$ctx = stream_context_create(['ssl' => [
		'local_cert' => __DIR__ . '/domain1.pem',
		'SNI_server_certs' => [
			"domain1.com" => [
				'local_cert' => __DIR__ . "/sni_server_domain1_cert.pem",
				'local_pk' => __DIR__ . "/sni_server_domain1_key.pem"
			],
			"domain2.com" => [
				'local_cert' => __DIR__ . "/sni_server_domain2_cert.pem",
				'local_pk' => __DIR__ . "/sni_server_domain2_key.pem"
			],
			"domain3.com" => [
				'local_cert' => __DIR__ . "/sni_server_domain3_cert.pem",
				'local_pk' => __DIR__ . "/sni_server_domain3_key.pem"
			],
		]
	]]);

	$server = stream_socket_server('tls://127.0.0.1:64321', $errno, $errstr, $flags, $ctx);
	phpt_notify();

	for ($i=0; $i < 3; $i++) {
		@stream_socket_accept($server, 3);
	}
CODE;

$clientCode = <<<'CODE'
    $flags = STREAM_CLIENT_CONNECT;
    $ctxArr = [
        'cafile' => __DIR__ . '/sni_server_ca.pem',
        'capture_peer_cert' => true
    ];

    phpt_wait();

    $ctxArr['peer_name'] = 'domain1.com';
    $ctx = stream_context_create(['ssl' => $ctxArr]);
    $client = stream_socket_client("tls://127.0.0.1:64321", $errno, $errstr, 1, $flags, $ctx);
    $cert = stream_context_get_options($ctx)['ssl']['peer_certificate'];
    var_dump(openssl_x509_parse($cert)['subject']['CN']);

    $ctxArr['peer_name'] = 'domain2.com';
    $ctx = stream_context_create(['ssl' => $ctxArr]);
    $client = @stream_socket_client("tls://127.0.0.1:64321", $errno, $errstr, 1, $flags, $ctx);
    $cert = stream_context_get_options($ctx)['ssl']['peer_certificate'];
    var_dump(openssl_x509_parse($cert)['subject']['CN']);

    $ctxArr['peer_name'] = 'domain3.com';
    $ctx = stream_context_create(['ssl' => $ctxArr]);
    $client = @stream_socket_client("tls://127.0.0.1:64321", $errno, $errstr, 1, $flags, $ctx);
    $cert = stream_context_get_options($ctx)['ssl']['peer_certificate'];
    var_dump(openssl_x509_parse($cert)['subject']['CN']);
CODE;

include 'ServerClientTestCase.inc';
ServerClientTestCase::getInstance()->run($clientCode, $serverCode);
--EXPECTF--
string(%d) "domain1.com"
string(%d) "domain2.com"
string(%d) "domain3.com"
