/* BlindsEffect.c generated by valac 0.34.7, the Vala compiler
 * generated from BlindsEffect.vala, do not modify */

/* Copyright 2013 Jens Bav
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <shotwell-plugin-dev-1.0.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <math.h>
#include <float.h>
#include <gdk/gdk.h>


#define TYPE_SHOTWELL_TRANSITION_DESCRIPTOR (shotwell_transition_descriptor_get_type ())
#define SHOTWELL_TRANSITION_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptor))
#define SHOTWELL_TRANSITION_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptorClass))
#define IS_SHOTWELL_TRANSITION_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR))
#define IS_SHOTWELL_TRANSITION_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR))
#define SHOTWELL_TRANSITION_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptorClass))

typedef struct _ShotwellTransitionDescriptor ShotwellTransitionDescriptor;
typedef struct _ShotwellTransitionDescriptorClass ShotwellTransitionDescriptorClass;
typedef struct _ShotwellTransitionDescriptorPrivate ShotwellTransitionDescriptorPrivate;

#define TYPE_BLINDS_EFFECT_DESCRIPTOR (blinds_effect_descriptor_get_type ())
#define BLINDS_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLINDS_EFFECT_DESCRIPTOR, BlindsEffectDescriptor))
#define BLINDS_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLINDS_EFFECT_DESCRIPTOR, BlindsEffectDescriptorClass))
#define IS_BLINDS_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLINDS_EFFECT_DESCRIPTOR))
#define IS_BLINDS_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLINDS_EFFECT_DESCRIPTOR))
#define BLINDS_EFFECT_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLINDS_EFFECT_DESCRIPTOR, BlindsEffectDescriptorClass))

typedef struct _BlindsEffectDescriptor BlindsEffectDescriptor;
typedef struct _BlindsEffectDescriptorClass BlindsEffectDescriptorClass;
typedef struct _BlindsEffectDescriptorPrivate BlindsEffectDescriptorPrivate;

#define TYPE_BLINDS_EFFECT (blinds_effect_get_type ())
#define BLINDS_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLINDS_EFFECT, BlindsEffect))
#define BLINDS_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLINDS_EFFECT, BlindsEffectClass))
#define IS_BLINDS_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLINDS_EFFECT))
#define IS_BLINDS_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLINDS_EFFECT))
#define BLINDS_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLINDS_EFFECT, BlindsEffectClass))

typedef struct _BlindsEffect BlindsEffect;
typedef struct _BlindsEffectClass BlindsEffectClass;
typedef struct _BlindsEffectPrivate BlindsEffectPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _ShotwellTransitionDescriptor {
	GObject parent_instance;
	ShotwellTransitionDescriptorPrivate * priv;
};

struct _ShotwellTransitionDescriptorClass {
	GObjectClass parent_class;
	const gchar* (*get_id) (ShotwellTransitionDescriptor* self);
	const gchar* (*get_pluggable_name) (ShotwellTransitionDescriptor* self);
	SpitTransitionsEffect* (*create) (ShotwellTransitionDescriptor* self, SpitHostInterface* host);
};

struct _BlindsEffectDescriptor {
	ShotwellTransitionDescriptor parent_instance;
	BlindsEffectDescriptorPrivate * priv;
};

struct _BlindsEffectDescriptorClass {
	ShotwellTransitionDescriptorClass parent_class;
};

struct _BlindsEffect {
	GObject parent_instance;
	BlindsEffectPrivate * priv;
};

struct _BlindsEffectClass {
	GObjectClass parent_class;
};

struct _BlindsEffectPrivate {
	gint current_blind_width;
	cairo_surface_t** to_blinds;
	gint to_blinds_length1;
	gint _to_blinds_size_;
	gint blind_count;
};


static gpointer blinds_effect_descriptor_parent_class = NULL;
static gpointer blinds_effect_parent_class = NULL;
static SpitTransitionsEffectIface* blinds_effect_spit_transitions_effect_parent_iface = NULL;

GType shotwell_transition_descriptor_get_type (void) G_GNUC_CONST;
GType blinds_effect_descriptor_get_type (void) G_GNUC_CONST;
enum  {
	BLINDS_EFFECT_DESCRIPTOR_DUMMY_PROPERTY
};
BlindsEffectDescriptor* blinds_effect_descriptor_new (GFile* resource_directory);
BlindsEffectDescriptor* blinds_effect_descriptor_construct (GType object_type, GFile* resource_directory);
ShotwellTransitionDescriptor* shotwell_transition_descriptor_construct (GType object_type, GFile* resource_directory);
static const gchar* blinds_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base);
static const gchar* blinds_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base);
static SpitTransitionsEffect* blinds_effect_descriptor_real_create (ShotwellTransitionDescriptor* base, SpitHostInterface* host);
BlindsEffect* blinds_effect_new (void);
BlindsEffect* blinds_effect_construct (GType object_type);
GType blinds_effect_get_type (void) G_GNUC_CONST;
#define BLINDS_EFFECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BLINDS_EFFECT, BlindsEffectPrivate))
enum  {
	BLINDS_EFFECT_DUMMY_PROPERTY
};
#define BLINDS_EFFECT_DESIRED_FPS 30
#define BLINDS_EFFECT_MIN_FPS 15
#define BLINDS_EFFECT_BLIND_WIDTH 50
static void blinds_effect_real_get_fps (SpitTransitionsEffect* base, gint* desired_fps, gint* min_fps);
static gboolean blinds_effect_real_needs_clear_background (SpitTransitionsEffect* base);
static void blinds_effect_real_start (SpitTransitionsEffect* base, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion);
static void blinds_effect_real_paint (SpitTransitionsEffect* base, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion, cairo_t* ctx, gint width, gint height, gint frame_number);
static void blinds_effect_real_advance (SpitTransitionsEffect* base, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion, gint frame_number);
static void blinds_effect_real_cancel (SpitTransitionsEffect* base);
static void blinds_effect_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


BlindsEffectDescriptor* blinds_effect_descriptor_construct (GType object_type, GFile* resource_directory) {
	BlindsEffectDescriptor * self = NULL;
	GFile* _tmp0_ = NULL;
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_return_val_if_fail (G_IS_FILE (resource_directory), NULL);
#line 12 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp0_ = resource_directory;
#line 12 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = (BlindsEffectDescriptor*) shotwell_transition_descriptor_construct (object_type, _tmp0_);
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	return self;
#line 147 "BlindsEffect.c"
}


BlindsEffectDescriptor* blinds_effect_descriptor_new (GFile* resource_directory) {
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	return blinds_effect_descriptor_construct (TYPE_BLINDS_EFFECT_DESCRIPTOR, resource_directory);
#line 154 "BlindsEffect.c"
}


static const gchar* blinds_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base) {
	BlindsEffectDescriptor * self;
	const gchar* result = NULL;
#line 15 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BLINDS_EFFECT_DESCRIPTOR, BlindsEffectDescriptor);
#line 16 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	result = "org.yorba.shotwell.transitions.blinds";
#line 16 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	return result;
#line 167 "BlindsEffect.c"
}


static const gchar* blinds_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base) {
	BlindsEffectDescriptor * self;
	const gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
#line 19 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BLINDS_EFFECT_DESCRIPTOR, BlindsEffectDescriptor);
#line 20 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp0_ = _ ("Blinds");
#line 20 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	result = _tmp0_;
#line 20 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	return result;
#line 183 "BlindsEffect.c"
}


static SpitTransitionsEffect* blinds_effect_descriptor_real_create (ShotwellTransitionDescriptor* base, SpitHostInterface* host) {
	BlindsEffectDescriptor * self;
	SpitTransitionsEffect* result = NULL;
	BlindsEffect* _tmp0_ = NULL;
#line 23 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BLINDS_EFFECT_DESCRIPTOR, BlindsEffectDescriptor);
#line 23 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_return_val_if_fail (SPIT_IS_HOST_INTERFACE (host), NULL);
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp0_ = blinds_effect_new ();
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SPIT_TRANSITIONS_TYPE_EFFECT, SpitTransitionsEffect);
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	return result;
#line 201 "BlindsEffect.c"
}


static void blinds_effect_descriptor_class_init (BlindsEffectDescriptorClass * klass) {
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	blinds_effect_descriptor_parent_class = g_type_class_peek_parent (klass);
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->get_id = (const gchar* (*)(ShotwellTransitionDescriptor*)) blinds_effect_descriptor_real_get_id;
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->get_pluggable_name = (const gchar* (*)(ShotwellTransitionDescriptor*)) blinds_effect_descriptor_real_get_pluggable_name;
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->create = (SpitTransitionsEffect* (*)(ShotwellTransitionDescriptor*, SpitHostInterface*)) blinds_effect_descriptor_real_create;
#line 214 "BlindsEffect.c"
}


static void blinds_effect_descriptor_instance_init (BlindsEffectDescriptor * self) {
}


GType blinds_effect_descriptor_get_type (void) {
	static volatile gsize blinds_effect_descriptor_type_id__volatile = 0;
	if (g_once_init_enter (&blinds_effect_descriptor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BlindsEffectDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) blinds_effect_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BlindsEffectDescriptor), 0, (GInstanceInitFunc) blinds_effect_descriptor_instance_init, NULL };
		GType blinds_effect_descriptor_type_id;
		blinds_effect_descriptor_type_id = g_type_register_static (TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, "BlindsEffectDescriptor", &g_define_type_info, 0);
		g_once_init_leave (&blinds_effect_descriptor_type_id__volatile, blinds_effect_descriptor_type_id);
	}
	return blinds_effect_descriptor_type_id__volatile;
}


BlindsEffect* blinds_effect_construct (GType object_type) {
	BlindsEffect * self = NULL;
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = (BlindsEffect*) g_object_new (object_type, NULL);
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	return self;
#line 240 "BlindsEffect.c"
}


BlindsEffect* blinds_effect_new (void) {
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	return blinds_effect_construct (TYPE_BLINDS_EFFECT);
#line 247 "BlindsEffect.c"
}


static void blinds_effect_real_get_fps (SpitTransitionsEffect* base, gint* desired_fps, gint* min_fps) {
	BlindsEffect * self;
	gint _vala_desired_fps = 0;
	gint _vala_min_fps = 0;
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BLINDS_EFFECT, BlindsEffect);
#line 42 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_vala_desired_fps = BLINDS_EFFECT_DESIRED_FPS;
#line 43 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_vala_min_fps = BLINDS_EFFECT_MIN_FPS;
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	if (desired_fps) {
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		*desired_fps = _vala_desired_fps;
#line 265 "BlindsEffect.c"
	}
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	if (min_fps) {
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		*min_fps = _vala_min_fps;
#line 271 "BlindsEffect.c"
	}
}


static gboolean blinds_effect_real_needs_clear_background (SpitTransitionsEffect* base) {
	BlindsEffect * self;
	gboolean result = FALSE;
#line 46 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BLINDS_EFFECT, BlindsEffect);
#line 47 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	result = TRUE;
#line 47 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	return result;
#line 285 "BlindsEffect.c"
}


static void blinds_effect_real_start (SpitTransitionsEffect* base, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion) {
	BlindsEffect * self;
	SpitTransitionsVisuals* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
#line 50 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BLINDS_EFFECT, BlindsEffect);
#line 50 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 50 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 51 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp0_ = visuals;
#line 51 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp1_ = spit_transitions_visuals_get_from_pixbuf (_tmp0_);
#line 51 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp2_ = _tmp1_;
#line 51 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	if (_tmp2_ != NULL) {
#line 308 "BlindsEffect.c"
		SpitTransitionsVisuals* _tmp3_ = NULL;
		GdkPixbuf* _tmp4_ = NULL;
		GdkPixbuf* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		SpitTransitionsVisuals* _tmp8_ = NULL;
		GdkPixbuf* _tmp9_ = NULL;
		GdkPixbuf* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gdouble _tmp14_ = 0.0;
		gint _tmp15_ = 0;
		cairo_surface_t** _tmp16_ = NULL;
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp3_ = visuals;
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp4_ = spit_transitions_visuals_get_to_pixbuf (_tmp3_);
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp5_ = _tmp4_;
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp6_ = gdk_pixbuf_get_width (_tmp5_);
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp7_ = _tmp6_;
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		self->priv->blind_count = _tmp7_ / BLINDS_EFFECT_BLIND_WIDTH;
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp8_ = visuals;
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp9_ = spit_transitions_visuals_get_to_pixbuf (_tmp8_);
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp10_ = _tmp9_;
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp11_ = gdk_pixbuf_get_width (_tmp10_);
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp12_ = _tmp11_;
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp13_ = self->priv->blind_count;
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp14_ = ceil (((gdouble) _tmp12_) / ((gdouble) _tmp13_));
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		self->priv->current_blind_width = (gint) _tmp14_;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp15_ = self->priv->blind_count;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp16_ = g_new0 (cairo_surface_t*, _tmp15_ + 1);
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		self->priv->to_blinds = (_vala_array_free (self->priv->to_blinds, self->priv->to_blinds_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		self->priv->to_blinds = _tmp16_;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		self->priv->to_blinds_length1 = _tmp15_;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		self->priv->_to_blinds_size_ = self->priv->to_blinds_length1;
#line 363 "BlindsEffect.c"
		{
			gint i = 0;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
			i = 0;
#line 368 "BlindsEffect.c"
			{
				gboolean _tmp17_ = FALSE;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp17_ = TRUE;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				while (TRUE) {
#line 375 "BlindsEffect.c"
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					cairo_surface_t** _tmp21_ = NULL;
					gint _tmp21__length1 = 0;
					gint _tmp22_ = 0;
					gint _tmp23_ = 0;
					SpitTransitionsVisuals* _tmp24_ = NULL;
					GdkPixbuf* _tmp25_ = NULL;
					GdkPixbuf* _tmp26_ = NULL;
					gint _tmp27_ = 0;
					gint _tmp28_ = 0;
					cairo_surface_t* _tmp29_ = NULL;
					cairo_surface_t* _tmp30_ = NULL;
					cairo_t* ctx = NULL;
					cairo_surface_t** _tmp31_ = NULL;
					gint _tmp31__length1 = 0;
					gint _tmp32_ = 0;
					cairo_surface_t* _tmp33_ = NULL;
					cairo_t* _tmp34_ = NULL;
					cairo_t* _tmp35_ = NULL;
					SpitTransitionsVisuals* _tmp36_ = NULL;
					GdkPixbuf* _tmp37_ = NULL;
					GdkPixbuf* _tmp38_ = NULL;
					gint _tmp39_ = 0;
					gint _tmp40_ = 0;
					cairo_t* _tmp41_ = NULL;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					if (!_tmp17_) {
#line 404 "BlindsEffect.c"
						gint _tmp18_ = 0;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
						_tmp18_ = i;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
						i = _tmp18_ + 1;
#line 410 "BlindsEffect.c"
					}
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp17_ = FALSE;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp19_ = i;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp20_ = self->priv->blind_count;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					if (!(_tmp19_ < _tmp20_)) {
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
						break;
#line 422 "BlindsEffect.c"
					}
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp21_ = self->priv->to_blinds;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp21__length1 = self->priv->to_blinds_length1;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp22_ = i;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp23_ = self->priv->current_blind_width;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp24_ = visuals;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp25_ = spit_transitions_visuals_get_to_pixbuf (_tmp24_);
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp26_ = _tmp25_;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp27_ = gdk_pixbuf_get_height (_tmp26_);
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp28_ = _tmp27_;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp29_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, _tmp23_, _tmp28_);
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_cairo_surface_destroy0 (_tmp21_[_tmp22_]);
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp21_[_tmp22_] = _tmp29_;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp30_ = _tmp21_[_tmp22_];
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp31_ = self->priv->to_blinds;
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp31__length1 = self->priv->to_blinds_length1;
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp32_ = i;
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp33_ = _tmp31_[_tmp32_];
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp34_ = cairo_create (_tmp33_);
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					ctx = _tmp34_;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp35_ = ctx;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp36_ = visuals;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp37_ = spit_transitions_visuals_get_to_pixbuf (_tmp36_);
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp38_ = _tmp37_;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp39_ = i;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp40_ = self->priv->current_blind_width;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					gdk_cairo_set_source_pixbuf (_tmp35_, _tmp38_, (gdouble) ((-_tmp39_) * _tmp40_), (gdouble) 0);
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp41_ = ctx;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					cairo_paint (_tmp41_);
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_cairo_destroy0 (ctx);
#line 482 "BlindsEffect.c"
				}
			}
		}
	}
}


static void blinds_effect_real_paint (SpitTransitionsEffect* base, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion, cairo_t* ctx, gint width, gint height, gint frame_number) {
	BlindsEffect * self;
	gdouble alpha = 0.0;
	SpitTransitionsMotion* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gdouble _tmp2_ = 0.0;
	gint y = 0;
	SpitTransitionsVisuals* _tmp3_ = NULL;
	GdkRectangle _tmp4_ = {0};
	GdkRectangle _tmp5_ = {0};
	gint _tmp6_ = 0;
	gint x = 0;
	SpitTransitionsVisuals* _tmp7_ = NULL;
	GdkRectangle _tmp8_ = {0};
	GdkRectangle _tmp9_ = {0};
	gint _tmp10_ = 0;
	SpitTransitionsVisuals* _tmp11_ = NULL;
	GdkPixbuf* _tmp12_ = NULL;
	GdkPixbuf* _tmp13_ = NULL;
	cairo_t* _tmp53_ = NULL;
	cairo_t* _tmp54_ = NULL;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BLINDS_EFFECT, BlindsEffect);
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_return_if_fail (ctx != NULL);
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp0_ = motion;
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp1_ = frame_number;
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp2_ = spit_transitions_motion_get_alpha (_tmp0_, _tmp1_);
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	alpha = _tmp2_;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp3_ = visuals;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	spit_transitions_visuals_get_to_pos (_tmp3_, &_tmp4_);
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp5_ = _tmp4_;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp6_ = _tmp5_.y;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	y = _tmp6_;
#line 72 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp7_ = visuals;
#line 72 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	spit_transitions_visuals_get_to_pos (_tmp7_, &_tmp8_);
#line 72 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp9_ = _tmp8_;
#line 72 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp10_ = _tmp9_.x;
#line 72 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	x = _tmp10_;
#line 74 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp11_ = visuals;
#line 74 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp12_ = spit_transitions_visuals_get_from_pixbuf (_tmp11_);
#line 74 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp13_ = _tmp12_;
#line 74 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	if (_tmp13_ != NULL) {
#line 555 "BlindsEffect.c"
		cairo_t* _tmp14_ = NULL;
		SpitTransitionsVisuals* _tmp15_ = NULL;
		GdkPixbuf* _tmp16_ = NULL;
		GdkPixbuf* _tmp17_ = NULL;
		SpitTransitionsVisuals* _tmp18_ = NULL;
		GdkRectangle _tmp19_ = {0};
		GdkRectangle _tmp20_ = {0};
		gint _tmp21_ = 0;
		SpitTransitionsVisuals* _tmp22_ = NULL;
		GdkRectangle _tmp23_ = {0};
		GdkRectangle _tmp24_ = {0};
		gint _tmp25_ = 0;
		cairo_t* _tmp26_ = NULL;
		gdouble _tmp27_ = 0.0;
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp14_ = ctx;
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp15_ = visuals;
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp16_ = spit_transitions_visuals_get_from_pixbuf (_tmp15_);
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp17_ = _tmp16_;
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp18_ = visuals;
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		spit_transitions_visuals_get_from_pos (_tmp18_, &_tmp19_);
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp20_ = _tmp19_;
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp21_ = _tmp20_.x;
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp22_ = visuals;
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		spit_transitions_visuals_get_from_pos (_tmp22_, &_tmp23_);
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp24_ = _tmp23_;
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp25_ = _tmp24_.y;
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		gdk_cairo_set_source_pixbuf (_tmp14_, _tmp17_, (gdouble) _tmp21_, (gdouble) _tmp25_);
#line 77 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp26_ = ctx;
#line 77 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp27_ = alpha;
#line 77 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		cairo_paint_with_alpha (_tmp26_, 1 - (_tmp27_ * 2));
#line 602 "BlindsEffect.c"
	}
	{
		gint i = 0;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		i = 0;
#line 608 "BlindsEffect.c"
		{
			gboolean _tmp28_ = FALSE;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
			_tmp28_ = TRUE;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
			while (TRUE) {
#line 615 "BlindsEffect.c"
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				cairo_t* _tmp32_ = NULL;
				cairo_surface_t** _tmp33_ = NULL;
				gint _tmp33__length1 = 0;
				gint _tmp34_ = 0;
				cairo_surface_t* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				cairo_t* _tmp40_ = NULL;
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
				gint _tmp44_ = 0;
				gint _tmp45_ = 0;
				gdouble _tmp46_ = 0.0;
				SpitTransitionsVisuals* _tmp47_ = NULL;
				GdkPixbuf* _tmp48_ = NULL;
				GdkPixbuf* _tmp49_ = NULL;
				gint _tmp50_ = 0;
				gint _tmp51_ = 0;
				cairo_t* _tmp52_ = NULL;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				if (!_tmp28_) {
#line 642 "BlindsEffect.c"
					gint _tmp29_ = 0;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp29_ = i;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					i = _tmp29_ + 1;
#line 648 "BlindsEffect.c"
				}
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp28_ = FALSE;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp30_ = i;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp31_ = self->priv->blind_count;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				if (!(_tmp30_ < _tmp31_)) {
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					break;
#line 660 "BlindsEffect.c"
				}
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp32_ = ctx;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp33_ = self->priv->to_blinds;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp33__length1 = self->priv->to_blinds_length1;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp34_ = i;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp35_ = _tmp33_[_tmp34_];
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp36_ = x;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp37_ = i;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp38_ = self->priv->current_blind_width;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp39_ = y;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				cairo_set_source_surface (_tmp32_, _tmp35_, (gdouble) (_tmp36_ + (_tmp37_ * _tmp38_)), (gdouble) _tmp39_);
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp40_ = ctx;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp41_ = x;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp42_ = i;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp43_ = self->priv->current_blind_width;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp44_ = y;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp45_ = self->priv->current_blind_width;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp46_ = alpha;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp47_ = visuals;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp48_ = spit_transitions_visuals_get_to_pixbuf (_tmp47_);
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp49_ = _tmp48_;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp50_ = gdk_pixbuf_get_height (_tmp49_);
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp51_ = _tmp50_;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				cairo_rectangle (_tmp40_, (gdouble) (_tmp41_ + (_tmp42_ * _tmp43_)), (gdouble) _tmp44_, _tmp45_ * (_tmp46_ + 0.5), (gdouble) _tmp51_);
#line 84 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp52_ = ctx;
#line 84 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				cairo_fill (_tmp52_);
#line 712 "BlindsEffect.c"
			}
		}
	}
#line 87 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp53_ = ctx;
#line 87 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	cairo_clip (_tmp53_);
#line 88 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp54_ = ctx;
#line 88 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	cairo_paint (_tmp54_);
#line 724 "BlindsEffect.c"
}


static void blinds_effect_real_advance (SpitTransitionsEffect* base, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion, gint frame_number) {
	BlindsEffect * self;
#line 91 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BLINDS_EFFECT, BlindsEffect);
#line 91 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 91 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 736 "BlindsEffect.c"
}


static void blinds_effect_real_cancel (SpitTransitionsEffect* base) {
	BlindsEffect * self;
#line 94 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BLINDS_EFFECT, BlindsEffect);
#line 744 "BlindsEffect.c"
}


static void blinds_effect_class_init (BlindsEffectClass * klass) {
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	blinds_effect_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_type_class_add_private (klass, sizeof (BlindsEffectPrivate));
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	G_OBJECT_CLASS (klass)->finalize = blinds_effect_finalize;
#line 755 "BlindsEffect.c"
}


static void blinds_effect_spit_transitions_effect_interface_init (SpitTransitionsEffectIface * iface) {
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	blinds_effect_spit_transitions_effect_parent_iface = g_type_interface_peek_parent (iface);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	iface->get_fps = (void (*)(SpitTransitionsEffect*, gint*, gint*)) blinds_effect_real_get_fps;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	iface->needs_clear_background = (gboolean (*)(SpitTransitionsEffect*)) blinds_effect_real_needs_clear_background;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	iface->start = (void (*)(SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*)) blinds_effect_real_start;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	iface->paint = (void (*)(SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, cairo_t*, gint, gint, gint)) blinds_effect_real_paint;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	iface->advance = (void (*)(SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, gint)) blinds_effect_real_advance;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	iface->cancel = (void (*)(SpitTransitionsEffect*)) blinds_effect_real_cancel;
#line 774 "BlindsEffect.c"
}


static void blinds_effect_instance_init (BlindsEffect * self) {
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self->priv = BLINDS_EFFECT_GET_PRIVATE (self);
#line 781 "BlindsEffect.c"
}


static void blinds_effect_finalize (GObject* obj) {
	BlindsEffect * self;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BLINDS_EFFECT, BlindsEffect);
#line 35 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self->priv->to_blinds = (_vala_array_free (self->priv->to_blinds, self->priv->to_blinds_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	G_OBJECT_CLASS (blinds_effect_parent_class)->finalize (obj);
#line 793 "BlindsEffect.c"
}


GType blinds_effect_get_type (void) {
	static volatile gsize blinds_effect_type_id__volatile = 0;
	if (g_once_init_enter (&blinds_effect_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BlindsEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) blinds_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BlindsEffect), 0, (GInstanceInitFunc) blinds_effect_instance_init, NULL };
		static const GInterfaceInfo spit_transitions_effect_info = { (GInterfaceInitFunc) blinds_effect_spit_transitions_effect_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType blinds_effect_type_id;
		blinds_effect_type_id = g_type_register_static (G_TYPE_OBJECT, "BlindsEffect", &g_define_type_info, 0);
		g_type_add_interface_static (blinds_effect_type_id, SPIT_TRANSITIONS_TYPE_EFFECT, &spit_transitions_effect_info);
		g_once_init_leave (&blinds_effect_type_id__volatile, blinds_effect_type_id);
	}
	return blinds_effect_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



