C
C  This file is part of MUMPS 4.8.3, built on Wed Sep 24 17:11:30 UTC 2008
C
C
C  This version of MUMPS is provided to you free of charge. It is public
C  domain, based on public domain software developed during the Esprit IV
C  European project PARASOL (1996-1999) by CERFACS, ENSEEIHT-IRIT and RAL.
C  Since this first public domain version in 1999, the developments are
C  supported by the following institutions: CERFACS, ENSEEIHT-IRIT, and
C  INRIA.
C
C  Main contributors are Patrick Amestoy, Iain Duff, Abdou Guermouche,
C  Jacko Koster, Jean-Yves L'Excellent, and Stephane Pralet.
C
C  Up-to-date copies of the MUMPS package can be obtained
C  from the Web pages:
C  http://mumps.enseeiht.fr/  or  http://graal.ens-lyon.fr/MUMPS
C
C
C   THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY
C   EXPRESSED OR IMPLIED. ANY USE IS AT YOUR OWN RISK.
C
C
C  User documentation of any code that uses this software can
C  include this complete notice. You can acknowledge (using
C  references [1], [2], and [3]) the contribution of this package
C  in any scientific publication dependent upon the use of the
C  package. You shall use reasonable endeavours to notify
C  the authors of the package of this publication.
C
C   [1] P. R. Amestoy, I. S. Duff and  J.-Y. L'Excellent,
C   Multifrontal parallel distributed symmetric and unsymmetric solvers,
C   in Comput. Methods in Appl. Mech. Eng., 184,  501-520 (2000).
C
C   [2] P. R. Amestoy, I. S. Duff, J. Koster and  J.-Y. L'Excellent,
C   A fully asynchronous multifrontal solver using distributed dynamic
C   scheduling, SIAM Journal of Matrix Analysis and Applications,
C   Vol 23, No 1, pp 15-41 (2001).
C
C   [3] P. R. Amestoy and A. Guermouche and J.-Y. L'Excellent and
C   S. Pralet, Hybrid scheduling for the parallel solution of linear
C   systems. Parallel Computing Vol 32 (2), pp 136-156 (2006).
C
      MODULE MUMPS_OOC_COMMON
      IMPLICIT NONE
      INTEGER FCT
      PARAMETER(FCT=0)
      INTEGER, PUBLIC  ::  TYPEF_L, TYPEF_U, TYPEF_CB
      PARAMETER ( TYPEF_L=1, TYPEF_U=2, TYPEF_CB=3)
      INTEGER OOC_NB_FILE_TYPE,OOC_FCT_TYPE      
      INTEGER, DIMENSION(:,:),POINTER :: OOC_INODE_SEQUENCE
      INTEGER*8, DIMENSION(:,:),POINTER :: OOC_VADDR
      INTEGER,DIMENSION(:),POINTER:: KEEP_OOC
      INTEGER ICNTL1 
      INTEGER*8, DIMENSION(:),ALLOCATABLE :: AddVirtLibre
      LOGICAL,SAVE :: STRAT_IO_ASYNC,WITH_BUF,SOLVE,IS_INIT_CALLED
      INTEGER, DIMENSION(:),POINTER :: STEP_OOC,PROCNODE_OOC
      INTEGER, SAVE :: MYID_OOC,SLAVEF_OOC,LOW_LEVEL_STRAT_IO
      INTEGER, SAVE :: HBUF_SIZE,DIM_BUF_IO
      INTEGER ERR_STR_OOC_MAX_LEN
      PARAMETER(ERR_STR_OOC_MAX_LEN = 512)
      CHARACTER*1 ERR_STR_OOC(ERR_STR_OOC_MAX_LEN)
      INTEGER DIM_ERR_STR_OOC
      TYPE IO_BLOCK
        INTEGER :: INODE          
        LOGICAL :: MASTER         
        INTEGER :: Typenode       
        INTEGER :: NROW, NCOL, NFS 
        LOGICAL :: Last           
        INTEGER :: LastPiv        
        INTEGER :: LastPanelWritten_L 
        INTEGER :: LastPanelWritten_U 
        INTEGER,POINTER,DIMENSION(:) :: INDICES
      END TYPE
      PUBLIC IO_BLOCK
      INTEGER, PUBLIC :: STRAT_WRITE_MAX, STRAT_TRY_WRITE
      PARAMETER (STRAT_WRITE_MAX=1, STRAT_TRY_WRITE=2)
      END MODULE MUMPS_OOC_COMMON
      SUBROUTINE MUMPS_676(INT1,INT2,VADDR_ARG)
      IMPLICIT NONE
      INTEGER INT1,INT2
      INTEGER*8 VADDR_ARG
      INTEGER*8 TMP1,TMP2,CONV
      PARAMETER (CONV=2000000000)
      TMP1=INT1
      TMP2=INT2
      VADDR_ARG=(INT1*CONV)+INT2
      RETURN
      END SUBROUTINE MUMPS_676
      SUBROUTINE MUMPS_677(INT1,INT2,VADDR_ARG)
      IMPLICIT NONE
      INTEGER INT1,INT2
      INTEGER*8 VADDR_ARG
      INTEGER*8 TMP1,TMP2,CONV
      PARAMETER (CONV=2000000000)
      TMP1=VADDR_ARG/CONV
      TMP2=mod(VADDR_ARG,CONV)
      INT1=int(TMP1)
      INT2=int(TMP2)
      RETURN
      END SUBROUTINE MUMPS_677
