
#include "pam_unixds.h"

#define PAM_SM_AUTH

#include <security/pam_modules.h>

/**
  * PAM entry point for authentication. Performs an xmlrpc call to validate 
  * (and optionally sync) a password.
  */
PAM_EXTERN int
pam_sm_authenticate (pam_handle_t * pamh, int flags, int argc, const char **argv)
{
  const char* procname = "pam_sm_authenticate";
  xmlrpc_env env;
  xmlrpc_value *result;
  xmlrpc_server_info *server;

  int pcnt = 0;
  char *serviceURL = NULL;
  char *serviceCall = NULL;
  char *serviceOld = NULL;
  char *basicAuthUser = NULL;
  char *basicAuthPass = NULL;

  const char *user = NULL, *password = NULL;
  const char *service = NULL;
  int authenticated=0;

  //sleep(30);

  /* read parameters */
  for (pcnt=0; pcnt<argc; pcnt++) {
    {
      if (strncmp
	  (argv[pcnt], SERVICEURL "=", sizeof (SERVICEURL "=") - 1) == 0)
	{
	  serviceURL = (char *) argv[pcnt] + sizeof (SERVICEURL);
	}			// if - serviceurl parameter
      else
	if (strncmp
	    (argv[pcnt], SERVICECALL "=", sizeof (SERVICECALL "=") - 1) == 0)
	{
	  serviceCall = (char *) argv[pcnt] + sizeof (SERVICECALL);
	}			// else if - servicecall parameter
      else
	if (strncmp (argv[pcnt], SERVICE "=", sizeof (SERVICE "=") - 1) == 0)
	{
	  serviceOld = (char *) argv[pcnt] + sizeof (SERVICE);
	}			// else if - service parameter
      else if (strncmp (argv[pcnt], AUTHUSER "=", sizeof (AUTHUSER "=") - 1) == 0)
	{
	  basicAuthUser = (char *) argv[pcnt] + sizeof (AUTHUSER);
	}			// else if - authuser parameter
      else if (strncmp (argv[pcnt], AUTHPASS "=", sizeof (AUTHPASS "=") - 1) == 0)
	{
	  basicAuthPass = (char *) argv[pcnt] + sizeof (AUTHPASS);
	}			// else if - authpass parameter
    }
  }

  /* check parameters */
  if (!serviceURL)
    {
      __pam_log (LOG_ERR,
	       "%s: module not properly configured - missing parameter: serviceurl", procname);
      return PAM_AUTH_ERR;
    }				// if - serviceurl not configured
  if (!serviceCall)
    {
      __pam_log (LOG_ERR, 
	       "%s: module not properly configured - missing parameter: servicecall", procname);
      return PAM_AUTH_ERR;
    }				// if - servicecall not configured
  
  if (pam_get_item (pamh, PAM_USER, (void *) &user) != PAM_SUCCESS)
    {
      __pam_log (LOG_ERR, "%s: username not available", procname);
      return PAM_AUTH_ERR;
    }				// if - no service
  if (pam_get_item (pamh, PAM_SERVICE, (void *) &service) != PAM_SUCCESS)
    {
      __pam_log (LOG_ERR, "%s: service not available", procname);
      return PAM_AUTH_ERR;
    }				// if - no service

  if (serviceOld)
    {
      __pam_log (LOG_INFO, "%s: parameter 'service' is deprecated!", procname);
      service = serviceOld;
    }

  /* get password */
  pam_get_item(pamh, PAM_AUTHTOK, (void *) &password);
  if (!password)
    {
      _set_auth_tok(pamh, flags, argc, argv);
      pam_get_item(pamh, PAM_AUTHTOK, (void *) &password);
    }				// if - no password
  
  /* init xmlrpc */
  xmlrpc_client_init (XMLRPC_CLIENT_NO_FLAGS, NAME, VERSION);
  xmlrpc_env_init (&env);
  server = xmlrpc_server_info_new (&env, serviceURL);
  if (basicAuthUser && basicAuthPass)
	xmlrpc_server_info_set_basic_auth(&env, server, basicAuthUser, basicAuthPass);
  
  /* call xmlrpc */
  result =
    xmlrpc_client_call_server (&env, server, serviceCall, "(ss)", 
                               user, password);
  if (env.fault_occurred)
    {
      __pam_log (LOG_ERR, "%s: XML-RPC Fault on calling %s on %s: %s (%d)",
	       procname, serviceCall, serviceURL, env.fault_string, env.fault_code);
      return PAM_AUTH_ERR;
    }				// if - xmlrpc error

  authenticated = get_int (&env, result)==0;

  /* dispose xmlrpc */
  xmlrpc_DECREF (result);
  xmlrpc_env_clean (&env);
  xmlrpc_client_cleanup ();

  if (authenticated)
    {
      __pam_log (LOG_INFO, "%s: user %s authenticated", procname, user);
      return PAM_SUCCESS;
    }				// if - success
  else
    {
      __pam_log (LOG_ERR, "%s: authentication failed for service %s, user %s",
	       procname, service, user);
      return PAM_AUTH_ERR;
    }				// else - password failed
}				// pam_sm_authenticate

/* another expected hook */
PAM_EXTERN int pam_sm_setcred(pam_handle_t *pamh, int flags,
			      int argc, const char **argv)
{
  const char* procname = "pam_sm_setcred";
  return PAM_SUCCESS;
}


