/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.engine;

import com.novell.gw.ab.Address;
import com.novell.gw.ab.AddressBookManager;
import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.PersonalAddressBook;
import com.novell.gw.account.Account;
import com.novell.gw.account.AccountSettings;
import com.novell.gw.account.ImapAccount;
import com.novell.gw.account.NntpAccount;
import com.novell.gw.account.Pop3Account;
import com.novell.gw.engine.Category;
import com.novell.gw.engine.ColumnFieldInfo;
import com.novell.gw.engine.DataStoreListener;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.engine.DisplaySettings;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.EngineUtils;
import com.novell.gw.engine.Item;
import com.novell.gw.engine.ItemList;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.engine.JunkMail;
import com.novell.gw.engine.ProxyAccessList;
import com.novell.gw.engine.ProxyHistoryList;
import com.novell.gw.folder.Folder;
import com.novell.gw.folder.FolderChangeEvent;
import com.novell.gw.folder.FolderSharedList;
import com.novell.gw.message.Message;
import com.novell.gw.notification.NotifySubscribeList;
import com.novell.gw.rules.RuleList;
import com.novell.gw.rules.VacationRuleInfo;
import com.novell.gw.util.Debug;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class DataStore {
    public static final int ACCESS_REQUEST_TYPE_ITEM_CREATE = 1;
    public static final int ACCESS_REQUEST_TYPE_ITEM_DELETE = 2;
    public static final int ACCESS_REQUEST_TYPE_ITEM_READ = 3;
    public static final int ACCESS_REQUEST_TYPE_ITEM_WRITE = 4;
    public static final int ACCESS_REQUEST_TYPE_OPEN_ARCHIVEDB = 5;
    public static final int ACCESS_REQUEST_TYPE_SET_ALARM = 6;
    public static final int ACCESS_REQUEST_TYPE_EDIT_PREFS = 7;
    public static final int ACCESS_REQUEST_TYPE_EDIT_RULES = 8;
    public static final int ACCESS_REQUEST_TYPE_EDIT_PERS_GROUPS = 9;
    public static final int ACCESS_REQUEST_TYPE_ITEM_ARCHIVE = 10;
    public static final int ACCESS_REQUEST_TYPE_ADD_FOLDER = 11;
    public static final int ACCESS_REQUEST_TYPE_RENAME_FOLDER = 12;
    public static final int ACCESS_REQUEST_TYPE_DELETE_FOLDER = 13;
    public static final int ACCESS_REQUEST_TYPE_MOVE_FOLDER = 14;
    public static final int ACCESS_REQUEST_TYPE_XTD_CLIENT = 15;
    private int pGWDataStore = 0;
    private int pEvents = 0;
    private EventListenerList listenerList = new EventListenerList();
    private AddressBookManager abManager;
    private Account[] accounts;
    private JunkMail junkMail;
    private static HashMap folderCache;
    private DataStoreSettings dataStoreSettings = null;
    private int displaySettingsIndex;
    public static final int DS_SUBTYPE_NORMAL = 0;
    public static final int DS_SUBTYPE_CONTACTS = 1;
    public static final int DS_SUBTYPE_ALL_VISIBLE = 2;

    private static native void initIds();

    private native void dispose(int var1, int var2);

    private native void flushSettings(int var1);

    private native int getAddressBookManager(int var1);

    private native int getAccount(int var1, String var2);

    private native int getGroupWiseAccount(int var1);

    private native int[] getAccounts(int var1);

    private native int getAccountSettings(int var1);

    private native boolean hasMailboxSpace(int var1);

    private native boolean isOnline(int var1);

    private native boolean isCaching(int var1);

    private native boolean isRemote(int var1);

    private native void sync(int var1);

    private native int subscribeToEvents(int var1);

    private native boolean canDoNntpAccounts(int var1);

    private native boolean canDoPopAndImapAccounts(int var1);

    private native int createImapAccount(int var1, String var2, String var3, String var4, String var5, String var6, String var7, int var8, int var9);

    private native int createPop3Account(int var1, String var2, String var3, String var4, String var5, String var6, String var7, int var8);

    private native int createNntpAccount(int var1, String var2, boolean var3, String var4, String var5, String var6, String var7, String var8, int var9, int var10);

    private native void deleteAccount(int var1, int var2);

    private native int[] moveAccountToIndex(int var1, int var2, int var3);

    private native int getCategory(int var1, String var2);

    private native int getCategory2(int var1, int var2);

    private native int getCategoryCount(int var1);

    private native int[] getDisplayColumnFields(int var1, boolean var2);

    private native int getDisplaySettings(int var1, String var2);

    private native int getDisplaySettingsCount(int var1, int var2);

    private native int getDisplaySettingsNextElement(int var1, int var2, int var3);

    private native int getPanelTemplateSettings(int var1, int var2);

    private native int getPanelTemplateSettingsCount(int var1);

    private native int getSavedFilter(int var1, int var2, int var3);

    private native int getSavedFilterCount(int var1, int var2);

    private native int getJunkMail(int var1);

    private native int getNotifySubscribeList(int var1);

    private native int getProxyAccessList(int var1);

    private native int getProxyHistoryList(int var1);

    private native boolean checkAccess(int var1, int var2, int var3, int var4);

    private native String getHost(int var1);

    private native String getPathToHost(int var1);

    private native String getTcpIpAddress(int var1);

    private native int getTcpIpPort(int var1);

    private native String getFileId(int var1);

    private native String getUserId(int var1);

    private native String getUserFullName(int var1);

    private native int getUserFields(int var1);

    private native int createFolder(int var1, String var2, String var3, int var4, int var5);

    private native int createContactsFolder(int var1, String var2, int var3, int var4);

    private native int createSharedFolder(int var1, String var2, String var3, int var4, int var5, int var6);

    private native int find(int var1, int var2);

    private native int find(int var1, String var2, String var3, String var4, String var5, String var6);

    private native int findFolder(int var1, int var2, int var3);

    private native int[] getRootFolders(int var1);

    private native int getSystemFolder(int var1, int var2);

    private native void emptyJunkMail(int var1);

    private native void emptyTrash(int var1);

    private native int findItem(int var1, String var2);

    private native boolean isArchiveDB(int var1);

    private native int openArchiveDB(int var1, boolean var2);

    private native boolean isBackupDB(int var1);

    private native int openBackupDB(int var1);

    private native boolean performBackupOnDB(int var1, boolean var2, boolean var3);

    private native boolean canSetOnlineMailboxPassword(int var1);

    private native void reprimeCache(int var1);

    private native void requestContacts(int var1);

    private native void requestSystemContacts(int var1);

    private native void setOnlineMailboxPassword(int var1, String var2, String var3);

    private native boolean validateOnlineMailboxPassword(int var1, String var2);

    private native boolean isGWCheckAvailable(int var1);

    private native String getGWCheckCommandArgs(int var1);

    private native String getGWCheckPath(int var1);

    private native boolean backupCheck(int var1);

    private native int[] getCalendarFolders(int var1, boolean var2);

    private native int getCalendarFoldersCount(int var1);

    private native boolean isCalendarFolderNameAlreadyExist(int var1, String var2);

    private native void initNavFolders(int var1);

    private native String[] getIcalNameAndDescription(int var1, String var2);

    private native boolean importIcalFile(int var1, String var2);

    private native boolean importIcalFile2(int var1, String var2, String var3, String var4, boolean var5);

    private native int importMimeFile(int var1, String var2) throws EngineException;

    private native void clearAllAutoSavedMessages(int var1);

    private native int getAutoSavedMessagesCount(int var1);

    private native int[] restoreAllAutoSavedMessages(int var1);

    private native void writeMemoryCachedData(int var1);

    private native boolean canMoveOrLinkItemsToFolders(int var1, int[] var2, int var3, int[] var4);

    private native boolean moveOrLinkItemsToFolders(int var1, int[] var2, int var3, int[] var4, boolean var5, boolean var6);

    private native Object[] getVacationRuleInfo(int var1);

    private native boolean isVacationRuleActive(int var1);

    private native boolean modifyVacationRule(int var1, String var2, String var3, String var4, boolean var5, long var6, long var8, boolean var10);

    public DataStore(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pGWDataStore = n;
        this.pEvents = this.subscribeToEvents(n);
    }

    public DataStore() {
    }

    public void addDataStoreListener(DataStoreListener dataStoreListener) {
        this.listenerList.add(DataStoreListener.class, dataStoreListener);
    }

    public void removeDataStoreListener(DataStoreListener dataStoreListener) {
        this.listenerList.remove(DataStoreListener.class, dataStoreListener);
    }

    public Folder createFolder(String string, String string2, Folder folder, int n) {
        Folder folder2 = null;
        if (string == null) {
            throw new NullPointerException();
        }
        int n2 = this.createFolder(this.pGWDataStore, string, string2, folder.getPointer(), n);
        if (n2 != 0) {
            folder2 = DataStore.getFolder(n2);
        }
        return folder2;
    }

    public PersonalAddressBook createContactsFolder(String string, Folder folder) {
        if (string == null) {
            throw new NullPointerException();
        }
        PersonalAddressBook personalAddressBook = null;
        int n = this.createContactsFolder(this.pGWDataStore, string, folder.getPointer(), 0);
        return personalAddressBook;
    }

    public Folder createSharedFolder(String string, String string2, Folder folder, int n, FolderSharedList folderSharedList) {
        Folder folder2 = null;
        if (string == null) {
            throw new NullPointerException();
        }
        int n2 = this.createSharedFolder(this.pGWDataStore, string, string2, folder.getPointer(), n, folderSharedList.getPointer());
        if (n2 != 0) {
            folder2 = DataStore.getFolder(n2);
        }
        return folder2;
    }

    public ImapAccount createImapAccount(String string, String string2, String string3, String string4, String string5, String string6, Folder folder, int n) {
        int n2 = 0;
        if (folder != null) {
            n2 = folder.getPointer();
        }
        int n3 = this.createImapAccount(this.pGWDataStore, string, string2, string3, string4, string5, string6, n2, n);
        return (ImapAccount)Account.createAccount(n3, this);
    }

    public Pop3Account createPop3Account(String string, String string2, String string3, String string4, String string5, String string6, Folder folder) {
        int n = this.createPop3Account(this.pGWDataStore, string, string2, string3, string4, string5, string6, folder.getPointer());
        return (Pop3Account)Account.createAccount(n, this);
    }

    public NntpAccount createNntpAccount(String string, boolean bl, String string2, String string3, String string4, String string5, String string6, Folder folder, int n) {
        int n2 = 0;
        if (folder != null) {
            n2 = folder.getPointer();
        }
        int n3 = this.createNntpAccount(this.pGWDataStore, string, bl, string2, string3, string4, string5, string6, n2, n);
        return (NntpAccount)Account.createAccount(n3, this);
    }

    public void deleteAccount(Account account) {
        this.deleteAccount(this.pGWDataStore, account.getPointer());
    }

    public RuleList getRuleList() {
        RuleList ruleList = RuleList.get(this);
        return ruleList;
    }

    public VacationRuleInfo getVacationRuleInfo() {
        VacationRuleInfo vacationRuleInfo = null;
        Object[] objectArray = this.getVacationRuleInfo(this.pGWDataStore);
        if (objectArray != null) {
            vacationRuleInfo = new VacationRuleInfo((String)objectArray[0], (String)objectArray[1], (String)objectArray[2], (Boolean)objectArray[3], EngineUtils.flaimTimeToDate((Long)objectArray[4]), EngineUtils.flaimTimeToDate((Long)objectArray[5]), (Boolean)objectArray[6]);
        }
        return vacationRuleInfo;
    }

    public boolean isVacationRuleActive() {
        return this.isVacationRuleActive(this.pGWDataStore);
    }

    public boolean modifyVacationRule(String string, String string2, String string3, boolean bl, Date date, Date date2, boolean bl2) {
        boolean bl3 = this.modifyVacationRule(this.pGWDataStore, string, string2, string3, bl, EngineUtils.DateToFlaimTime(date), EngineUtils.DateToFlaimTime(date2), bl2);
        return bl3;
    }

    public DataStoreSettings getSettings() {
        if (this.dataStoreSettings == null) {
            this.dataStoreSettings = new DataStoreSettings(this);
        }
        return this.dataStoreSettings;
    }

    public JunkMail getJunkMail() {
        if (this.junkMail == null) {
            int n = this.getJunkMail(this.pGWDataStore);
            this.junkMail = new JunkMail(n);
        }
        return this.junkMail;
    }

    public boolean hasMailboxSpace() {
        return this.hasMailboxSpace(this.pGWDataStore);
    }

    public boolean isOnline() {
        return this.isOnline(this.pGWDataStore);
    }

    public boolean isCaching() {
        return this.isCaching(this.pGWDataStore);
    }

    public boolean isRemote() {
        return this.isRemote(this.pGWDataStore);
    }

    public void sync() {
        this.sync(this.pGWDataStore);
    }

    public void emptyJunkMail() {
        this.emptyJunkMail(this.pGWDataStore);
    }

    public void emptyTrash() {
        this.emptyTrash(this.pGWDataStore);
    }

    public Folder find(ItemListFilter itemListFilter) {
        int n = this.find(this.pGWDataStore, itemListFilter.getPointer());
        return Folder.createFolder(n);
    }

    public Folder find(String string, String string2, String string3, String string4, String string5) {
        int n = this.find(this.pGWDataStore, string, string2, string3, string4, string5);
        return Folder.createFolder(n);
    }

    public Item findItem(String string) {
        int n = this.findItem(this.pGWDataStore, string);
        return Message.createMessage(n);
    }

    public Folder getSystemFolder(int n) {
        Folder folder = null;
        int n2 = this.getSystemFolder(this.pGWDataStore, n);
        if (n2 != 0) {
            folder = DataStore.getFolder(n2);
        }
        return folder;
    }

    public int getPointer() {
        return this.pGWDataStore;
    }

    public Folder[] getRootFolders() {
        int[] nArray = this.getRootFolders(this.pGWDataStore);
        Folder[] folderArray = new Folder[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            folderArray[i] = Folder.createFolder(nArray[i]);
        }
        return folderArray;
    }

    public AddressBookManager getAddressBookManager() {
        int n;
        if (this.abManager == null && (n = this.getAddressBookManager(this.pGWDataStore)) != 0) {
            this.abManager = new AddressBookManager(n);
        }
        return this.abManager;
    }

    public Account[] getAccounts() {
        int[] nArray = this.getAccounts(this.pGWDataStore);
        Account[] accountArray = new Account[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            accountArray[i] = Account.createAccount(nArray[i], this);
        }
        return accountArray;
    }

    public Account[] moveAccountToIndex(Account account, int n) {
        int[] nArray = this.moveAccountToIndex(this.pGWDataStore, account.getPointer(), n);
        Account[] accountArray = new Account[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            accountArray[i] = Account.createAccount(nArray[i], this);
        }
        return accountArray;
    }

    public Account getAccount(String string) {
        int n = this.getAccount(this.pGWDataStore, string);
        return Account.createAccount(n, this);
    }

    public Account getGroupWiseAccount() {
        int n = this.getGroupWiseAccount(this.pGWDataStore);
        return Account.createAccount(n, this);
    }

    public AccountSettings getAccountSettings() {
        int n = this.getAccountSettings(this.pGWDataStore);
        return new AccountSettings(n);
    }

    public Folder findFolder(String string) {
        Folder folder = null;
        Folder[] folderArray = this.getRootFolders();
        if (folderArray != null) {
            folder = Folder.findFolder(folderArray, string);
        }
        return folder;
    }

    public Folder findFolder(Folder folder, DataStore dataStore) {
        int n = this.findFolder(this.pGWDataStore, folder.getPointer(), dataStore.getPointer());
        return DataStore.getFolder(n);
    }

    public String getHost() {
        return this.getHost(this.pGWDataStore);
    }

    public String getPathToHost() {
        return this.getPathToHost(this.pGWDataStore);
    }

    public String getTcpIpAddress() {
        return this.getTcpIpAddress(this.pGWDataStore);
    }

    public String getTcpIpPort() {
        int n = this.getTcpIpPort(this.pGWDataStore);
        String string = String.valueOf(n);
        return string;
    }

    public static Folder getFolder(int n) {
        Folder folder = null;
        if (n != 0) {
            folder = (Folder)folderCache.get(new Integer(n));
            if (folder == null) {
                folder = Folder.createFolder(n);
                folderCache.put(new Integer(n), folder);
            } else {
                folder.releasePtr();
            }
        }
        return folder;
    }

    public String getUserFileId() {
        return this.getFileId(this.pGWDataStore);
    }

    public String getUserId() {
        return this.getUserId(this.pGWDataStore);
    }

    public String getUserFullName() {
        return this.getUserFullName(this.pGWDataStore);
    }

    public Addressable getUserFields() {
        Address address = null;
        int n = this.getUserFields(this.pGWDataStore);
        if (n != 0) {
            address = new Address(n);
        }
        return address;
    }

    public boolean isArchiveDB() {
        return this.isArchiveDB(this.pGWDataStore);
    }

    public DataStore openArchiveDB(boolean bl) {
        DataStore dataStore = null;
        int n = this.openArchiveDB(this.pGWDataStore, bl);
        if (n != 0) {
            dataStore = new DataStore(n);
        }
        return dataStore;
    }

    public boolean canDoNntpAccounts() {
        return this.canDoNntpAccounts(this.pGWDataStore);
    }

    public boolean canDoPopAndImapAccounts() {
        return this.canDoPopAndImapAccounts(this.pGWDataStore);
    }

    public boolean canSetOnlineMailboxPassword() {
        return this.canSetOnlineMailboxPassword(this.pGWDataStore);
    }

    public boolean validateOnlineMailboxPassword(String string) {
        return this.validateOnlineMailboxPassword(this.pGWDataStore, string);
    }

    public void reprimeCache() {
        this.reprimeCache(this.pGWDataStore);
    }

    public void requestContacts() {
        this.requestContacts(this.pGWDataStore);
    }

    public void requestSystemContacts() {
        this.requestSystemContacts(this.pGWDataStore);
    }

    public void setOnlineMailboxPassword(String string, String string2) {
        this.setOnlineMailboxPassword(this.pGWDataStore, string, string2);
    }

    public boolean isBackupDB() {
        return this.isBackupDB(this.pGWDataStore);
    }

    public DataStore openBackupDB() {
        DataStore dataStore = null;
        int n = this.openBackupDB(this.pGWDataStore);
        if (n != 0) {
            dataStore = new DataStore(n);
        }
        return dataStore;
    }

    public boolean performBackupOnDB(boolean bl, boolean bl2) {
        boolean bl3 = this.performBackupOnDB(this.pGWDataStore, bl, bl2);
        return bl3;
    }

    public Folder[] getCalendarFolders() {
        return this.getCalendarFolders(true);
    }

    public Folder[] getCalendarFolders(boolean bl) {
        int[] nArray = this.getCalendarFolders(this.pGWDataStore, bl);
        int n = nArray != null ? nArray.length : 0;
        Folder[] folderArray = new Folder[n];
        for (int i = 0; i < n; ++i) {
            folderArray[i] = DataStore.getFolder(nArray[i]);
        }
        return folderArray;
    }

    public int getCalendarFoldersCount() {
        return this.getCalendarFoldersCount(this.pGWDataStore);
    }

    public boolean isCalendarFolderNameAlreadyExist(String string) {
        return this.isCalendarFolderNameAlreadyExist(this.pGWDataStore, string);
    }

    public void initNavFolders() {
        this.initNavFolders(this.pGWDataStore);
    }

    public Category getCategory(String string) {
        return Category.create(this.getCategory(this.pGWDataStore, string));
    }

    public Category getCategory(int n) {
        Category category = null;
        int n2 = this.getCategory2(this.pGWDataStore, n);
        if (n2 != 0) {
            category = new Category(n2);
        }
        return category;
    }

    public int getCategoryCount() {
        int n = this.getCategoryCount(this.pGWDataStore);
        return n;
    }

    public Enumeration getCategoryEnumeration() {
        return new CategoryEnumeration(0);
    }

    public ColumnFieldInfo[] getDisplayColumnFields(boolean bl) {
        int[] nArray = this.getDisplayColumnFields(this.pGWDataStore, bl);
        int n = nArray != null ? nArray.length : 0;
        ColumnFieldInfo[] columnFieldInfoArray = new ColumnFieldInfo[n];
        for (int i = 0; i < n; ++i) {
            columnFieldInfoArray[i] = new ColumnFieldInfo(nArray[i]);
        }
        return columnFieldInfoArray;
    }

    public DisplaySettings getDisplaySettings(String string) {
        DisplaySettings displaySettings = null;
        int n = this.getDisplaySettings(this.pGWDataStore, string);
        if (n != 0) {
            displaySettings = new DisplaySettings(n);
        }
        return displaySettings;
    }

    public int getDisplaySettingsCount(int n) {
        return this.getDisplaySettingsCount(this.pGWDataStore, n);
    }

    public DisplaySettings getPanelTemplateSettings(int n) {
        DisplaySettings displaySettings = null;
        int n2 = this.getPanelTemplateSettings(this.pGWDataStore, n);
        if (n2 != 0) {
            displaySettings = new DisplaySettings(n2);
        }
        return displaySettings;
    }

    public int getPanelTemplateSettingsCount() {
        return this.getPanelTemplateSettingsCount(this.pGWDataStore);
    }

    public ItemListFilter getSavedFilter(int n, int n2) {
        ItemListFilter itemListFilter = null;
        int n3 = this.getSavedFilter(this.pGWDataStore, n, n2);
        if (n3 != 0) {
            itemListFilter = new ItemListFilter(0, n3);
        }
        return itemListFilter;
    }

    public int getSavedFilterCount(int n) {
        return this.getSavedFilterCount(this.pGWDataStore, n);
    }

    public Enumeration getDisplaySettingsEnumeration(int n) {
        return new DisplaySettingsEnumeration(-1, n);
    }

    public NotifySubscribeList getNotifySubscribeList() {
        int n = this.getNotifySubscribeList(this.pGWDataStore);
        return new NotifySubscribeList(n);
    }

    public ProxyAccessList getProxyAccessList() {
        int n = this.getProxyAccessList(this.pGWDataStore);
        return new ProxyAccessList(n);
    }

    public ProxyHistoryList getProxyHistoryList() {
        int n = this.getProxyHistoryList(this.pGWDataStore);
        return new ProxyHistoryList(n);
    }

    public String[] getIcalNameAndDescription(String string) {
        String[] stringArray = this.getIcalNameAndDescription(this.pGWDataStore, string);
        return stringArray;
    }

    public boolean importIcalFile(String string) {
        boolean bl = this.importIcalFile(this.pGWDataStore, string);
        return bl;
    }

    public boolean importIcalFile(String string, String string2, String string3, boolean bl) {
        boolean bl2 = this.importIcalFile2(this.pGWDataStore, string, string2, string3, bl);
        return bl2;
    }

    public Message importMimeFile(String string) throws EngineException {
        int n = this.importMimeFile(this.pGWDataStore, string);
        return (Message)Item.createItem(n);
    }

    public boolean checkAccess(int n, int n2, int n3) {
        return this.checkAccess(this.pGWDataStore, n, n2, n3);
    }

    public boolean isGWCheckAvailable() {
        return this.isGWCheckAvailable(this.pGWDataStore);
    }

    private static Process _launchGWCheck(String[] stringArray) {
        try {
            return Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void flushSettings() {
        this.flushSettings(this.pGWDataStore);
    }

    public void dispose() {
        if (this.pGWDataStore != 0 || this.pEvents != 0) {
            this.dispose(this.pGWDataStore, this.pEvents);
            this.pEvents = 0;
            this.pGWDataStore = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private void folderChanged(int n, int n2, int n3) {
        Debug.trace("DataStoreEvent[" + this.pGWDataStore + "].FOLDER_CHANGED: " + n + ", folder: " + n2 + ", parent: " + n3);
        final Object[] objectArray = this.listenerList.getListenerList();
        if (objectArray.length > 0) {
            final FolderChangeEvent folderChangeEvent = new FolderChangeEvent(this, n, DataStore.getFolder(n2), DataStore.getFolder(n3));
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DataStore.this.doFolderChanged(objectArray, folderChangeEvent);
                }
            });
        }
    }

    private void doFolderChanged(Object[] objectArray, FolderChangeEvent folderChangeEvent) {
        for (int i = 1; i < objectArray.length; i += 2) {
            DataStoreListener dataStoreListener = (DataStoreListener)objectArray[i];
            dataStoreListener.folderChanged(folderChangeEvent);
        }
    }

    private void foldersChanged() {
        Debug.trace("DataStoreEvent[" + this.pGWDataStore + "].FOLDERS_CHANGED: ");
        final Object[] objectArray = this.listenerList.getListenerList();
        if (objectArray.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DataStore.this.doFoldersChanged(objectArray);
                }
            });
        }
    }

    private void doFoldersChanged(Object[] objectArray) {
        for (int i = 1; i < objectArray.length; i += 2) {
            DataStoreListener dataStoreListener = (DataStoreListener)objectArray[i];
            dataStoreListener.foldersChanged();
        }
    }

    private void settingsChanged(int n) {
        Debug.trace("DataStoreEvent[" + this.pGWDataStore + "].SETTINGS_CHANGED: ");
        final Object[] objectArray = this.listenerList.getListenerList();
        if (objectArray.length > 0) {
            final int n2 = n;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DataStore.this.doSettingsChanged(objectArray, n2);
                }
            });
        }
    }

    private void doSettingsChanged(Object[] objectArray, int n) {
        for (int i = 1; i < objectArray.length; i += 2) {
            DataStoreListener dataStoreListener = (DataStoreListener)objectArray[i];
            dataStoreListener.settingsChanged(n);
        }
    }

    public void writeMemoryCachedData() {
        this.writeMemoryCachedData(this.pGWDataStore);
    }

    public void clearAllAutoSavedMessages() {
        this.clearAllAutoSavedMessages(this.pGWDataStore);
    }

    public int getAutoSavedMessagesCount() {
        return this.getAutoSavedMessagesCount(this.pGWDataStore);
    }

    public Item[] restoreAllAutoSavedMessages() {
        Item[] itemArray = this.createItemArray(this.restoreAllAutoSavedMessages(this.pGWDataStore));
        return itemArray;
    }

    private Item[] createItemArray(int[] nArray) {
        Item[] itemArray = null;
        if (nArray != null) {
            itemArray = new Item[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                itemArray[i] = Item.createItem(nArray[i]);
            }
        }
        return itemArray;
    }

    public boolean canMoveOrLinkItemsToFolders(Item[] itemArray, Folder folder, Folder[] folderArray) {
        boolean bl = false;
        int[] nArray = ItemList.getPointers(itemArray);
        int[] nArray2 = Folder.getPointers(folderArray);
        if (nArray != null && nArray2 != null) {
            bl = this.canMoveOrLinkItemsToFolders(this.pGWDataStore, nArray, folder.getPointer(), nArray2);
        }
        return bl;
    }

    public boolean moveOrLinkItemsToFolders(Item[] itemArray, Folder folder, Folder[] folderArray, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int[] nArray = ItemList.getPointers(itemArray);
        int[] nArray2 = Folder.getPointers(folderArray);
        if (nArray != null && nArray2 != null) {
            bl3 = this.moveOrLinkItemsToFolders(this.pGWDataStore, nArray, folder.getPointer(), nArray2, bl, bl2);
        }
        return bl3;
    }

    static {
        DataStore.initIds();
        folderCache = new HashMap();
    }

    private class DisplaySettingsEnumeration
    implements Enumeration {
        int index;
        int subType;
        int numLeft;

        public DisplaySettingsEnumeration(int n, int n2) {
            this.index = n;
            this.subType = n2;
            this.numLeft = DataStore.this.getDisplaySettingsCount(DataStore.this.pGWDataStore, n2);
        }

        public boolean hasMoreElements() {
            return this.numLeft > 0;
        }

        public synchronized Object nextElement() {
            --this.numLeft;
            DisplaySettings displaySettings = null;
            int n = DataStore.this.getDisplaySettingsNextElement(DataStore.this.pGWDataStore, this.index, this.subType);
            if (n != 0) {
                this.index = DataStore.this.displaySettingsIndex;
                displaySettings = new DisplaySettings(n);
            } else {
                this.numLeft = 0;
            }
            return displaySettings;
        }
    }

    private class CategoryEnumeration
    implements Enumeration {
        int index;
        int numLeft;

        public CategoryEnumeration(int n) {
            this.index = n;
            this.numLeft = DataStore.this.getCategoryCount(DataStore.this.pGWDataStore);
        }

        public boolean hasMoreElements() {
            return this.numLeft > 0;
        }

        public synchronized Object nextElement() {
            --this.numLeft;
            Category category = null;
            int n = DataStore.this.getCategory2(DataStore.this.pGWDataStore, this.index);
            if (n != 0) {
                ++this.index;
                category = new Category(n);
            } else {
                this.numLeft = 0;
            }
            return category;
        }
    }
}

