/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.engine;

import com.novell.gw.engine.CategoryList;
import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.EngineUtils;
import com.novell.gw.engine.Filter;
import com.novell.gw.folder.Folder;
import java.util.Date;

public class ItemListFilter {
    protected static final int FILTER_TYPE_BOX = 0;
    protected static final int FILTER_TYPE_SYSTEM_ADDRESS_BOOK = 1;
    protected static final int FILTER_TYPE_PERSONAL_ADDRESS_BOOK = 2;
    private int pFilter;

    private static native int create(int var0);

    private static native int create2(int var0);

    private native void dispose(int var1);

    private native String generateDescription(int var1);

    private native boolean canShowAsSimple(int var1, int var2);

    private native void save(int var1, String var2, boolean var3, int var4);

    private native void delete(int var1, int var2);

    private native boolean getShowOnMenu(int var1);

    private native boolean setContactType(int var1, int var2);

    private native int getContactType(int var1);

    private native void setQuickFilter(int var1, String var2, boolean var3);

    private native String getQuickFilterText(int var1);

    private native String getName(int var1);

    private native boolean setSubject(int var1, String var2, boolean var3);

    private native String getSubjectText(int var1);

    private native boolean setToCc(int var1, String var2);

    private native String getToCcText(int var1);

    private native void setDateValue(int var1, int var2, long var3, boolean var5);

    private native void setDateRange(int var1, int var2, long var3, long var5);

    private native void setUserCreateDateRange(int var1, long var2, long var4);

    private native int getBoxType(int var1);

    private native boolean setBoxType(int var1, int var2);

    private native boolean isUserFilteringBoxType(int var1);

    private native String getMessage(int var1);

    private native boolean setMessage(int var1, String var2);

    private native String getFromText(int var1);

    private native boolean setFromText(int var1, String var2);

    private native int getItemType(int var1);

    private native boolean setItemType(int var1, int var2);

    private native int getCategories(int var1, int var2);

    private native void setCategories(int var1, int var2);

    private native boolean getFilteringAllAttachments(int var1);

    private native void setFilteringAllAttachments(int var1, boolean var2);

    private native void setCalendarSubfoldersOff(int var1, int var2, int var3);

    private native String getDisplayName(int var1);

    private native boolean setDisplayName(int var1, String var2);

    private native String getEmailAddress(int var1);

    private native boolean setEmailAddress(int var1, String var2);

    private native String getLastName(int var1);

    private native boolean setLastName(int var1, String var2);

    private native String getFirstName(int var1);

    private native boolean setFirstName(int var1, String var2);

    private native String getOrganization(int var1);

    private native boolean setOrganization(int var1, String var2);

    private native String getDepartment(int var1);

    private native boolean setDepartment(int var1, String var2);

    public ItemListFilter() {
        this(0, ItemListFilter.create(0));
    }

    public ItemListFilter(Filter filter) {
        this(0, ItemListFilter.create2(filter.getPointer()));
    }

    protected ItemListFilter(int n) {
        this(0, ItemListFilter.create(n));
    }

    protected ItemListFilter(int n, int n2) {
        this.pFilter = n2;
    }

    public int getPointer() {
        return this.pFilter;
    }

    public String generateDescription() {
        String string = this.generateDescription(this.pFilter);
        return string;
    }

    public boolean canShowAsSimple(DataStore dataStore) {
        int n = dataStore.getPointer();
        return this.canShowAsSimple(this.pFilter, n);
    }

    public void save(String string, boolean bl, DataStore dataStore) {
        this.save(this.pFilter, string, bl, dataStore.getPointer());
    }

    public void delete(DataStore dataStore) {
        this.delete(this.pFilter, dataStore.getPointer());
    }

    public boolean getShowOnMenu() {
        return this.getShowOnMenu(this.pFilter);
    }

    protected boolean setContactType(int n) {
        return this.setContactType(this.pFilter, n);
    }

    protected int getContactType() {
        return this.getContactType(this.pFilter);
    }

    public void setDateValue(int n, Date date, boolean bl) {
        long l = EngineUtils.DateToFlaimTime(date);
        this.setDateValue(n, l, bl);
    }

    public void setDateValue(int n, long l, boolean bl) {
        this.setDateValue(this.pFilter, n, l, bl);
    }

    public void setDateRange(int n, Date date, Date date2) {
        long l = EngineUtils.DateToFlaimTime(date);
        long l2 = EngineUtils.DateToFlaimTime(date2);
        this.setDateRange(this.pFilter, n, l, l2);
    }

    public void setUserCreateDateRange(Date date, Date date2) {
        long l = EngineUtils.DateToFlaimTime(date);
        long l2 = EngineUtils.DateToFlaimTime(date2);
        this.setUserCreateDateRange(this.pFilter, l, l2);
    }

    public void setQuickFilter(String string, boolean bl) {
        this.setQuickFilter(this.pFilter, string, bl);
    }

    public String getQuickFilterText() {
        String string = this.getQuickFilterText(this.pFilter);
        return string;
    }

    public String getName() {
        String string = this.getName(this.pFilter);
        return string;
    }

    public boolean setSubject(String string) {
        return this.setSubject(string, false);
    }

    public boolean setSubject(String string, boolean bl) {
        boolean bl2 = this.setSubject(this.pFilter, string, bl);
        return bl2;
    }

    public String getSubjectText() {
        String string = this.getSubjectText(this.pFilter);
        return string;
    }

    public boolean setToCc(String string) {
        return this.setToCc(this.pFilter, string);
    }

    public String getToCcText() {
        String string = this.getToCcText(this.pFilter);
        return string;
    }

    public int getBoxType() {
        int n = this.getBoxType(this.pFilter);
        return n;
    }

    public boolean setBoxType(int n) {
        boolean bl = this.setBoxType(this.pFilter, n);
        return bl;
    }

    public boolean isUserFilteringBoxType() {
        boolean bl = this.isUserFilteringBoxType(this.pFilter);
        return bl;
    }

    public String getMessage() {
        String string = this.getMessage(this.pFilter);
        return string;
    }

    public boolean setMessage(String string) {
        boolean bl = this.setMessage(this.pFilter, string);
        return bl;
    }

    public String getFromText() {
        String string = this.getFromText(this.pFilter);
        return string;
    }

    public boolean setFromText(String string) {
        boolean bl = this.setFromText(this.pFilter, string);
        return bl;
    }

    public int getItemType() {
        int n = this.getItemType(this.pFilter);
        return n;
    }

    public boolean setItemType(int n) {
        boolean bl = this.setItemType(this.pFilter, n);
        return bl;
    }

    public CategoryList getCategories(DataStore dataStore) {
        return CategoryList.create(this.getCategories(this.pFilter, dataStore.getPointer()));
    }

    public void setCategories(CategoryList categoryList) {
        this.setCategories(this.pFilter, categoryList.getPointer());
    }

    public boolean getFilteringAllAttachments() {
        return this.getFilteringAllAttachments(this.pFilter);
    }

    public void setFilteringAllAttachments(boolean bl) {
        this.setFilteringAllAttachments(this.pFilter, bl);
    }

    public void setCalendarSubfoldersOff(DataStore dataStore, Folder folder) {
        if (folder != null) {
            this.setCalendarSubfoldersOff(this.pFilter, dataStore != null ? dataStore.getPointer() : 0, folder.getPointer());
        }
    }

    public String getDisplayName() {
        String string = this.getDisplayName(this.pFilter);
        return string;
    }

    public boolean setDisplayName(String string) {
        boolean bl = this.setDisplayName(this.pFilter, string);
        return bl;
    }

    public String getEmailAddress() {
        String string = this.getEmailAddress(this.pFilter);
        return string;
    }

    public boolean setEmailAddress(String string) {
        boolean bl = this.setEmailAddress(this.pFilter, string);
        return bl;
    }

    public String getLastName() {
        String string = this.getLastName(this.pFilter);
        return string;
    }

    public boolean setLastName(String string) {
        boolean bl = this.setLastName(this.pFilter, string);
        return bl;
    }

    public String getFirstName() {
        String string = this.getFirstName(this.pFilter);
        return string;
    }

    public boolean setFirstName(String string) {
        boolean bl = this.setFirstName(this.pFilter, string);
        return bl;
    }

    public String getOrganization() {
        String string = this.getOrganization(this.pFilter);
        return string;
    }

    public boolean setOrganization(String string) {
        boolean bl = this.setOrganization(this.pFilter, string);
        return bl;
    }

    public String getDepartment() {
        String string = this.getDepartment(this.pFilter);
        return string;
    }

    public boolean setDepartment(String string) {
        boolean bl = this.setDepartment(this.pFilter, string);
        return bl;
    }

    public void dispose() {
        if (this.pFilter != 0) {
            this.dispose(this.pFilter);
            this.pFilter = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

