/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.message;

import com.novell.gw.ab.DistributionList;
import com.novell.gw.ab.UnresolvedAddressException;
import com.novell.gw.account.Account;
import com.novell.gw.engine.Category;
import com.novell.gw.engine.CategoryList;
import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.DisplaySettings;
import com.novell.gw.engine.Engine;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.EngineInputStream;
import com.novell.gw.engine.EngineUtils;
import com.novell.gw.engine.Item;
import com.novell.gw.engine.ItemList;
import com.novell.gw.engine.SendCallback;
import com.novell.gw.engine.TransferAttachments;
import com.novell.gw.engine.TransferItems;
import com.novell.gw.folder.Folder;
import com.novell.gw.message.Appointment;
import com.novell.gw.message.Attachment;
import com.novell.gw.message.DocumentReference;
import com.novell.gw.message.Mail;
import com.novell.gw.message.Note;
import com.novell.gw.message.PhoneMessage;
import com.novell.gw.message.SharedAddressBookNotification;
import com.novell.gw.message.SharedFolderNotification;
import com.novell.gw.message.Task;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Date;

public abstract class Message
extends Item {
    private int iTmpHours;
    private int iTmpMinutes;
    private int iJniBodyFormat;
    protected int pGWItem = 0;
    private Boolean canModify;
    private int drn = 0;
    private int m_Uid = 0;
    private DistributionList distList = null;
    private Boolean bIsChecklistDummyItem = null;
    public static final int SENT_ITEM_STATUS_UNDELIVERABLE = 0;
    public static final int SENT_ITEM_STATUS_REJECTED = 1;
    public static final int SENT_ITEM_STATUS_STATUS = 2;
    public static final int SENT_ITEM_STATUS_PENDING = 3;
    public static final int SAVE_FORMAT_PLAIN = 0;
    public static final int SAVE_FORMAT_RTF = 1;
    public static final int SAVE_FORMAT_MIME = 2;

    private static native void initIds();

    private static native void dispose(int var0);

    private static native int getFolderPtr(int var0);

    private native int getViewFolderPtr(int var1);

    private native int addFileAttachment(int var1, String var2);

    private native int addMessageAttachment(int var1, int var2);

    private native boolean deleteAttachment(int var1, int var2);

    private native int[] getAttachments(int var1);

    private native int getAttachmentIndex(int var1, int var2);

    private native int getDistributionList(int var1);

    private native int getId(int var1);

    private native int getUid(int var1);

    private native String getGID(int var1);

    private native void GetInfoFile(int var1, String var2);

    private native boolean showHTMLOnlyWarning(int var1);

    private native int getBodyRtfReader(int var1);

    private native int getSentItemStatus(int var1);

    private static native int getItemType(int var0);

    private native String getSuggestedBody(int var1);

    private native String getSuggestedBody2(int var1, boolean var2);

    private native boolean hasBodyText(int var1);

    private native boolean hasRealAttachments(int var1);

    private native boolean hasSourceAttachment(int var1);

    private native int findSourceAttachment(int var1);

    private native boolean isHTMLMessage(int var1);

    private static native boolean isSharedAddressBookNotification(int var0);

    protected native boolean isSharedCalendarNotification(int var1);

    private static native boolean isSharedFolderNotification(int var0);

    protected native void retractItem(int var1);

    private native String saveBodyHtmlToTempFile(int var1, String var2);

    private native String getHTMLCharSetEncoding(int var1);

    private native int setBodyTextForAutoSave(int var1, String var2);

    private native int setBodyTextForSend(int var1, String var2);

    private native boolean setDistributionList(int var1, int var2);

    private native int getMsgBodyAttachmentSize(int var1);

    private native int getSize(int var1);

    private native String getDisplaySize(int var1);

    private native int getTransferAttachments(int var1, int[] var2);

    private native int getAttachTransferOptions(int var1, int var2);

    private native int getItemTransferOptions(int var1, int var2);

    private native boolean transferAttachData(int var1, int var2, int var3);

    private native boolean transferItemData(int var1, int var2, int var3);

    private native boolean canAccept(int var1);

    private native boolean canArchive(int var1);

    private native boolean canChangeTo(int var1, int var2);

    private native boolean canComplete(int var1);

    private native boolean canDelegate(int var1);

    private native boolean canDelete(int var1);

    private native boolean canDeleteAndEmpty(int var1);

    private native boolean canDialSender(int var1);

    private native boolean canDoInfo(int var1);

    private native boolean canForward(int var1);

    private native boolean canMarkPrivate(int var1);

    private native boolean canMarkRead(int var1);

    private native boolean canMarkReadLater(int var1);

    private native boolean canModify(int var1);

    private native boolean canPrint(int var1);

    private native boolean canEmpty(int var1);

    private native boolean canOpen(int var1);

    private native boolean canDecline(int var1);

    private native boolean canReply(int var1);

    private native boolean canReplyToOriginalTopic(int var1);

    private native boolean canResend(int var1);

    private native boolean canSave(int var1);

    private native boolean canSetAllDayEvent(int var1);

    private native boolean canShowInChecklist(int var1);

    private native boolean canUndelete(int var1);

    private native boolean canView(int var1);

    private native void archive(int var1) throws EngineException;

    private native boolean delete(int var1);

    private native boolean deleteAndEmpty(int var1);

    private native boolean restore(int var1);

    protected native void markComplete(int var1, boolean var2) throws EngineException;

    private native void markPrivate(int var1, boolean var2) throws EngineException;

    private native void markRead(int var1) throws EngineException;

    private native void markReadLater(int var1) throws EngineException;

    private native boolean empty(int var1);

    private native boolean saveDraft(int var1, String var2, SendCallback var3) throws EngineException;

    private native boolean saveToFile(int var1, String var2, int var3);

    private native void unDelete(int var1) throws EngineException;

    private native int getReplyRequestDays(int var1);

    private native int changeTo(int var1, int var2, boolean var3, boolean var4);

    private native int createSimpleForward(int var1, String var2) throws EngineException;

    private native int createForward(int var1) throws EngineException;

    private native int createReply(int var1, int var2, boolean var3, boolean var4, String var5) throws EngineException;

    private native int createResend(int var1, int var2);

    private native int getNotifyWhenDeleted(int var1);

    private native boolean setNotifyWhenDeleted(int var1, int var2);

    private native int getNotifyWhenOpened(int var1);

    private native boolean setNotifyWhenOpened(int var1, int var2);

    private native boolean isDraft(int var1);

    private native boolean setReplyWithinDays(int var1, int var2);

    private native boolean setReplyWhenConvenient(int var1, boolean var2);

    private native boolean setReplyRequested(int var1, boolean var2);

    private native String getValue(int var1, int var2, int var3);

    private native String getSummaryValue(int var1, int var2, int var3, int var4, int var5);

    private native String getSenderEmailAddress(int var1);

    private native String getFromText(int var1);

    private native boolean setFromText(int var1, String var2);

    private native boolean setMimeEncoding(int var1, int var2);

    private native int getMimeEncoding(int var1);

    private native String getCCText(int var1);

    private native String getBCText(int var1);

    private native String getToText(int var1);

    private native String getSubject(int var1);

    private native boolean setSubject(int var1, String var2);

    private native long getCreationDate(int var1);

    private native long getDate(int var1);

    private native long getDeletedDate(int var1);

    private native String getSenderId(int var1);

    private native boolean isAllDayEvent(int var1);

    private native boolean isChecklistDummyItem(int var1);

    private native boolean isCompleted(int var1);

    private native boolean isDeleted(int var1);

    private native boolean isDiscussionItem(int var1);

    private native boolean isForwarded(int var1);

    private native boolean isIMAPDeleted(int var1);

    private native boolean isImapHeader(int var1);

    private native boolean isImapMessage(int var1);

    private native boolean isInChecklist(int var1);

    private native boolean isNntpHeader(int var1);

    private native boolean isNntpMessage(int var1);

    private native boolean isRssMessage(int var1);

    private native boolean isPersonal(int var1);

    private native boolean isPostedViewName(int var1);

    private native boolean setPostedViewName(int var1, boolean var2);

    private native boolean isPrivate(int var1);

    private native boolean isPsuedoItem(int var1);

    private native boolean isRead(int var1);

    private native boolean isRepliedTo(int var1);

    private native boolean isReplyRequested(int var1);

    private native boolean isReplyWithinDays(int var1);

    private native boolean isCreateAccess(int var1);

    private native boolean isDeleteAccess(int var1);

    private native boolean isReadAccess(int var1);

    private native boolean isWriteAccess(int var1);

    private native String getRecordID(int var1);

    private native String getViewName(int var1);

    private native String getObjectName(int var1);

    private native int getPriority(int var1);

    private native boolean setPriority(int var1, int var2);

    private native int getSecurity(int var1);

    private native boolean setSecurity(int var1, int var2);

    private native int getBoxType(int var1);

    private native int getSendingDataStore(int var1);

    private native boolean setSendingDataStore(int var1, int var2);

    private native int getSendingAccount(int var1);

    private native void setSendingAccount(int var1, int var2);

    private native void send(int var1, int var2, SendCallback var3) throws EngineException;

    private native void post(int var1, int var2, SendCallback var3) throws EngineException;

    private native void modify(int var1, SendCallback var2, boolean var3) throws EngineException;

    private native void markOpen(int var1) throws EngineException;

    private native int getOpenTotals(int var1);

    private native long getDueDate(int var1);

    private native int getPercentComplete(int var1);

    private native int canHandleJunkMailItem(int var1, int var2);

    private native int handleJunkMailItem(int var1, int var2);

    private native boolean setAllDayEvent(int var1, boolean var2);

    private native boolean isDigitallySigned(int var1);

    private native boolean isDigitallyClearSigned(int var1);

    private native boolean isDigitallySignedorEncrypted(int var1);

    private native boolean isEncrypted(int var1);

    private native void showInChecklist(int var1, boolean var2);

    private native int getCategories(int var1);

    private native void setCategories(int var1, int var2);

    private native int getPrimaryCategory(int var1);

    private native String getPersonalizeNotes(int var1);

    private native String getPersonalizeSubject(int var1);

    private native boolean canUpdatePersonalizeData(int var1);

    private native void updatePersonalizeData(int var1, String var2, String var3, int var4);

    private native boolean canUpdateChecklistData(int var1);

    private native void updateChecklistData(int var1, boolean var2, long var3, boolean var5, int var6, boolean var7, int var8, int var9);

    private native boolean containsExternalImages(int var1);

    private native boolean getUserEnabledImages(int var1);

    private native void autoSave(int var1);

    private native void deleteAutoSaveFile(int var1);

    private native void setUserEnabledImages(int var1, boolean var2);

    private native void addVCard(int var1, String var2);

    private native boolean isStubbedOr3rdPartyOnlyItem(int var1);

    private native int getSendOptionExpireDays(int var1);

    private native boolean setSendOptionExpireDays(int var1, int var2);

    private native int getSendOptionDelayDeliverInfo(int var1);

    private native boolean setSendOptionDelayDeliverInfo(int var1, int var2, int var3, int var4);

    private native boolean getSendOptionNotifyRecipients(int var1);

    private native boolean setSendOptionNotifyRecipients(int var1, boolean var2);

    private native boolean getSendOptionCreateSentItem(int var1);

    private native boolean setSendOptionCreateSentItem(int var1, boolean var2);

    private native int getSendOptionStatusTracking(int var1);

    private native boolean setSendOptionStatusTracking(int var1, int var2);

    private native boolean getSendOptionMailAutoDelete(int var1);

    private native boolean setSendOptionMailAutoDelete(int var1, boolean var2);

    private native int getSendOptionInternetStatusTracking(int var1);

    private native boolean setSendOptionInternetStatusTracking(int var1, int var2);

    private native boolean getSendOptionConcealSubject(int var1);

    private native boolean setSendOptionConcealSubject(int var1, boolean var2);

    public Message() {
    }

    protected Message(int n) {
        this.pGWItem = n;
    }

    public static Item createMessage(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        int n2 = Message.getItemType(n);
        if (Message.isSharedFolderNotification(n)) {
            return new SharedFolderNotification(n);
        }
        if (Message.isSharedAddressBookNotification(n)) {
            return new SharedAddressBookNotification(n);
        }
        switch (n2) {
            case 1: {
                return new Mail(n);
            }
            case 2: {
                return new Note(n);
            }
            case 8: {
                return new Appointment(n);
            }
            case 4: {
                return new Task(n);
            }
            case 16: {
                return new PhoneMessage(n);
            }
            case 16384: {
                return new DocumentReference(n);
            }
        }
        return null;
    }

    public String getValue(int n, Folder folder) {
        String string = this.getValue(this.pGWItem, n, folder.getPointer());
        return string;
    }

    public String getSummaryValue(int n, Folder folder, DisplaySettings displaySettings) {
        String string = this.getSummaryValue(n, 512, folder, displaySettings);
        return string;
    }

    public String getSummaryValue(int n, int n2, Folder folder, DisplaySettings displaySettings) {
        String string = this.getSummaryValue(this.pGWItem, n, n2, folder.getPointer(), displaySettings.getPointer());
        return string;
    }

    public int getId() {
        if (this.drn == 0) {
            this.drn = this.getId(this.pGWItem);
        }
        return this.drn;
    }

    public int getUid() {
        if (this.m_Uid == 0) {
            this.m_Uid = this.getUid(this.pGWItem);
        }
        return this.m_Uid;
    }

    public String getGID() {
        String string = this.getGID(this.pGWItem);
        return string;
    }

    public boolean isDraft() {
        boolean bl = this.isDraft(this.pGWItem);
        return bl;
    }

    public int getPointer() {
        return this.pGWItem;
    }

    public void autoSave() {
        this.autoSave(this.pGWItem);
    }

    public void deleteAutoSaveFile() {
        this.deleteAutoSaveFile(this.pGWItem);
    }

    public boolean canAccept() {
        boolean bl = this.canAccept(this.pGWItem);
        return bl;
    }

    public boolean canArchive() {
        boolean bl = this.canArchive(this.pGWItem);
        return bl;
    }

    public boolean canChangeTo(int n) {
        boolean bl = this.canChangeTo(this.pGWItem, n);
        return bl;
    }

    public boolean canComplete() {
        boolean bl = this.canComplete(this.pGWItem);
        return bl;
    }

    public boolean canDelete() {
        boolean bl = this.canDelete(this.pGWItem);
        return bl;
    }

    public boolean canDeleteAndEmpty() {
        boolean bl = this.canDeleteAndEmpty(this.pGWItem);
        return bl;
    }

    public boolean canDelegate() {
        boolean bl = this.canDelegate(this.pGWItem);
        return bl;
    }

    public boolean canDialSender() {
        boolean bl = this.canDialSender(this.pGWItem);
        return bl;
    }

    public boolean canDoInfo() {
        boolean bl = this.canDoInfo(this.pGWItem);
        return bl;
    }

    public boolean canForward() {
        boolean bl = this.canForward(this.pGWItem);
        return bl;
    }

    public boolean canMarkPrivate() {
        boolean bl = this.canMarkPrivate(this.pGWItem);
        return bl;
    }

    public boolean canMarkRead() {
        boolean bl = this.canMarkRead(this.pGWItem);
        return bl;
    }

    public boolean canMarkReadLater() {
        boolean bl = this.canMarkReadLater(this.pGWItem);
        return bl;
    }

    public boolean canModify() {
        if (this.canModify == null) {
            this.canModify = this.canModify(this.pGWItem);
        }
        return this.canModify;
    }

    public boolean canPrint() {
        boolean bl = this.canPrint(this.pGWItem);
        return bl;
    }

    public boolean canEmpty() {
        boolean bl = this.canEmpty(this.pGWItem);
        return bl;
    }

    public boolean canOpen() {
        boolean bl = this.canOpen(this.pGWItem);
        return bl;
    }

    public boolean canDecline() {
        boolean bl = this.canDecline(this.pGWItem);
        return bl;
    }

    public boolean canReply() {
        boolean bl = this.canReply(this.pGWItem);
        return bl;
    }

    public boolean canReplyToOriginalTopic() {
        boolean bl = this.canReplyToOriginalTopic(this.pGWItem);
        return bl;
    }

    public boolean canResend() {
        boolean bl = this.canResend(this.pGWItem);
        return bl;
    }

    public boolean canSave() {
        boolean bl = this.canSave(this.pGWItem);
        return bl;
    }

    public boolean canSetAllDayEvent() {
        boolean bl = this.canSetAllDayEvent(this.pGWItem);
        return bl;
    }

    public boolean canShowInChecklist() {
        boolean bl = this.canShowInChecklist(this.pGWItem);
        return bl;
    }

    public boolean canUndelete() {
        boolean bl = this.canUndelete(this.pGWItem);
        return bl;
    }

    public boolean canView() {
        boolean bl = this.canView(this.pGWItem);
        return bl;
    }

    public boolean showHTMLOnlyWarning() {
        boolean bl = this.showHTMLOnlyWarning(this.pGWItem);
        return bl;
    }

    public InputStreamReader getBodyRtfReader() {
        InputStreamReader inputStreamReader = null;
        int n = this.getBodyRtfReader(this.pGWItem);
        if (n != 0) {
            EngineInputStream engineInputStream = new EngineInputStream(n);
            Charset charset = Engine.getInstance().getCharset();
            inputStreamReader = new InputStreamReader((InputStream)engineInputStream, charset);
        }
        return inputStreamReader;
    }

    public int indexOf(Attachment attachment) {
        int n = this.getAttachmentIndex(this.pGWItem, attachment.getPointer());
        return n;
    }

    public boolean isHTMLMessage() {
        boolean bl = this.isHTMLMessage(this.pGWItem);
        return bl;
    }

    public String saveBodyHtmlToTempFile() {
        return this.saveBodyHtmlToTempFile(null);
    }

    public String saveBodyHtmlToTempFile(String string) {
        String string2 = this.saveBodyHtmlToTempFile(this.pGWItem, string);
        return string2;
    }

    public String getHTMLCharSetEncoding() {
        String string = this.getHTMLCharSetEncoding(this.pGWItem);
        return string;
    }

    public String getSenderId() {
        String string = this.getSenderId(this.pGWItem);
        return string;
    }

    public int getSentItemStatus() {
        int n = this.getSentItemStatus(this.pGWItem);
        return n;
    }

    public int getNotifyWhenDeleted() {
        int n = this.getNotifyWhenDeleted(this.pGWItem);
        return n;
    }

    public boolean setNotifyWhenDeleted(int n) {
        boolean bl = this.setNotifyWhenDeleted(this.pGWItem, n);
        return bl;
    }

    public int getNotifyWhenOpened() {
        int n = this.getNotifyWhenOpened(this.pGWItem);
        return n;
    }

    public boolean setNotifyWhenOpened(int n) {
        boolean bl = this.setNotifyWhenOpened(this.pGWItem, n);
        return bl;
    }

    public boolean setReplyWithinDays(int n) {
        boolean bl = this.setReplyWithinDays(this.pGWItem, n);
        return bl;
    }

    public boolean setReplyWhenConvenient(boolean bl) {
        boolean bl2 = this.setReplyWhenConvenient(this.pGWItem, bl);
        return bl2;
    }

    public boolean setReplyRequested(boolean bl) {
        boolean bl2 = this.setReplyRequested(this.pGWItem, bl);
        return bl2;
    }

    public boolean isReplyRequested() {
        boolean bl = this.isReplyRequested(this.pGWItem);
        return bl;
    }

    public boolean isReplyWithinDays() {
        boolean bl = this.isReplyWithinDays(this.pGWItem);
        return bl;
    }

    public int getReplyRequestDays() {
        int n = this.getReplyRequestDays(this.pGWItem);
        return n;
    }

    public String getSenderEmailAddress() {
        String string = this.getSenderEmailAddress(this.pGWItem);
        return string;
    }

    public String getFromText() {
        String string = this.getFromText(this.pGWItem);
        return string;
    }

    public boolean setFromText(String string) {
        boolean bl = this.setFromText(this.pGWItem, string);
        return bl;
    }

    public boolean setMimeEncoding(int n) {
        boolean bl = this.setMimeEncoding(this.pGWItem, n);
        return bl;
    }

    public int getMimeEncoding() {
        int n = this.getMimeEncoding(this.pGWItem);
        return n;
    }

    public String getCCText() {
        String string = this.getCCText(this.pGWItem);
        return string;
    }

    public String getBCText() {
        String string = this.getBCText(this.pGWItem);
        return string;
    }

    public String getToText() {
        String string = this.getToText(this.pGWItem);
        return string;
    }

    public String getSubject() {
        String string = this.getSubject(this.pGWItem);
        return string;
    }

    public boolean setSubject(String string) {
        boolean bl = this.setSubject(this.pGWItem, string);
        return bl;
    }

    public Date getCreationDate() {
        long l = this.getCreationDate(this.pGWItem);
        Date date = EngineUtils.flaimTimeToDate(l);
        return date;
    }

    public Date getDate() {
        long l = this.getDate(this.pGWItem);
        Date date = EngineUtils.flaimTimeToDate(l);
        return date;
    }

    public Date getDeletedDate() {
        long l = this.getDeletedDate(this.pGWItem);
        Date date = EngineUtils.flaimTimeToDate(l);
        return date;
    }

    public int getItemType() {
        int n = Message.getItemType(this.pGWItem);
        return n;
    }

    public TransferAttachments getTransferAttachments(int[] nArray) {
        TransferAttachments transferAttachments = null;
        int n = this.getTransferAttachments(this.pGWItem, nArray);
        if (n != 0) {
            transferAttachments = new TransferAttachments(n);
        }
        return transferAttachments;
    }

    public int getTransferOptions(TransferAttachments transferAttachments) {
        return this.getAttachTransferOptions(this.pGWItem, transferAttachments.getPointer());
    }

    public int getTransferOptions(TransferItems transferItems) {
        return this.getItemTransferOptions(this.pGWItem, transferItems.getHandle());
    }

    public boolean transfer(TransferAttachments transferAttachments, int n) {
        boolean bl = this.transferAttachData(this.pGWItem, transferAttachments.getPointer(), n);
        return bl;
    }

    public boolean transfer(TransferItems transferItems, int n) {
        boolean bl = this.transferItemData(this.pGWItem, transferItems.getHandle(), n);
        return bl;
    }

    public boolean isAllDayEvent() {
        boolean bl = this.isAllDayEvent(this.pGWItem);
        return bl;
    }

    public boolean isChecklistDummyItem() {
        if (this.bIsChecklistDummyItem == null) {
            this.bIsChecklistDummyItem = this.isChecklistDummyItem(this.pGWItem);
        }
        return this.bIsChecklistDummyItem;
    }

    public boolean isCompleted() {
        boolean bl = this.isCompleted(this.pGWItem);
        return bl;
    }

    public boolean isDeleted() {
        boolean bl = this.isDeleted(this.pGWItem);
        return bl;
    }

    public boolean isDiscussionItem() {
        boolean bl = this.isDiscussionItem(this.pGWItem);
        return bl;
    }

    public boolean isForwarded() {
        boolean bl = this.isForwarded(this.pGWItem);
        return bl;
    }

    public boolean isIMAPDeleted() {
        boolean bl = this.isIMAPDeleted(this.pGWItem);
        return bl;
    }

    public boolean isImapHeader() {
        return this.isImapHeader(this.pGWItem);
    }

    public boolean isImapMessage() {
        return this.isImapMessage(this.pGWItem);
    }

    public boolean isNntpHeader() {
        return this.isNntpHeader(this.pGWItem);
    }

    public boolean isNntpMessage() {
        return this.isNntpMessage(this.pGWItem);
    }

    public boolean isRssMessage() {
        return this.isRssMessage(this.pGWItem);
    }

    public boolean isRead() {
        boolean bl = this.isRead(this.pGWItem);
        return bl;
    }

    public boolean isRepliedTo() {
        boolean bl = this.isRepliedTo(this.pGWItem);
        return bl;
    }

    boolean isReadAccess() {
        boolean bl = this.isReadAccess(this.pGWItem);
        return bl;
    }

    boolean isCreateAccess() {
        boolean bl = this.isCreateAccess(this.pGWItem);
        return bl;
    }

    boolean isWriteAccess() {
        boolean bl = this.isWriteAccess(this.pGWItem);
        return bl;
    }

    boolean isDeleteAccess() {
        boolean bl = this.isDeleteAccess(this.pGWItem);
        return bl;
    }

    public boolean isInChecklist() {
        boolean bl = this.isInChecklist(this.pGWItem);
        return bl;
    }

    public boolean isPersonal() {
        boolean bl = this.isPersonal(this.pGWItem);
        return bl;
    }

    public boolean isPostedViewName() {
        boolean bl = this.isPostedViewName(this.pGWItem);
        return bl;
    }

    public boolean setPostedViewName(boolean bl) {
        boolean bl2 = this.setPostedViewName(this.pGWItem, bl);
        return bl2;
    }

    public boolean isPrivate() {
        boolean bl = this.isPrivate(this.pGWItem);
        return bl;
    }

    public boolean isPsuedoItem() {
        boolean bl = this.isPsuedoItem(this.pGWItem);
        return bl;
    }

    public String getRecordID() {
        String string = this.getRecordID(this.pGWItem);
        return string;
    }

    public String getViewName() {
        String string = this.getViewName(this.pGWItem);
        return string;
    }

    String getObjectName() {
        String string = this.getObjectName(this.pGWItem);
        return string;
    }

    public int getPriority() {
        int n = this.getPriority(this.pGWItem);
        return n;
    }

    public boolean setPriority(int n) {
        boolean bl = this.setPriority(this.pGWItem, n);
        return bl;
    }

    public int getSecurity() {
        int n = this.getSecurity(this.pGWItem);
        return n;
    }

    public boolean setSecurity(int n) {
        boolean bl = this.setSecurity(this.pGWItem, n);
        return bl;
    }

    public int getBoxType() {
        int n = this.getBoxType(this.pGWItem);
        return n;
    }

    public Folder getFolder() {
        Folder folder = null;
        int n = Message.getFolderPtr(this.pGWItem);
        if (n != 0) {
            folder = DataStore.getFolder(n);
        }
        return folder;
    }

    public Folder getViewFolder() {
        Folder folder = null;
        int n = this.getViewFolderPtr(this.pGWItem);
        if (n != 0) {
            folder = DataStore.getFolder(n);
        }
        return folder;
    }

    public DistributionList getDistributionList() {
        int n;
        if (this.distList == null && (n = this.getDistributionList(this.pGWItem)) != 0) {
            this.distList = new DistributionList(n);
        }
        return this.distList;
    }

    public boolean setDistributionList(DistributionList distributionList) {
        boolean bl = this.setDistributionList(this.pGWItem, distributionList != null ? distributionList.getPointer() : 0);
        if (bl) {
            this.distList = distributionList;
        }
        return bl;
    }

    public boolean setBodyTextForAutoSave(String string) {
        if (this.canModify()) {
            int n = this.setBodyTextForAutoSave(this.pGWItem, string);
            return n == 0;
        }
        return false;
    }

    public boolean setBodyTextForSend(String string) {
        if (this.canModify()) {
            int n = this.setBodyTextForSend(this.pGWItem, string);
            return n == 0;
        }
        return false;
    }

    public int getMsgBodyAttachmentSize() {
        return this.getMsgBodyAttachmentSize(this.pGWItem);
    }

    public int getSize() {
        return this.getSize(this.pGWItem);
    }

    public String getDisplaySize() {
        return this.getDisplaySize(this.pGWItem);
    }

    public DataStore getSendingDataStore() {
        DataStore dataStore = null;
        int n = this.getSendingDataStore(this.pGWItem);
        if (n != 0) {
            dataStore = new DataStore(n);
        }
        return dataStore;
    }

    public boolean setSendingDataStore(DataStore dataStore) {
        return this.setSendingDataStore(this.pGWItem, dataStore.getPointer());
    }

    public Account getSendingAccount() {
        Account account = null;
        int n = this.getSendingAccount(this.pGWItem);
        if (n != 0) {
            account = Account.createAccount(n, null);
        }
        return account;
    }

    public void setSendingAccount(Account account) {
        this.setSendingAccount(this.pGWItem, account.getPointer());
    }

    public void send(Account account) throws EngineException {
        this.send(account, null);
    }

    public void send(Account account, SendCallback sendCallback) throws EngineException {
        try {
            int n = 0;
            if (account != null) {
                n = account.getPointer();
            }
            this.send(this.pGWItem, n, sendCallback);
        }
        catch (EngineException engineException) {
            if (53331 == engineException.getErrorCode()) {
                throw new UnresolvedAddressException(engineException.getErrorCode());
            }
            throw engineException;
        }
    }

    public void post(Account account) throws EngineException, IllegalArgumentException {
        this.post(account, null);
    }

    public void post(Account account, SendCallback sendCallback) throws EngineException, IllegalArgumentException {
        this.post(this.pGWItem, account.getPointer(), sendCallback);
    }

    public Message changeTo(int n) {
        return this.changeTo(n, false, true);
    }

    public Message changeTo(int n, boolean bl, boolean bl2) {
        int n2 = this.changeTo(this.pGWItem, n, bl, bl2);
        return (Message)Item.createItem(n2);
    }

    public Message createSimpleForward() throws EngineException {
        return this.createSimpleForward(null);
    }

    public Message createSimpleForward(String string) throws EngineException {
        int n = this.createSimpleForward(this.pGWItem, string);
        return (Message)Item.createItem(n);
    }

    public Message createForward() throws EngineException {
        int n = this.createForward(this.pGWItem);
        return (Message)Item.createItem(n);
    }

    public Message createReply(int n, boolean bl) throws EngineException {
        return this.createReply(n, bl, false);
    }

    public Message createReply(int n, boolean bl, boolean bl2) throws EngineException {
        return this.createReply(n, bl, bl2, null);
    }

    public Message createReply(int n, boolean bl, boolean bl2, String string) throws EngineException {
        int n2 = this.createReply(this.pGWItem, n, bl, bl2, string);
        return (Message)Item.createItem(n2);
    }

    public Message createResend(int n) {
        int n2 = this.createResend(this.pGWItem, n);
        return (Message)Item.createItem(n2);
    }

    public void markComplete(boolean bl) throws EngineException {
        this.markComplete(this.pGWItem, bl);
    }

    public void markOpen() throws EngineException {
        this.markOpen(this.pGWItem);
    }

    public void markPrivate(boolean bl) throws EngineException {
        this.markPrivate(this.pGWItem, bl);
    }

    public void archive() throws EngineException {
        this.archive(this.pGWItem);
    }

    public void markRead() throws EngineException {
        this.markRead(this.pGWItem);
    }

    public void markReadLater() throws EngineException {
        this.markReadLater(this.pGWItem);
    }

    public boolean delete() {
        return this.delete(this.pGWItem);
    }

    public boolean deleteAndEmpty() {
        return this.deleteAndEmpty(this.pGWItem);
    }

    public boolean restore() {
        boolean bl = this.restore(this.pGWItem);
        return bl;
    }

    public boolean empty() {
        boolean bl = this.empty(this.pGWItem);
        return bl;
    }

    public void unDelete() throws EngineException {
        this.unDelete(this.pGWItem);
    }

    public boolean deleteAttachment(int n) {
        if (this.getId() == 0 || this.isDraft() || this.isPersonal()) {
            return this.deleteAttachment(this.pGWItem, n);
        }
        return false;
    }

    public boolean deleteAttachment(Attachment attachment) {
        boolean bl = false;
        int n = this.indexOf(attachment);
        if (n != -1) {
            bl = this.deleteAttachment(n);
        }
        return bl;
    }

    public boolean addAttachment(String string) {
        int n = this.addFileAttachment(this.pGWItem, string);
        return n == 0;
    }

    public boolean addAttachment(Message message) {
        int n = this.addMessageAttachment(this.pGWItem, message.pGWItem);
        return n == 0;
    }

    public boolean saveDraft(String string) throws UnresolvedAddressException {
        return this.saveDraft(string, null);
    }

    public boolean saveDraft(String string, SendCallback sendCallback) throws UnresolvedAddressException {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = this.saveDraft(this.pGWItem, string, sendCallback);
            }
            catch (EngineException engineException) {
                if (53331 != engineException.getErrorCode()) break block2;
                throw new UnresolvedAddressException(engineException.getErrorCode());
            }
        }
        return bl;
    }

    public boolean saveToFile(String string, int n) {
        return this.saveToFile(this.pGWItem, string, n);
    }

    public void modify() throws EngineException {
        this.modify(null);
    }

    public void modify(SendCallback sendCallback) throws EngineException {
        this.modify(sendCallback, true);
    }

    public void modify(SendCallback sendCallback, boolean bl) throws EngineException {
        try {
            this.modify(this.pGWItem, sendCallback, bl);
        }
        catch (EngineException engineException) {
            if (53331 == engineException.getErrorCode()) {
                throw new UnresolvedAddressException(engineException.getErrorCode());
            }
            throw engineException;
        }
    }

    public Attachment[] getAttachments() {
        int[] nArray = this.getAttachments(this.pGWItem);
        Attachment[] attachmentArray = new Attachment[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            attachmentArray[i] = Attachment.createAttachment(nArray[i]);
        }
        return attachmentArray;
    }

    public boolean hasRealAttachments() {
        return this.hasRealAttachments(this.pGWItem);
    }

    public boolean hasSourceAttachment() {
        return this.hasSourceAttachment(this.pGWItem);
    }

    public int findSourceAttachment() {
        return this.findSourceAttachment(this.pGWItem);
    }

    public boolean hasPaperclipAttachments() {
        return this.hasRealAttachments(this.pGWItem);
    }

    public boolean hasBodyText() {
        return this.hasBodyText(this.pGWItem);
    }

    public void getInfoFile(String string) {
        if (string != null && string.length() > 0) {
            this.GetInfoFile(this.pGWItem, string);
        }
    }

    public void retractItem() {
        this.retractItem(this.pGWItem);
    }

    public SuggestedBody getSuggestedBody() {
        SuggestedBody suggestedBody = null;
        this.iJniBodyFormat = 0;
        String string = this.getSuggestedBody(this.pGWItem);
        if (string != null) {
            suggestedBody = new SuggestedBody(string, this.iJniBodyFormat);
        }
        return suggestedBody;
    }

    public SuggestedBody getSuggestedBody(boolean bl) {
        SuggestedBody suggestedBody = null;
        this.iJniBodyFormat = 0;
        String string = this.getSuggestedBody2(this.pGWItem, bl);
        if (string != null) {
            suggestedBody = new SuggestedBody(string, this.iJniBodyFormat);
        }
        return suggestedBody;
    }

    public int getOpenTotals() {
        int n = this.getOpenTotals(this.pGWItem);
        return n;
    }

    public Date getDueDate() {
        long l = this.getDueDate(this.pGWItem);
        Date date = EngineUtils.flaimTimeToDate(l);
        return date;
    }

    public int getPercentComplete() {
        int n = this.getPercentComplete(this.pGWItem);
        return n;
    }

    public boolean canHandleJunkMailItem(int n) {
        int n2 = this.canHandleJunkMailItem(n, this.pGWItem);
        return n2 != 0;
    }

    public int canHandleJunkMailItem() {
        return this.canHandleJunkMailItem(0, this.pGWItem);
    }

    public int handleJunkMailItem(int n) {
        return this.handleJunkMailItem(n, this.pGWItem);
    }

    protected boolean setAllDayEvent(boolean bl) {
        return this.setAllDayEvent(this.pGWItem, bl);
    }

    public boolean isDigitallySigned() {
        boolean bl = this.isDigitallySigned(this.pGWItem);
        return bl;
    }

    public boolean isDigitallyClearSigned() {
        boolean bl = this.isDigitallyClearSigned(this.pGWItem);
        return bl;
    }

    public boolean isDigitallySignedorEncrypted() {
        boolean bl = this.isDigitallySignedorEncrypted(this.pGWItem);
        return bl;
    }

    public boolean isEncrypted() {
        boolean bl = this.isEncrypted(this.pGWItem);
        return bl;
    }

    public void showInChecklist(boolean bl) {
        this.showInChecklist(this.pGWItem, bl);
    }

    public CategoryList getCategories() {
        return CategoryList.create(this.getCategories(this.pGWItem));
    }

    public void setCategories(CategoryList categoryList) {
        this.setCategories(this.pGWItem, categoryList.getPointer());
    }

    public Category getPrimaryCategory() {
        return Category.create(this.getPrimaryCategory(this.pGWItem));
    }

    public String getPersonalizeNotes() {
        return this.getPersonalizeNotes(this.pGWItem);
    }

    public String getPersonalizeSubject() {
        return this.getPersonalizeSubject(this.pGWItem);
    }

    public boolean canUpdatePersonalizeData() {
        return this.canUpdatePersonalizeData(this.pGWItem);
    }

    public void updatePersonalizeData(String string, String string2, CategoryList categoryList) {
        this.updatePersonalizeData(this.pGWItem, string, string2, categoryList != null ? categoryList.getPointer() : 0);
    }

    public boolean canUpdateChecklistData() {
        return this.canUpdateChecklistData(this.pGWItem);
    }

    public void updateChecklistData(boolean bl, Date date, boolean bl2, int n, boolean bl3, ItemList itemList, int n2) {
        this.updateChecklistData(this.pGWItem, bl, EngineUtils.DateToFlaimTime(date), bl2, n, bl3, itemList != null ? itemList.getPointer() : 0, n2);
    }

    public boolean containsExternalImages() {
        boolean bl = this.containsExternalImages(this.pGWItem);
        return bl;
    }

    public boolean getUserEnabledImages() {
        boolean bl = this.getUserEnabledImages(this.pGWItem);
        return bl;
    }

    public void setUserEnabledImages(boolean bl) {
        this.setUserEnabledImages(this.pGWItem, bl);
    }

    public void addVCard(String string) {
        this.addVCard(this.pGWItem, string);
    }

    public boolean isStubbedOr3rdPartyOnlyItem() {
        boolean bl = this.isStubbedOr3rdPartyOnlyItem(this.pGWItem);
        return bl;
    }

    public int getSendOptionExpireDays() {
        return this.getSendOptionExpireDays(this.pGWItem);
    }

    public boolean setSendOptionExpireDays(int n) {
        return this.setSendOptionExpireDays(this.pGWItem, n);
    }

    public DelayDeliverInfo getSendOptionDelayDeliverInfo() {
        this.iTmpHours = 0;
        this.iTmpMinutes = 0;
        DelayDeliverInfo delayDeliverInfo = null;
        int n = this.getSendOptionDelayDeliverInfo(this.pGWItem);
        if (n > 0 || this.iTmpHours > 0 || this.iTmpMinutes > 0) {
            delayDeliverInfo = new DelayDeliverInfo(n, this.iTmpHours, this.iTmpMinutes);
        }
        return delayDeliverInfo;
    }

    public boolean setSendOptionDelayDeliverInfo(DelayDeliverInfo delayDeliverInfo) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (delayDeliverInfo != null) {
            n = delayDeliverInfo.getDays();
            n2 = delayDeliverInfo.getHours();
            n3 = delayDeliverInfo.getMinutes();
        }
        return this.setSendOptionDelayDeliverInfo(this.pGWItem, n, n2, n3);
    }

    public boolean getSendOptionNotifyRecipients() {
        return this.getSendOptionNotifyRecipients(this.pGWItem);
    }

    public boolean setSendOptionNotifyRecipients(boolean bl) {
        return this.setSendOptionNotifyRecipients(this.pGWItem, bl);
    }

    public boolean getSendOptionCreateSentItem() {
        return this.getSendOptionCreateSentItem(this.pGWItem);
    }

    public boolean setSendOptionCreateSentItem(boolean bl) {
        return this.setSendOptionCreateSentItem(this.pGWItem, bl);
    }

    public int getSendOptionStatusTracking() {
        return this.getSendOptionStatusTracking(this.pGWItem);
    }

    public boolean setSendOptionStatusTracking(int n) {
        return this.setSendOptionStatusTracking(this.pGWItem, n);
    }

    public boolean getSendOptionMailAutoDelete() {
        return this.getSendOptionMailAutoDelete(this.pGWItem);
    }

    public boolean setSendOptionMailAutoDelete(boolean bl) {
        return this.setSendOptionMailAutoDelete(this.pGWItem, bl);
    }

    public int getSendOptionInternetStatusTracking() {
        return this.getSendOptionInternetStatusTracking(this.pGWItem);
    }

    public boolean setSendOptionInternetStatusTracking(int n) {
        return this.setSendOptionInternetStatusTracking(this.pGWItem, n);
    }

    public boolean getSendOptionConcealSubject() {
        return this.getSendOptionConcealSubject(this.pGWItem);
    }

    public boolean setSendOptionConcealSubject(boolean bl) {
        return this.setSendOptionConcealSubject(this.pGWItem, bl);
    }

    public void dispose() {
        if (this.pGWItem != 0) {
            Message.dispose(this.pGWItem);
            this.pGWItem = 0;
            this.distList = null;
        }
    }

    static {
        Message.initIds();
    }

    public class SuggestedBody {
        public static final int FORMAT_NONE_PLAIN = 0;
        public static final int FORMAT_RTF = 1;
        public static final int FORMAT_HTML = 2;
        private String text;
        private int format;

        SuggestedBody(String string, int n) {
            this.text = string;
            this.format = n;
        }

        public String getText() {
            return this.text;
        }

        public int getFormat() {
            return this.format;
        }

        public String toString() {
            return this.text;
        }
    }

    public class DelayDeliverInfo {
        private int days;
        private int hours;
        private int minutes;

        public DelayDeliverInfo(int n, int n2, int n3) {
            this.days = n;
            this.hours = n2;
            this.minutes = n3;
        }

        public int getDays() {
            return this.days;
        }

        public int getHours() {
            return this.hours;
        }

        public int getMinutes() {
            return this.minutes;
        }
    }
}

