/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.message;

import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.EngineUtils;
import com.novell.gw.engine.Item;
import com.novell.gw.folder.Folder;
import com.novell.gw.message.Message;
import java.util.Date;

public class Note
extends Message {
    public static final int AUTODATE_CALLBACK_PROMPT = 0;
    public static final int AUTODATE_ONE_INSTANCE = 1;
    public static final int AUTODATE_ALL_INSTANCES = 2;

    private static native int createItem(int var0, int var1) throws EngineException;

    private native long getStartDate(int var1);

    private native boolean setStartDate(int var1, long var2);

    private native long[] getAutoDate(int var1);

    private native int[] getAutoDateItems(int var1);

    private native boolean setAutoDate(int var1, long[] var2, long var3);

    private native int getNotifyWhenAccepted(int var1);

    private native boolean setNotifyWhenAccepted(int var1, int var2);

    protected native boolean accept(int var1, String var2, int var3, int var4, int var5);

    protected native boolean decline(int var1, String var2, int var3, int var4, boolean var5);

    protected native int delegate(int var1) throws EngineException;

    private native boolean isAccepted(int var1);

    private native boolean isDelegated(int var1);

    protected native boolean isAutodate(int var1);

    public Note() {
    }

    Note(int n) {
        super(n);
    }

    public Note(DataStore dataStore) throws EngineException {
        this(dataStore, null);
    }

    public Note(DataStore dataStore, Folder folder) throws EngineException {
        this(Note.createItem(dataStore.getPointer(), folder != null ? folder.getPointer() : 0));
    }

    public Date getStartDate() {
        long l = this.getStartDate(this.pGWItem);
        Date date = EngineUtils.flaimTimeToDate(l);
        return date;
    }

    public boolean setStartDate(Date date) {
        long l = EngineUtils.DateToFlaimTime(date);
        boolean bl = this.setStartDate(this.pGWItem, l);
        return bl;
    }

    public Date[] getAutoDate() {
        Date[] dateArray = null;
        long[] lArray = this.getAutoDate(this.pGWItem);
        if (lArray != null && lArray.length > 0) {
            dateArray = new Date[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                dateArray[i] = EngineUtils.flaimTimeToDate(lArray[i]);
            }
        }
        return dateArray;
    }

    public Item[] getAutoDateItems() {
        int[] nArray = this.getAutoDateItems(this.pGWItem);
        int n = nArray != null ? nArray.length : 0;
        Item[] itemArray = new Item[n];
        for (int i = 0; i < n; ++i) {
            itemArray[i] = Message.createMessage(nArray[i]);
        }
        return itemArray;
    }

    public boolean setAutoDate(Date[] dateArray, long l) {
        boolean bl;
        long[] lArray = new long[dateArray.length];
        for (bl = false; bl < dateArray.length; bl += 1) {
            lArray[bl] = EngineUtils.DateToFlaimTime(dateArray[bl]);
        }
        bl = this.setAutoDate(this.pGWItem, lArray, l);
        return bl;
    }

    public boolean accept(int n) {
        return this.accept("", n, 160, null);
    }

    public boolean accept(String string, int n, Folder folder) {
        return this.accept(string, n, 160, folder);
    }

    protected boolean accept(String string, int n, int n2, Folder folder) {
        boolean bl = this.accept(this.pGWItem, string, n, n2, folder != null ? folder.getPointer() : 0);
        return bl;
    }

    public boolean decline(int n) {
        return this.decline("", n, 160, false);
    }

    public boolean decline(String string, int n) {
        return this.decline(string, n, 160, false);
    }

    protected boolean decline(String string, int n, int n2, boolean bl) {
        boolean bl2 = this.decline(this.pGWItem, string, n, n2, bl);
        return bl2;
    }

    public Note delegate() throws EngineException {
        int n = this.delegate(this.pGWItem);
        return (Note)Item.createItem(n);
    }

    public boolean isAccepted() {
        return this.isAccepted(this.pGWItem);
    }

    public boolean isAutodate() {
        boolean bl = this.isAutodate(this.pGWItem);
        return bl;
    }

    public boolean isDelegated() {
        return this.isDelegated(this.pGWItem);
    }

    public int getNotifyWhenAccepted() {
        int n = this.getNotifyWhenAccepted(this.pGWItem);
        return n;
    }

    public boolean setNotifyWhenAccepted(int n) {
        boolean bl = this.setNotifyWhenAccepted(this.pGWItem, n);
        return bl;
    }

    public int getNotifyWhenDeclined() {
        int n = this.getNotifyWhenDeleted();
        return n;
    }

    public boolean setNotifyWhenDeclined(int n) {
        boolean bl = this.setNotifyWhenDeleted(n);
        return bl;
    }
}

