/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.customizedbutton;

import com.appframework.AppAction;
import com.appframework.CustomizableToolBarComponent;
import com.appframework.components.GWBorder;
import com.appframework.components.customizedbutton.ActionWithSepName;
import com.appframework.components.customizedbutton.ToolBarColorButton;
import com.appframework.resources.ImageResources;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.skinnable.SkinnablePanel;
import com.novell.gw.jclient.bl.om.options.ToolBarOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;

public abstract class AbstractPopupPane
extends SkinnablePanel
implements CustomizableToolBarComponent {
    public boolean mousePressed = false;
    public static final int STATE_UP = 1;
    public static final int STATE_NORMAL = 4;
    public static final int STATE_DOWN = 8;
    protected static final int BUTTON_LEFT_PRESSED = 16;
    protected static final int BUTTON_RIGHT_PRESSED = 20;
    protected ToolBarColorButton btnLeft = new ToolBarColorButton();
    protected ToolBarColorButton btnRight = new RightButton();
    protected JPopupMenu pumActions;
    protected List<ActionWithSepName> actionsList = new ArrayList<ActionWithSepName>();
    protected ActionWithSepName defaultAction;
    protected Icon iconNormal;
    private boolean isUnderMouse;
    protected boolean isPopupShowed;
    protected boolean isEnabled = true;
    private boolean showTextLabel = true;
    protected DefaultActionPropertyListener propertyListener = new DefaultActionPropertyListener();
    protected boolean enable = true;
    private boolean previewMode = false;
    private boolean disabledMode = false;

    private AbstractPopupPane() {
        this.skinnableDelegate.clearPropertyBindings();
        this.setOpaque(false);
        this.btnLeft.setRoundState("left");
        this.btnRight.setRoundState("right");
        this.btnLeft.addMouseListener(new LeftButtonMouseListener());
        this.btnRight.addMouseListener(new RightButtonMouseListener());
        this.btnRight.setIcon(ImageResources.ARROW_DOWN);
        this.setBorder(null);
        this.build();
    }

    protected AbstractPopupPane(Action a, String theText) {
        this();
        this.setDefaultAction(a, theText);
    }

    private void build() {
        this.setIconPosition(UIUtils.getComponentOrientation().isLeftToRight() ? 2 : 4);
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        Border border = this.btnLeft.getBorder();
        this.add((Component)this.btnLeft, c);
        this.btnLeft.setBorder(border);
        this.add((Component)this.btnLeft, c);
        c.gridx = 1;
        c.gridy = 0;
        this.add((Component)this.btnRight, c);
    }

    public void setAlwaysPressed(boolean b) {
        this.btnLeft.setAlwaysPressed(b);
        this.btnRight.setAlwaysPressed(b);
    }

    public boolean isAlwaysPressed() {
        return this.btnLeft.isAlwaysPressed() && this.btnRight.isAlwaysPressed();
    }

    public void addAction(Action a) {
        this.addAction(a, (String)a.getValue("Name"));
    }

    public void addAction(Action a, String displayName) {
        if (a == null || displayName == null) {
            throw new NullPointerException();
        }
        this.actionsList.add(new ActionWithSepName(a, displayName));
    }

    public ActionKey getDefaultActionName() {
        if (this.defaultAction == null) {
            return null;
        }
        return ((AppAction)this.defaultAction.getAction()).getActionKey();
    }

    public void updateUI() {
        super.updateUI();
        if (this.btnLeft != null) {
            this.btnLeft.updateUI();
        }
        if (this.btnRight != null) {
            this.btnRight.updateUI();
        }
    }

    public Action getDefaultAction() {
        if (this.defaultAction == null) {
            return null;
        }
        return this.defaultAction.getAction();
    }

    public void setDefaultAction(Action a) {
        if (a != null) {
            this.setDefaultAction(a, (String)a.getValue("Name"));
        }
    }

    public void setShowTextLabel(boolean b) {
        this.showTextLabel = b;
        this.btnLeft.setShowTextLabel(b);
    }

    public boolean showTextLabel() {
        return this.showTextLabel;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractPopupPane)) {
            return false;
        }
        AbstractPopupPane button = (AbstractPopupPane)obj;
        if (button.defaultAction.getAction() == null) {
            return super.equals(obj);
        }
        return button.defaultAction.getAction().equals(this.defaultAction.getAction());
    }

    public int hashCode() {
        if (this.defaultAction == null || this.defaultAction.getAction() == null) {
            return super.hashCode();
        }
        int result = 17;
        result = 37 * result + this.defaultAction.getAction().hashCode();
        return result;
    }

    public abstract void setDefaultAction(Action var1, String var2);

    public void setIcon(Icon i) {
        this.iconNormal = i;
        this.btnLeft.setIcon(i);
    }

    private void mouseEntered(MouseEvent e) {
        if (this.btnLeft.isEnabled()) {
            this.btnLeft.setSelected(true);
            this.btnRight.setSelected(true);
            this.isUnderMouse = true;
            this.changeState(1);
            this.btnLeft.getModel().setArmed(false);
            this.btnRight.getModel().setArmed(false);
            this.btnLeft.getModel().setRollover(true);
            this.btnRight.getModel().setRollover(true);
            this.btnLeft.getModel().setPressed(false);
            this.btnRight.getModel().setPressed(false);
        }
    }

    private void mouseExited(MouseEvent e) {
        if (this.btnLeft.isEnabled()) {
            this.btnRight.getModel().setRollover(false);
            this.btnLeft.getModel().setRollover(false);
            this.isUnderMouse = false;
            this.changeState(4);
        }
    }

    private void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1 && this.btnLeft.isEnabled()) {
            ToolBarColorButton b = this.btnLeft;
            if (0 <= e.getX() && e.getX() < b.getSize().width && 0 <= e.getY() && e.getY() < b.getSize().height) {
                this.changeState(1);
            } else {
                this.changeState(4);
            }
            this.btnRight.getModel().setPressed(false);
            this.btnRight.getModel().setArmed(false);
        }
    }

    protected void changeState(int state) {
        if (!this.isPopupShowed && this.isEnabled) {
            if (state == 1 || state == 8) {
                this.btnLeft.setIcon(this.iconNormal);
                this.updateBorder(state);
            } else if (state == 4) {
                this.btnLeft.setIcon(this.iconNormal);
                this.updateBorder(state);
            }
        }
    }

    protected abstract void processEvent(int var1);

    public void addSeparator() {
        this.actionsList.add(new ActionWithSepName(null, "-"));
    }

    protected JMenuItem createPopupItem(ActionWithSepName an) {
        JMenuItem mi = an.getAction() instanceof AppAction ? ((AppAction)an.getAction()).getMenuItem() : OS.createMenuItemForAction(an.getAction());
        if (an.getAction() == this.defaultAction.getAction()) {
            boolean isLTR = mi.getComponentOrientation().isLeftToRight();
            String strName = an.getDisplayName();
            mi.setText(isLTR ? strName + " *" : "* " + strName);
        } else {
            mi.setText(an.getDisplayName());
        }
        if (!OS.isMacOS()) {
            mi.setBorderPainted(false);
        }
        return mi;
    }

    protected void restoreState() {
        this.changeState(this.isUnderMouse ? 1 : 4);
    }

    private void updateBorder(int state) {
        switch (state) {
            case 1: {
                this.btnLeft.setBorder(GWBorder.RAISED_BORDER);
                this.btnRight.setBorder(GWBorder.RAISED_BORDER);
                break;
            }
            case 8: {
                this.btnLeft.setBorder(GWBorder.LOWERED_BORDER);
                this.btnRight.setBorder(GWBorder.LOWERED_BORDER);
                break;
            }
            case 4: {
                this.btnLeft.setBorder(GWBorder.NO_BORDER);
                this.btnRight.setBorder(GWBorder.NO_BORDER);
            }
        }
    }

    public String getDisplayText() {
        return this.btnLeft.getText();
    }

    private void setIconPosition(int position) {
        switch (position) {
            case 2: {
                this.btnLeft.setVerticalTextPosition(0);
                this.btnLeft.setHorizontalTextPosition(4);
                break;
            }
            case 4: {
                this.btnLeft.setVerticalTextPosition(0);
                this.btnLeft.setHorizontalTextPosition(2);
                break;
            }
            case 1: {
                this.btnLeft.setVerticalTextPosition(3);
                this.btnLeft.setHorizontalTextPosition(0);
                break;
            }
            case 3: {
                this.btnLeft.setVerticalTextPosition(1);
                this.btnLeft.setHorizontalTextPosition(0);
            }
        }
    }

    public Icon getIcon() {
        if (this.iconNormal != null) {
            return this.iconNormal;
        }
        return null;
    }

    public void changeComponentStyle(ToolBarOptions.Style style) {
        UIUtils.changeToolbarButtonStyle(this.btnLeft, this.defaultAction.getDisplayName(), style, this.showTextLabel);
        this.btnLeft.setOpaque(false);
        this.btnLeft.changeComponentStyle(style);
        if (this.previewMode) {
            this.btnLeft.revalidate();
        }
    }

    public void setPreviewMode(boolean b) {
        if (this.disabledMode) {
            throw new IllegalStateException("control is in disabled mode");
        }
        this.previewMode = b;
        this.enable = !b;
        this.btnLeft.setPreviewMode(b);
        if (b) {
            this.btnRight.setEnabled(b);
        } else {
            this.btnRight.setEnabled(this.defaultAction.getAction().isEnabled());
        }
    }

    public boolean isPreviewMode() {
        return this.previewMode;
    }

    public boolean isDisabledMode() {
        return this.disabledMode;
    }

    public void setDisabledMode(boolean disabled) {
        if (this.previewMode) {
            throw new IllegalStateException("control is in preview mode");
        }
        this.disabledMode = disabled;
        this.enable = !disabled;
        this.btnLeft.setDisabledMode(disabled);
        if (disabled) {
            this.btnRight.setEnabled(!disabled);
        } else {
            this.btnRight.setEnabled(this.defaultAction.getAction().isEnabled());
        }
    }

    public void addDefaultActionListener(ActionListener actionListener) {
        this.btnLeft.addActionListener(actionListener);
        this.btnRight.addActionListener(actionListener);
    }

    public void setSkinabilityEnabled(boolean isSkinabilityEnabled) {
        super.setSkinabilityEnabled(isSkinabilityEnabled);
        this.btnLeft.setSkinabilityEnabled(isSkinabilityEnabled);
        this.btnRight.setSkinabilityEnabled(isSkinabilityEnabled);
    }

    public List getActionsList() {
        return this.actionsList;
    }

    private class RightButtonMouseListener
    extends MouseAdapter {
        private RightButtonMouseListener() {
        }

        public void mouseEntered(MouseEvent e) {
            AbstractPopupPane.this.mouseEntered(e);
        }

        public void mouseExited(MouseEvent e) {
            AbstractPopupPane.this.mouseExited(e);
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                AbstractPopupPane.this.processEvent(20);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                AbstractPopupPane.this.changeState(1);
            }
        }
    }

    private class LeftButtonMouseListener
    extends MouseAdapter {
        private LeftButtonMouseListener() {
        }

        public void mouseEntered(MouseEvent e) {
            AbstractPopupPane.this.mouseEntered(e);
        }

        public void mouseExited(MouseEvent e) {
            AbstractPopupPane.this.mouseExited(e);
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                AbstractPopupPane.this.mousePressed = true;
                AbstractPopupPane.this.processEvent(16);
                AbstractPopupPane.this.btnRight.getModel().setPressed(true);
                AbstractPopupPane.this.btnRight.getModel().setArmed(true);
            }
        }

        public void mouseReleased(MouseEvent e) {
            AbstractPopupPane.this.mouseReleased(e);
        }
    }

    private class RightButton
    extends ToolBarColorButton {
        private RightButton() {
        }

        public Insets getInsets() {
            Insets borderInsets = super.getInsets();
            borderInsets.right = 3;
            borderInsets.left = 3;
            return borderInsets;
        }

        public String getName() {
            return AbstractPopupPane.this.btnLeft.getName() + "_small";
        }
    }

    protected class DefaultActionPropertyListener
    implements PropertyChangeListener {
        protected DefaultActionPropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                if (AbstractPopupPane.this.previewMode || AbstractPopupPane.this.disabledMode) {
                    return;
                }
                AbstractPopupPane.this.btnRight.setEnabled(AbstractPopupPane.this.defaultAction.getAction().isEnabled());
                AbstractPopupPane.this.pumActions = null;
                AbstractPopupPane.this.isPopupShowed = false;
                AbstractPopupPane.this.restoreState();
                AbstractPopupPane.this.isEnabled = AbstractPopupPane.this.defaultAction.getAction().isEnabled();
            }
        }
    }
}

