/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.customizedbutton;

import com.appframework.AppAction;
import com.appframework.CustomizableToolBarComponent;
import com.appframework.components.GWBorder;
import com.appframework.components.customizedbutton.ActionDisabler;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.gwtooltips.GWToolTipManager;
import com.novell.gw.jclient.application.controls.skinnable.ComponentProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinnableButton;
import com.novell.gw.jclient.bl.om.options.ToolBarOptions;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class ToolBarButton
extends SkinnableButton
implements CustomizableToolBarComponent {
    private static Logger logger = Logger.getLogger(ToolBarButton.class);
    private String displayText;
    private int iconPosition = 10;
    private Insets insets = new Insets(5, 5, 5, 5);
    private boolean showTextLabel = true;
    protected boolean previewMode = false;
    private boolean disabledMode = false;
    private boolean alwaysPressed = false;

    public ToolBarButton(AppAction action) {
        this.skinnableDelegate.clearPropertyBindings();
        this.skinnableDelegate.putSkinProperty(SkinProperty.SEL_BORDER_COLOR, ComponentProperty.BACKGROUND);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HIGHLIGHTED_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.TOOLBAR_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.setAction(action);
        this.displayText = action.getName();
        this.init();
    }

    public ToolBarButton(Action a) {
        this.skinnableDelegate.clearPropertyBindings();
        this.skinnableDelegate.putSkinProperty(SkinProperty.SEL_BORDER_COLOR, ComponentProperty.BACKGROUND);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HIGHLIGHTED_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.TOOLBAR_TEXT_COLOR, ComponentProperty.CUSTOM);
        if (a == null) {
            throw new NullPointerException();
        }
        this.setAction(a);
        this.displayText = (String)a.getValue("Name");
        this.init();
    }

    public ToolBarButton(Action a, String theDisplayText) {
        this(a);
        this.displayText = theDisplayText;
        this.setText(this.displayText);
    }

    public ToolBarButton(Icon theDisplayIcon) {
        super(theDisplayIcon);
        this.skinnableDelegate.clearPropertyBindings();
        this.skinnableDelegate.putSkinProperty(SkinProperty.SEL_BORDER_COLOR, ComponentProperty.BACKGROUND);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HIGHLIGHTED_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.TOOLBAR_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.init();
    }

    public ToolBarButton() {
        this.skinnableDelegate.clearPropertyBindings();
        this.skinnableDelegate.putSkinProperty(SkinProperty.SEL_BORDER_COLOR, ComponentProperty.BACKGROUND);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HIGHLIGHTED_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.TOOLBAR_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.init();
    }

    private void init() {
        this.setFocusable(false);
        this.addMouseListener(new ButtonMouseAdapter());
        this.getModel().setArmed(true);
        this.setMargin(this.insets);
        this.setContentAreaFilled(false);
    }

    public void setAlwaysPressed(boolean b) {
        this.alwaysPressed = b;
        this.repaint();
    }

    public boolean isAlwaysPressed() {
        return this.alwaysPressed;
    }

    public void setEnabled(boolean b) {
        if (this.previewMode && !b) {
            return;
        }
        if (this.disabledMode && b) {
            return;
        }
        super.setEnabled(b);
        this.getModel().setArmed(b);
        this.setBorderPainted(b);
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setMargin(Insets m) {
        super.setMargin(m);
        this.insets = m;
    }

    public void setText(String text) {
        super.setText(text);
        if (text != null) {
            this.displayText = text;
        }
    }

    public void setBorder(Border b) {
        Border border = GWBorder.NO_BORDER;
        if (b == GWBorder.LOWERED_BORDER || b == GWBorder.RAISED_BORDER) {
            border = b;
        }
        super.setBorder(border);
    }

    public void setIconPosition(int thePosition) {
        switch (this.iconPosition) {
            case 2: {
                this.setVerticalTextPosition(0);
                this.setHorizontalTextPosition(4);
                this.iconPosition = thePosition;
                break;
            }
            case 4: {
                this.setVerticalTextPosition(0);
                this.setHorizontalTextPosition(2);
                this.iconPosition = thePosition;
                break;
            }
            case 1: {
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(0);
                this.iconPosition = thePosition;
                break;
            }
            case 3: {
                this.setVerticalTextPosition(1);
                this.setHorizontalTextPosition(0);
                this.iconPosition = thePosition;
            }
        }
        this.repaint();
    }

    public void setToolTipText(String text) {
        GWToolTipManager.setToolTipText(this, text);
    }

    protected void mouseEnter(MouseEvent e) {
        if (this.isEnabled()) {
            this.setBorder(GWBorder.RAISED_BORDER);
            this.setContentAreaFilled(true);
            this.getModel().setRollover(true);
        }
    }

    protected void mouseExit(MouseEvent e) {
        this.getModel().setArmed(false);
        if (this.isEnabled()) {
            this.setBorder(GWBorder.NO_BORDER);
            this.setContentAreaFilled(false);
            this.getModel().setRollover(false);
        }
    }

    protected void mousePress(MouseEvent e) {
        if (e.getButton() == 1) {
            if (this.isEnabled()) {
                this.setBorder(GWBorder.LOWERED_BORDER);
            } else {
                this.setBorder(GWBorder.NO_BORDER);
            }
        }
    }

    protected void mouseRelease(MouseEvent e) {
        ToolBarButton b = this;
        if (this.isEnabled()) {
            if (0 <= e.getX() && e.getX() < b.getSize().width && 0 <= e.getY() && e.getY() < b.getSize().height) {
                ((JComponent)b).setBorder(GWBorder.RAISED_BORDER);
            } else {
                ((JComponent)b).setBorder(GWBorder.NO_BORDER);
            }
        } else {
            ((JComponent)b).setBorder(GWBorder.NO_BORDER);
        }
    }

    public void changeComponentStyle(ToolBarOptions.Style style) {
        UIUtils.changeToolbarButtonStyle(this, this.displayText, style, this.showTextLabel);
        this.setOpaque(false);
    }

    public void setPreviewMode(boolean b) {
        if (this.disabledMode) {
            throw new IllegalStateException("control is in disabled mode");
        }
        this.previewMode = b;
        if (b) {
            this.changeAction(new ActionDisabler(this.getAction()));
            this.setEnabled(true);
        } else {
            Action action = this.getAction();
            if (action instanceof ActionDisabler) {
                this.changeAction(((ActionDisabler)action).getOriginalAction());
            }
        }
    }

    public boolean isPreviewMode() {
        return this.previewMode;
    }

    private void changeAction(Action newAction) {
        String text = this.getText();
        this.setAction(newAction);
        this.setText(text);
    }

    public void addDefaultActionListener(ActionListener actionListener) {
        this.addActionListener(actionListener);
    }

    public ActionKey getDefaultActionName() {
        ActionKey name;
        if (this.getAction() instanceof AppAction) {
            name = ((AppAction)this.getAction()).getActionKey();
        } else if (this.getAction() instanceof ActionDisabler) {
            name = ((AppAction)((ActionDisabler)this.getAction()).getOriginalAction()).getActionKey();
        } else {
            throw new AssertionError((Object)("Unexpected action class encountered: " + this.getAction().getClass().getName()));
        }
        if (name == null) {
            logger.warn((Object)"name is null");
        }
        return name;
    }

    public void setShowTextLabel(boolean b) {
        this.showTextLabel = b;
    }

    public boolean showTextLabel() {
        return this.showTextLabel;
    }

    public boolean isDisabledMode() {
        return this.disabledMode;
    }

    public void setDisabledMode(boolean disabled) {
        if (this.previewMode) {
            throw new IllegalStateException("control is in preview mode");
        }
        this.disabledMode = disabled;
        if (disabled) {
            this.changeAction(new ActionDisabler(this.getAction()));
            this.setEnabled(false);
        } else {
            Action action = this.getAction();
            if (action instanceof ActionDisabler) {
                this.changeAction(((ActionDisabler)action).getOriginalAction());
            }
        }
    }

    public class ButtonMouseAdapter
    extends MouseAdapter {
        public void mouseEntered(MouseEvent e) {
            ToolBarButton.this.mouseEnter(e);
        }

        public void mouseExited(MouseEvent e) {
            ToolBarButton.this.mouseExit(e);
        }

        public void mousePressed(MouseEvent e) {
            ToolBarButton.this.mousePress(e);
        }

        public void mouseReleased(MouseEvent e) {
            ToolBarButton.this.mouseRelease(e);
        }
    }
}

