/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.customizedbutton.listpopuppane;

import com.appframework.AppAction;
import com.appframework.components.customizedbutton.AbstractPopupPane;
import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.resources.ImageResources;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.skinnable.ComponentProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinnableLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class HeaderGradientButton
extends SkinnableLabel {
    private static final int ARROW_DISTANCE = 3;
    private static final int ARROW_SEPARATOR = 1;
    private ImageIcon downArrow = ImageResources.ARROW_DOWN;
    private boolean mouseOn = false;
    private boolean arrowVisible = false;
    private AppAction myAction;
    private JPopupMenu arrowPopup = new GWPopupMenu();
    private Color labelColor;
    private static final Insets WIDER_INSETS = new Insets(4, 3, 4, 3);

    public HeaderGradientButton(AppAction theAppAction) {
        this(theAppAction, ((ToolBarButton)theAppAction.getToolBarComponent()).getText());
    }

    public HeaderGradientButton(AppAction theAppAction, String theDisplayText) {
        this.skinnableDelegate.clearPropertyBindings();
        this.skinnableDelegate.putSkinProperty(SkinProperty.HILITE_END_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HILITE_START_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HILITE_BORDER_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HIGHLIGHTED_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.labelColor = null;
        this.myAction = theAppAction;
        this.initComponent(theDisplayText);
    }

    private void initComponent(String displayText) {
        JComponent c = this.myAction.getToolBarComponent();
        if (c instanceof ToolBarButton) {
            ToolBarButton b = (ToolBarButton)c;
            this.setIcon(b.getIcon());
            this.setIconTextGap(b.getIconTextGap());
            this.setToolTipText(b.getToolTipText());
        } else if (c instanceof AbstractPopupPane) {
            AbstractPopupPane b = (AbstractPopupPane)c;
            this.setIcon(b.getIcon());
            this.setToolTipText(b.getToolTipText());
        }
        this.setText(displayText);
        this.setFocusable(true);
        this.setOpaque(false);
        this.addMouseListener(new HeaderButtonMouseListener());
    }

    private Dimension calcSize() {
        Font f = this.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        Rectangle stringBounds = new Rectangle(0, 0, fm.stringWidth(this.getText()), fm.getHeight());
        Insets i = WIDER_INSETS;
        ImageIcon image = (ImageIcon)this.getIcon();
        int w = (image == null ? 0 : image.getIconWidth()) + stringBounds.width + 2 * this.getIconTextGap();
        w += i.left;
        if (this.arrowVisible) {
            w += 8 + this.downArrow.getIconWidth();
        }
        int h = Math.max(stringBounds.height, this.getIcon() == null ? 0 : image.getIconHeight()) + i.top + i.bottom;
        Dimension size = new Dimension(w += i.right, h);
        return size;
    }

    public Dimension getPreferredSize() {
        return this.calcSize();
    }

    private void refresh() {
        this.invalidate();
        JPanel p = (JPanel)this.getParent();
        p.updateUI();
        p.repaint();
    }

    private void updateForeground(Color foreColor) {
        super.setForeground(foreColor);
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.labelColor = fg;
    }

    public void paint(Graphics g) {
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        if (this.mouseOn && this.isShowing()) {
            this.paintGradient(g);
        } else if (this.labelColor != null) {
            this.updateForeground(this.labelColor);
        }
        if (this.isShowing() && ltr) {
            g.translate(HeaderGradientButton.WIDER_INSETS.left, 0);
        }
        Font f = this.getFont();
        Rectangle stringBounds = g.getFontMetrics(f).getStringBounds(this.getText(), g).getBounds();
        super.paint(g);
        if (this.arrowVisible) {
            int x;
            int n = ltr ? (this.getIcon() == null ? 0 : ((ImageIcon)this.getIcon()).getIconWidth() + this.getIconTextGap()) + stringBounds.width + 3 + HeaderGradientButton.WIDER_INSETS.left + 2 : (x = HeaderGradientButton.WIDER_INSETS.left + 3);
            if (this.mouseOn) {
                Color c = (Color)this.getClientProperty((Object)SkinProperty.HILITE_START_COLOR);
                g.setColor(c.darker());
                if (ltr) {
                    g.drawLine(x - 2, 1, x - 2, this.getHeight());
                } else {
                    g.drawLine(x + 1 + 3 + this.downArrow.getIconWidth(), 1, x + 1 + 3 + this.downArrow.getIconWidth(), this.getHeight());
                }
                g.setColor(c.brighter());
                if (ltr) {
                    g.drawLine(x - 1, 1, x - 1, this.getHeight());
                } else {
                    g.drawLine(x + 2 + 3 + this.downArrow.getIconWidth(), 1, x + 2 + 3 + this.downArrow.getIconWidth(), this.getHeight());
                }
            }
            g.translate(-HeaderGradientButton.WIDER_INSETS.left, 0);
            g.drawImage(this.downArrow.getImage(), x + (ltr ? 2 : 0) + 3, (this.getSize().height - this.downArrow.getIconHeight()) / 2, this);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    private void paintGradient(Graphics g) {
        if (this.labelColor == null) {
            this.labelColor = this.getForeground();
        }
        Graphics2D g2D = (Graphics2D)g;
        Color highSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.HILITE_START_COLOR);
        Color highSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.HILITE_END_COLOR);
        Color lowSegmentColorTo = (Color)this.getClientProperty((Object)SkinProperty.HILITE_START_COLOR);
        Color lowSegmentColorFrom = (Color)this.getClientProperty((Object)SkinProperty.HILITE_END_COLOR);
        Color textColor = (Color)this.getClientProperty((Object)SkinProperty.HIGHLIGHTED_TEXT_COLOR);
        Color borderColor = (Color)this.getClientProperty((Object)SkinProperty.HILITE_BORDER_COLOR);
        this.updateForeground(textColor);
        int w = this.getSize().width;
        int h = this.getSize().height;
        GeneralPath border = new GeneralPath();
        border.moveTo(4.0f, 1.0f);
        border.lineTo(3.0f, 1.0f);
        border.lineTo(1.0f, 3.0f);
        border.lineTo(1.0f, 4.0f);
        border.lineTo(0.0f, 5.0f);
        border.lineTo(0.0f, h - 6);
        border.lineTo(1.0f, h - 5);
        border.lineTo(1.0f, h - 4);
        border.lineTo(3.0f, h - 2);
        border.lineTo(4.0f, h - 2);
        border.lineTo(5.0f, h - 1);
        border.lineTo(w - 6, h - 1);
        border.lineTo(w - 5, h - 2);
        border.lineTo(w - 4, h - 2);
        border.lineTo(w - 2, h - 4);
        border.lineTo(w - 2, h - 5);
        border.lineTo(w - 1, h - 6);
        border.lineTo(w - 1, 5.0f);
        border.lineTo(w - 2, 4.0f);
        border.lineTo(w - 2, 3.0f);
        border.lineTo(w - 4, 1.0f);
        border.lineTo(w - 5, 1.0f);
        border.lineTo(w - 6, 0.0f);
        border.lineTo(5.0f, 0.0f);
        GradientPaint paintHigherSegment = new GradientPaint(0.0f, 0.0f, highSegmentColorFrom, 0.0f, (int)((double)this.getHeight() * 0.3), highSegmentColorTo);
        g2D.setPaint(paintHigherSegment);
        g2D.fill(border);
        GradientPaint paintLowerSegment = new GradientPaint(0.0f, (int)((double)this.getHeight() * 0.3), lowSegmentColorFrom, 0.0f, this.getHeight(), lowSegmentColorTo);
        g2D.setPaint(paintLowerSegment);
        g2D.fill(border);
        if (borderColor != null) {
            g2D.setColor(borderColor);
            g2D.draw(border);
        }
    }

    public Insets getInsets() {
        return WIDER_INSETS;
    }

    public void setArrowVisible(boolean arrowVisible) {
        this.arrowVisible = arrowVisible;
    }

    public void addAction(Action a) {
        this.arrowPopup.add(a);
    }

    public void addAction(Action a, String txt) {
        JMenuItem item = new JMenuItem(a);
        item.setText(txt);
        this.arrowPopup.add(item);
    }

    public void addSeparator() {
        this.arrowPopup.addSeparator();
    }

    public AppAction getAction() {
        return this.myAction;
    }

    public int getPopupItemCount() {
        return this.arrowPopup.getComponentCount();
    }

    public boolean isArrowVisible() {
        return this.arrowVisible;
    }

    public JPopupMenu getArrowPopup() {
        return this.arrowPopup;
    }

    private class HeaderButtonMouseListener
    extends MouseAdapter {
        private HeaderButtonMouseListener() {
        }

        public void mouseEntered(MouseEvent e) {
            HeaderGradientButton.this.mouseOn = true;
            HeaderGradientButton.this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            HeaderGradientButton.this.mouseOn = false;
            HeaderGradientButton.this.repaint();
        }

        public void mouseClicked(MouseEvent e) {
            if (HeaderGradientButton.this.isShowing() && SwingUtilities.isLeftMouseButton(e)) {
                if (HeaderGradientButton.this.arrowVisible) {
                    boolean ltr = HeaderGradientButton.this.getComponentOrientation().isLeftToRight();
                    Point ep = e.getPoint();
                    int nIconWidth = HeaderGradientButton.this.downArrow.getIconWidth();
                    int nWidth = HeaderGradientButton.this.getWidth();
                    if (ltr && ep.x < nWidth && ep.x > nWidth - (8 + nIconWidth) || !ltr && ep.x > HeaderGradientButton.this.getInsets().right && ep.x < 8 + nIconWidth) {
                        HeaderGradientButton.this.arrowPopup.show(HeaderGradientButton.this, 0, HeaderGradientButton.this.getHeight());
                        return;
                    }
                }
                HeaderGradientButton.this.myAction.actionPerformed(new ActionEvent(HeaderGradientButton.this, HeaderGradientButton.this.myAction.hashCode(), (String)HeaderGradientButton.this.myAction.getValue("Name")));
                return;
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                HeaderGradientButton.this.grabFocus();
            }
            HeaderGradientButton.this.refresh();
        }
    }
}

