/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrame;
import com.appframework.components.htmleditor.BrowserType;
import com.appframework.components.htmleditor.GWBrowserFactory;
import com.appframework.components.htmleditor.GWMozillaBrowserActionList;
import com.appframework.components.htmleditor.MozillaBrowserSelectionListener;
import com.appframework.components.htmleditor.ViewSourceFrame;
import com.appframework.components.htmleditor.WrappedMozillaBrowser;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.browser.ActionChangeEncoding;
import com.novell.gw.jclient.application.actions.item.ActionReply;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.itemview.contentviewer.HTMLExternalViewerHyperlinkListener;
import com.novell.gw.jclient.application.controls.orientable.OrientableMenuItem;
import com.novell.gw.jclient.application.dialogs.AboutWebRendererDialog;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.webrenderer.swing.IMozillaBrowserCanvas;
import com.webrenderer.swing.event.BrowserAdapter;
import com.webrenderer.swing.event.BrowserEvent;
import com.webrenderer.swing.event.BrowserListener;
import com.webrenderer.swing.event.KeyListener;
import com.webrenderer.swing.event.MouseAdapter;
import com.webrenderer.swing.event.MouseEvent;
import com.webrenderer.swing.event.MouseListener;
import com.webrenderer.swing.event.NetworkAdapter;
import com.webrenderer.swing.event.NetworkEvent;
import com.webrenderer.swing.event.NetworkListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.InputStream;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class GWMozillaBrowser
extends WrappedMozillaBrowser
implements MVCView {
    private static Logger logger = Logger.getLogger(GWMozillaBrowser.class);
    public static boolean SHOW_WEBRENDERER_ABOUT_DIALOG = false;
    private JPopupMenu browserPopupMenu;
    private MVCController controller;
    private boolean isPageLoaded = false;
    protected HTMLExternalViewerHyperlinkListener hyperlinkListener = null;

    GWMozillaBrowser(IMozillaBrowserCanvas browser, MVCController theParentController, BrowserType browserType) {
        super(browser);
        this.controller = new GWMozillaBrowserActionList(this, theParentController);
        if (!BrowserType.BROWSER_PANEL.equals((Object)browserType)) {
            this.setLoadPopupWindowInBrowser(true);
            this.hyperlinkListener = new HTMLExternalViewerHyperlinkListener();
            this.addBrowserListener(this.hyperlinkListener);
        }
        this.addBrowserListener((BrowserListener)new HTMLExternalViewerStatusbarHyperlinkListener(theParentController));
        this.addKeyListener(new GWMozillaBrowserKeyListener());
        this.browserPopupMenu = new BrowserPopupMenu(browserType);
        this.addMouseListener((MouseListener)new BrowserMouseListener());
        MozillaBrowserSelectionListener selectionListener = new MozillaBrowserSelectionListener(this);
        this.addKeyListener(selectionListener);
        this.addMouseListener(selectionListener);
        this.addNetworkListener((NetworkListener)new CurrentNetworkAdapter());
    }

    private void checkWebRendererVerion() {
        if (SHOW_WEBRENDERER_ABOUT_DIALOG) {
            SHOW_WEBRENDERER_ABOUT_DIALOG = false;
            ApplicationFrame applicationFrame = ControlsUtils.getFrameForController(this.controller);
            AboutWebRendererDialog aboutDialog = new AboutWebRendererDialog(applicationFrame);
            aboutDialog.showMe();
            String currentWebrendererVersion = GWBrowserFactory.getWebrendererVersion();
            OptionManager.getInstance().getGeneralOptions().setWebRendererVersion(currentWebrendererVersion);
            OptionManager.getInstance().setGeneralOptions(OptionManager.getInstance().getGeneralOptions());
        }
    }

    public void loadURL(int i, String s, byte[] bytes, String s1, String s2) {
        this.setPageLoaded(false);
        super.loadURL(i, s, bytes, s1, s2);
        this.checkWebRendererVerion();
    }

    public void loadURL(String s) {
        this.setPageLoaded(false);
        super.loadURL(s);
        this.checkWebRendererVerion();
    }

    public void loadURL(URL url) {
        this.setPageLoaded(false);
        super.loadURL(url);
        this.checkWebRendererVerion();
    }

    public void loadHTML(String s, String s1) {
        this.setPageLoaded(false);
        super.loadHTML(s, s1);
        this.checkWebRendererVerion();
    }

    public void loadHTML(byte[] bytes, String s) {
        this.setPageLoaded(false);
        super.loadHTML(bytes, s);
        this.checkWebRendererVerion();
    }

    public void loadHTML(InputStream inputStream, String s) {
        this.setPageLoaded(false);
        super.loadHTML(inputStream, s);
        this.checkWebRendererVerion();
    }

    public void setPage(URL theURL) {
        this.setPageLoaded(false);
        if (this.hyperlinkListener != null) {
            this.hyperlinkListener.setAllowedUrl(theURL.toExternalForm());
        }
        super.setPage(theURL);
        this.checkWebRendererVerion();
    }

    public void setStyledText(String theStyledText) {
        this.setPageLoaded(false);
        super.setStyledText(theStyledText);
        this.checkWebRendererVerion();
    }

    public String getSelectedText() {
        if (this.isPageLoaded()) {
            return super.getSelectedText();
        }
        return "";
    }

    public void reload() {
        this.setPageLoaded(false);
        super.reload();
    }

    public void goForward() {
        this.setPageLoaded(false);
        super.goForward();
    }

    public void goBack() {
        this.setPageLoaded(false);
        super.goBack();
    }

    public boolean isPageLoaded() {
        return this.isPageLoaded;
    }

    public void setPageLoaded(boolean pageLoaded) {
        this.isPageLoaded = pageLoaded;
    }

    public void setController(MVCController theController) {
        this.controller = theController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object theModel) {
    }

    public Object getMVCModel() {
        return this;
    }

    protected void finalize() throws Throwable {
        logger.debug((Object)("finalizing browser: " + this));
        super.finalize();
    }

    private class CurrentNetworkAdapter
    extends NetworkAdapter {
        private CurrentNetworkAdapter() {
        }

        public void onDocumentComplete(NetworkEvent networkEvent) {
            GWMozillaBrowser.this.setPageLoaded(true);
            GWMozillaBrowser.this.getController().processCommand(new Command(1890, GWMozillaBrowser.this));
        }

        public void onDocumentLoad(NetworkEvent networkEvent) {
            GWMozillaBrowser.this.getController().processCommand(new Command(1900, GWMozillaBrowser.this));
        }
    }

    private class GWMozillaBrowserKeyListener
    implements KeyListener {
        private GWMozillaBrowserKeyListener() {
        }

        public void onKeyDown(com.webrenderer.swing.event.KeyEvent keyEvent) {
        }

        public void onKeyUp(com.webrenderer.swing.event.KeyEvent keyEvent) {
        }

        public void onKeyPress(com.webrenderer.swing.event.KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 46 && (keyEvent.getModifiers() & 8) != 0) {
                KeyEvent event = new KeyEvent(GWMozillaBrowser.this, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), 127, '\u007f');
                SwingUtilities.processKeyBindings(event);
            }
        }
    }

    private class ActionViewSource
    extends AbstractAction {
        public ActionViewSource() {
            super(StringResources.VIEW_SOURCE);
        }

        public void actionPerformed(ActionEvent e) {
            ViewSourceFrame.display(GWMozillaBrowser.this.browser.getDocument().getDocumentSource());
        }
    }

    private static class ActionBrowserPaste
    extends AbstractAction {
        public ActionBrowserPaste() {
            super(StringResources.PASTE);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private static class ActionBrowserCut
    extends AbstractAction {
        public ActionBrowserCut() {
            super(StringResources.CUT);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private class ActionBrowserCopy
    extends AbstractAction {
        public ActionBrowserCopy() {
            super(StringResources.COPY);
        }

        public void actionPerformed(ActionEvent e) {
            GWMozillaBrowser.this.browser.copy();
        }
    }

    private class BrowserPopupMenu
    extends GWPopupMenu {
        private OrientableMenuItem replyMenuItem;
        private ActionBrowserCopy actionCopy;

        public BrowserPopupMenu(BrowserType browserType) {
            ActionList actionList = GWMozillaBrowser.this.controller.getParentController().getActionList();
            this.addAction(actionList.getAction(ActionKey.SELECT_ALL));
            this.add(new OrientableMenuItem(new ActionBrowserCut()));
            this.actionCopy = new ActionBrowserCopy();
            this.add(new OrientableMenuItem(this.actionCopy));
            this.add(new OrientableMenuItem(new ActionBrowserPaste()));
            this.addSeparator();
            ActionReply actionReply = (ActionReply)actionList.getAction(ActionKey.REPLY);
            if (actionReply != null) {
                this.replyMenuItem = new OrientableMenuItem(actionReply.getName());
                this.replyMenuItem.addActionListener(actionReply);
                this.add(this.replyMenuItem);
            }
            this.add(new JMenuItem(new ActionViewSource()));
            if (!BrowserType.BROWSER_PANEL.equals((Object)browserType)) {
                this.addSeparator();
                this.addAction(actionList.getAction(ActionKey.SAVE_GWITEM));
                this.addSeparator();
                this.addAction(actionList.getAction(ActionKey.PRINT));
            }
            if (BrowserType.CONTENT_VIEWER.equals((Object)browserType)) {
                this.addSeparator();
                this.add(((ActionChangeEncoding)GWMozillaBrowser.this.getController().getActionList().getAction(ActionKey.CHANGE_ENCODING)).getEncodingsMenu());
            }
        }

        private void addAction(Action action) {
            if (action != null) {
                OrientableMenuItem menuItem = new OrientableMenuItem(((AppAction)action).getName());
                menuItem.addActionListener(action);
                this.add(menuItem);
            }
        }

        public void addSeparator() {
            if (!(this.getComponent(this.getComponentCount() - 1) instanceof JSeparator)) {
                super.addSeparator();
            }
        }

        public void setVisible(boolean b) {
            if (this.replyMenuItem != null) {
                this.replyMenuItem.setEnabled(GWMozillaBrowser.this.getSelectedText() != null);
            }
            this.actionCopy.setEnabled(GWMozillaBrowser.this.getSelectedText() != null && GWMozillaBrowser.this.getSelectedText().length() > 0);
            super.setVisible(b);
        }
    }

    private class BrowserMouseListener
    extends MouseAdapter {
        private BrowserMouseListener() {
        }

        public void onMouseDown(MouseEvent event) {
            Component browser = GWMozillaBrowser.this.browser.getComponent();
            if (event.isPopupTrigger()) {
                JPopupMenu browserPopupMenu = GWMozillaBrowser.this.browserPopupMenu;
                GWMozillaBrowser.this.getController().processCommand(new Command(1901, GWMozillaBrowser.this));
                browserPopupMenu.show(browser, event.getX(), event.getY());
                browserPopupMenu.repaint();
            } else if (GWMozillaBrowser.this.browserPopupMenu.isVisible()) {
                GWMozillaBrowser.this.browserPopupMenu.setVisible(false);
            }
        }
    }

    private static class HTMLExternalViewerStatusbarHyperlinkListener
    extends BrowserAdapter {
        private MVCController controller;

        public HTMLExternalViewerStatusbarHyperlinkListener(MVCController theController) {
            this.controller = theController;
        }

        public void onLinkChange(BrowserEvent event) {
            Command command = new Command(630, event.getLink());
            this.controller.processCommand(command);
        }
    }
}

