/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.RTFFontTableEntry;
import com.appframework.components.htmleditor.RTFUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class RTFFontTable {
    public static final String RTF_FONTTABLE_GROUP = "fonttbl";
    public static final String RTF_FONTTABLE_GROUP_START = "{\\fonttbl";
    private String result = null;
    private boolean ok = false;
    private List entries = new ArrayList();
    private Map fontIDs = new TreeMap();

    public void addEntry(RTFFontTableEntry entry) {
        if (entry != null) {
            this.entries.add(entry);
            if (this.fontIDs.get(entry.getFontname()) == null) {
                ArrayList<Integer> listID = new ArrayList<Integer>();
                listID.add(new Integer(entry.getNum()));
                this.fontIDs.put(entry.getFontname(), listID);
            } else {
                Integer i;
                List listID = (List)this.fontIDs.get(entry.getFontname());
                if (!listID.contains(i = new Integer(entry.getNum()))) {
                    listID.add(i);
                    this.fontIDs.put(entry.getFontname(), listID);
                }
            }
        }
    }

    public RTFFontTable(String rawTable) {
        this.parse(rawTable);
    }

    private void parse(String txt) {
        if (txt == null || txt.length() < 1) {
            this.result = "Null or empty input string [" + txt + ']';
            return;
        }
        if (!txt.startsWith(RTF_FONTTABLE_GROUP_START)) {
            this.result = "Missing START bracket and/or group name [" + txt + ']';
            return;
        }
        if (!txt.endsWith("}")) {
            this.result = "Missing closing bracket [" + txt + ']';
            return;
        }
        StringBuffer sb = new StringBuffer(txt.substring(RTF_FONTTABLE_GROUP_START.length(), txt.length() - 1));
        if (sb.indexOf("\\f") == 0 && sb.lastIndexOf(";") == sb.length() - 1) {
            while (sb.length() > 0) {
                String entryId = "f" + this.entries.size();
                int entryStart = sb.indexOf('\\' + entryId);
                int entryEnd = sb.indexOf(";") + 1;
                if (entryStart == -1) {
                    this.result = "Invalid entry encountered: Start tag \"" + entryId + "\" not found [[[\n" + sb + "\n]]]";
                    return;
                }
                if (entryEnd == -1) {
                    this.result = "Invalid entry encountered: End bracket \"" + entryId + "\" not found [[[\n" + sb + "\n]]]";
                    return;
                }
                String entryText = '{' + sb.substring(entryStart, entryEnd) + '}';
                RTFFontTableEntry entry = new RTFFontTableEntry(entryText);
                if (entry.isOk()) {
                    this.addEntry(entry);
                    sb.delete(entryStart, entryEnd);
                    continue;
                }
                this.result = "Invalid entry encountered: \"" + entryId + "\" not found [[[\n" + entryText + "\n]]]";
                return;
            }
        } else {
            while (sb.length() > 0) {
                String entryId = "f" + this.entries.size();
                int entryStart = RTFUtils.indexOfGroupBegin(sb.toString(), entryId);
                int entryEnd = RTFUtils.indexOfGroupEnd(sb.toString(), entryId) + 1;
                if (entryStart == -1) {
                    this.result = "Invalid entry encountered: Start tag \"" + entryId + "\" not found [[[\n" + sb + "\n]]]";
                    return;
                }
                if (entryEnd == -1) {
                    this.result = "Invalid entry encountered: End bracket \"" + entryId + "\" not found [[[\n" + sb + "\n]]]";
                    return;
                }
                String entryText = sb.substring(entryStart, entryEnd);
                RTFFontTableEntry entry = new RTFFontTableEntry(entryText);
                if (entry.isOk()) {
                    this.addEntry(entry);
                    sb.delete(entryStart, entryEnd);
                    continue;
                }
                this.result = "Invalid entry encountered: \"" + entryId + "\" not found [[[\n" + entryText + "\n]]]";
                return;
            }
        }
        this.result = "Found " + this.entries.size() + " font entries";
        this.ok = true;
    }

    public boolean isOk() {
        return this.ok;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public List getEntries() {
        return this.entries;
    }

    public Set getFontNames() {
        return this.fontIDs.keySet();
    }

    public List getFontIDsByFontName(String fontName) {
        List res = null;
        if (fontName != null) {
            res = (List)this.fontIDs.get(fontName);
        }
        return res;
    }

    public int getFirstEntryIDByFontName(String fontName) {
        List list = this.getFontIDsByFontName(fontName);
        int res = -1;
        if (list != null && !list.isEmpty()) {
            res = (Integer)list.get(0);
        }
        return res;
    }
}

