/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.multyactionlabel;

import com.appframework.resources.GWIcons;
import com.appframework.utils.UIUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicIconFactory;

public class CombinedCheckedIcon
extends ImageIcon {
    private int gap = 4;
    protected Icon checkIcon;
    protected Icon mainIcon;
    private BufferedImage bufferedImage;
    private boolean isLeftToRight = true;

    public CombinedCheckedIcon(Icon theMainIcon) {
        if (theMainIcon == null) {
            theMainIcon = GWIcons.EMPTY_ICON;
        }
        this.mainIcon = theMainIcon;
        this.checkIcon = (Icon)UIManager.get("CheckBoxMenuItem.checkIcon");
        if (this.checkIcon == null) {
            this.checkIcon = BasicIconFactory.getCheckBoxMenuItemIcon();
        }
        this.bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        this.setImage(this.bufferedImage);
        this.isLeftToRight = UIUtils.getComponentOrientation().isLeftToRight();
    }

    public CombinedCheckedIcon() {
        this.checkIcon = BasicIconFactory.getCheckBoxMenuItemIcon();
        this.gap = 7;
        this.bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        this.setImage(this.bufferedImage);
        this.isLeftToRight = UIUtils.getComponentOrientation().isLeftToRight();
    }

    public void paintIcon(Component theComponent, Graphics theGraphics, int theX, int theY) {
        int cy = 0;
        if (this.mainIcon != null && this.checkIcon.getIconHeight() < this.mainIcon.getIconHeight()) {
            cy = (this.mainIcon.getIconHeight() - this.checkIcon.getIconHeight()) / 2;
        }
        this.bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        this.setImage(this.bufferedImage);
        Graphics2D gr = this.bufferedImage.createGraphics();
        gr.setColor(theGraphics.getColor());
        if (this.isLeftToRight) {
            this.checkIcon.paintIcon(theComponent, gr, 0, cy + 1);
            if (this.mainIcon != null) {
                this.mainIcon.paintIcon(theComponent, gr, this.checkIcon.getIconWidth() + this.gap, 0);
            }
        } else {
            this.checkIcon.paintIcon(theComponent, gr, this.getIconWidth() - this.checkIcon.getIconWidth(), cy + 1);
            if (this.mainIcon != null) {
                this.mainIcon.paintIcon(theComponent, gr, this.getIconWidth() - (this.checkIcon.getIconWidth() + this.gap + this.mainIcon.getIconWidth()), 0);
            }
        }
        theGraphics.drawImage(this.getImage(), theX, theY, this.getImageObserver());
    }

    public int getIconWidth() {
        if (this.mainIcon != null) {
            return this.checkIcon.getIconWidth() + this.mainIcon.getIconWidth() + this.gap;
        }
        return this.checkIcon.getIconWidth() + this.gap;
    }

    public int getIconHeight() {
        if (this.mainIcon != null) {
            return Math.max(this.checkIcon.getIconHeight(), this.mainIcon.getIconHeight());
        }
        return this.checkIcon.getIconHeight();
    }
}

