/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.event;

import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.event.AppEventManager;
import com.appframework.level.Level;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

class AppEventManagerProxy
extends AppEventManager {
    private static Logger logger = Logger.getLogger(AppEventManagerProxy.class);

    protected AppEventManagerProxy() {
    }

    public void addListener(Level theLevel, Integer theEventID, AppEventListener theListener) {
        try {
            super.addListener(theLevel, theEventID, theListener);
        }
        catch (RuntimeException e) {
            logger.debug((Object)("---> theLevel = " + theLevel));
            logger.debug((Object)("---> theEventID = " + theEventID));
            logger.debug((Object)("---> theListener = " + theListener));
            this.processException(e);
            throw e;
        }
    }

    public int getListenersCount() {
        try {
            return super.getListenersCount();
        }
        catch (RuntimeException e) {
            this.processException(e);
            throw e;
        }
    }

    public void processEvent(AppEvent theEvent) {
        try {
            super.processEvent(theEvent);
        }
        catch (RuntimeException e) {
            logger.debug((Object)("---> theEvent = " + theEvent));
            this.processException(e);
            throw e;
        }
    }

    public void processGlobalEvent(AppEvent theEvent) {
        try {
            super.processGlobalEvent(theEvent);
        }
        catch (RuntimeException e) {
            logger.debug((Object)("---> theEvent = " + theEvent));
            this.processException(e);
            throw e;
        }
    }

    public void release(Level theLevel) {
        try {
            super.release(theLevel);
        }
        catch (RuntimeException e) {
            logger.debug((Object)("---> theLevel = " + theLevel));
            this.processException(e);
            throw e;
        }
    }

    public void removeListener(Level theLevel, Integer theEventID, AppEventListener theListener) {
        try {
            super.removeListener(theLevel, theEventID, theListener);
        }
        catch (RuntimeException e) {
            logger.debug((Object)("---> theLevel = " + theLevel));
            logger.debug((Object)("---> theEventID = " + theEventID));
            logger.debug((Object)("---> theListener = " + theListener));
            this.processException(e);
            throw e;
        }
    }

    private void processException(Exception exception) {
        if (!(exception instanceof ConcurrentModificationException)) {
            return;
        }
        logger.debug((Object)"*******************************************************************************");
        logger.debug((Object)"*************************** START OF DEBUG INFO *******************************");
        logger.debug((Object)"***************** ConcurrentModificationException cought **********************");
        Map<Thread, StackTraceElement[]> threadStackMap = Thread.getAllStackTraces();
        Set<Thread> threadSet = threadStackMap.keySet();
        logger.debug((Object)("there are " + threadSet.size() + " threads"));
        for (Thread thread : threadSet) {
            StackTraceElement[] stack;
            logger.debug((Object)("**************** thread: " + thread + (thread == Thread.currentThread() ? " CURRENT THREAD" : "") + ':'));
            for (StackTraceElement element : stack = threadStackMap.get(thread)) {
                logger.debug((Object)(">>> " + element.toString()));
            }
            logger.debug((Object)"*******************************************************************************");
        }
        logger.debug((Object)"*************************** END OF DEBUG INFO *********************************");
        logger.debug((Object)"*******************************************************************************");
    }
}

