/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.level;

import com.appframework.event.AppEventManager;
import com.appframework.level.Level;
import com.appframework.mvc.ControllerManager;
import com.appframework.mvc.MVCController;
import java.util.List;
import org.apache.log4j.Logger;

public class LevelManager {
    private static final Logger logger = Logger.getLogger(LevelManager.class);
    private final Level globalLevel = new Level(0L);
    private static LevelManager instance;
    protected int levelCounter = 0;

    public static LevelManager getInstance() {
        if (instance == null) {
            instance = new LevelManager();
        }
        return instance;
    }

    private LevelManager() {
    }

    public Level getGlobalLevel() {
        return this.globalLevel;
    }

    public Level createLevel() {
        return this.createLevel(null);
    }

    public Level createLevel(Level theParent) {
        if (theParent == null) {
            theParent = this.globalLevel;
        }
        return new Level(++this.levelCounter, theParent);
    }

    @Deprecated
    public Level getFrameLevel(Level theLevel) {
        Level result = theLevel;
        while (!this.globalLevel.equals(result.getParent())) {
            result = result.getParent();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(Level level) {
        MVCController controller = ControllerManager.getInstance().get(level);
        if (controller != null) {
            controller.prepareForRelease();
        } else {
            logger.warn((Object)("controller is null for level: " + level));
        }
        List<Level> children = level.getChildren();
        while (!children.isEmpty()) {
            LevelManager.release(children.get(0));
        }
        if (controller != null) {
            MVCController mVCController = controller;
            synchronized (mVCController) {
                ControllerManager.getInstance().release(level);
                AppEventManager.getInstance().release(level);
                Level parent = level.getParent();
                if (parent != null) {
                    parent.remove(level);
                }
            }
        }
    }
}

