/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.tools;

import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.impl.StreamHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Properties;
import org.apache.log4j.Logger;

public class LangResourceBuilder {
    private static Logger logger = Logger.getLogger(LangResourceBuilder.class);
    public static String TEST_PREFIX = "--- >>>";
    public static final String SOURCE_FILE = "StringResources.java";
    private static final String TEST = "test";
    private static final String EMPTY = "empty";
    private static final String ENG = "eng";
    private static String mode = "empty";
    public static final String RESOURCE_PATH = Utils.USER_DIR + File.separator + "src" + File.separator + "com" + File.separator + "novell" + File.separator + "gw" + File.separator + "jclient" + File.separator + "application" + File.separator + "resources" + File.separator;
    public static final String LANG_PROPERTIES_PATH = RESOURCE_PATH + "lang" + File.separator;

    public static void main(String[] args) {
        if (args.length > 0) {
            if (TEST.equals(args[0])) {
                mode = TEST;
            } else if (ENG.equals(args[0])) {
                mode = ENG;
            } else if (EMPTY.equals(args[0])) {
                mode = EMPTY;
            } else if ("prop".equals(args[0])) {
                mode = "prop";
            }
        } else {
            mode = ENG;
        }
        LangResourceBuilder.buildProperties();
    }

    private static void buildProperties() {
        Properties properties = null;
        String fileName = LANG_PROPERTIES_PATH;
        if (EMPTY.equals(mode)) {
            properties = LangResourceBuilder.buildEmptyProperties();
            fileName = fileName + "empty.properties";
        } else if (TEST.equals(mode)) {
            properties = LangResourceBuilder.buildTestProperties();
            fileName = fileName + "test_en_US.properties";
        } else if (ENG.equals(mode)) {
            properties = LangResourceBuilder.buildEngProperties();
            fileName = fileName + "GWClient_en_US.properties";
        } else if ("prop".equals(mode)) {
            properties = LangResourceBuilder.build();
            fileName = fileName + "half-done.properties";
        } else {
            logger.debug((Object)"WRONG MODE NAME");
            return;
        }
        LangResourceBuilder.mergeProperties(fileName, properties);
    }

    private static void mergeProperties(String fileName, Properties properties) {
        Properties existedProperties = new Properties();
        Properties newProperties = new Properties();
        try {
            FileInputStream in = new FileInputStream(fileName);
            existedProperties.load(in);
            in.close();
        }
        catch (IOException e) {
            logger.error((Object)"No old properties file.");
        }
        Object[] keys = properties.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            if (existedProperties.get(keys[i]) != null) continue;
            newProperties.put(keys[i], properties.get(keys[i]));
        }
        if (!newProperties.isEmpty()) {
            try {
                int i;
                FileOutputStream out = new FileOutputStream(fileName, true);
                out.write("\n".getBytes());
                String user = System.getProperty("user.name");
                keys = newProperties.keySet().toArray();
                Arrays.sort(keys);
                if (keys.length > 0) {
                    // empty if block
                }
                for (i = 0; i < keys.length; ++i) {
                    Object key = keys[i];
                    Object value = newProperties.get(key);
                }
                newProperties.store(out, user == null ? "" : "Added by " + user);
                out.close();
                System.out.println("Added new properties:");
                keys = newProperties.keySet().toArray();
                for (i = 0; i < keys.length - 1; ++i) {
                    System.out.print(keys[i] + ", ");
                }
                System.out.println(keys[keys.length - 1]);
            }
            catch (IOException e) {
                logger.error((Object)"There was an error while writing merged resources.");
            }
        } else {
            System.out.println("\nThere are no new properties.");
        }
    }

    private static Properties buildEngProperties() {
        Field[] fields = StringResources.class.getFields();
        Properties properties = new Properties();
        try {
            String sourceData = new String(StreamHandler.getInstance().getStreamData(new FileInputStream(RESOURCE_PATH + SOURCE_FILE)));
            for (int i = 0; i < fields.length; ++i) {
                Field tempField = fields[i];
                int modifier = tempField.getModifiers();
                if (!Modifier.isPublic(modifier) || !Modifier.isStatic(modifier) || Modifier.isFinal(modifier) || tempField.getType() != String.class) continue;
                String name = tempField.getName();
                int pos = LangResourceBuilder.findStartPositionForSerchString(sourceData, "public static String " + name, 0);
                int posStart = sourceData.indexOf(34, pos);
                int posEnd = sourceData.indexOf(34, posStart + 1);
                String value = sourceData.substring(posStart + 1, posEnd);
                properties.put(name, value);
            }
        }
        catch (IOException e) {
            logger.error((Object)"Can't read source file: StringResources.java");
        }
        return properties;
    }

    private static int findStartPositionForSerchString(String theSourceData, String theName, int position) {
        if (theSourceData.length() == 0) {
            return -1;
        }
        int pos = theSourceData.indexOf(theName, position);
        int index = pos + theName.length() + 1;
        if (theSourceData.charAt(index) != ' ' && theSourceData.charAt(index) != '=' && theSourceData.charAt(index) != '\t') {
            return LangResourceBuilder.findStartPositionForSerchString(theSourceData, theName, index);
        }
        return pos;
    }

    private static Properties buildTestProperties() {
        Field[] fields = StringResources.class.getFields();
        Properties properties = new Properties();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            properties.put(name, TEST_PREFIX + name);
        }
        return properties;
    }

    private static Properties buildEmptyProperties() {
        Field[] fields = StringResources.class.getFields();
        Properties properties = new Properties();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            properties.put(name, "");
        }
        return properties;
    }

    private static Properties build() {
        Field[] fields = StringResources.class.getFields();
        Properties properties = new Properties();
        try {
            String sourceData = new String(StreamHandler.getInstance().getStreamData(new FileInputStream(RESOURCE_PATH + SOURCE_FILE)));
            for (int i = 0; i < fields.length; ++i) {
                String name = fields[i].getName();
                int pos = sourceData.indexOf(' ' + name + " = ");
                int posStart = sourceData.indexOf(34, pos);
                int posEnd = sourceData.indexOf(34, posStart + 1);
                String value = sourceData.substring(posStart + 1, posEnd);
                properties.put("properties.put(\"" + name + "\", \"" + value + "\");", "");
            }
        }
        catch (IOException e) {
            logger.error((Object)"Can't read source file: StringResources.java");
        }
        return properties;
    }
}

