/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import com.novell.gw.engine.EngineInputStream;
import com.novell.gw.jclient.bl.om.PathManager;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public class CertificatesUtils {
    private static final Logger logger = Logger.getLogger(CertificatesUtils.class);
    private static final String UNKNOWN_CERTIFICATE = "unknown_certificate";

    public static String getCertificateDirPath() {
        StringBuilder builder = new StringBuilder();
        builder.append(PathManager.getBaseOptionsPath());
        builder.append(File.separator);
        builder.append("certificates");
        return builder.toString();
    }

    public static Certificate[] getStoredCertificates() {
        File file = new File(CertificatesUtils.getCertificateDirPath());
        File[] files = file.listFiles();
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        if (files != null) {
            for (File certificateFile : files) {
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(certificateFile));
                    Certificate certificate = certificateFactory.generateCertificate(inputStream);
                    certificates.add(certificate);
                }
                catch (CertificateException e) {
                    logger.error((Object)e);
                }
                catch (FileNotFoundException e) {
                    logger.error((Object)e);
                }
            }
        }
        return certificates.toArray(new Certificate[certificates.size()]);
    }

    public static boolean storeCertificate(Certificate certificate) {
        String certificateDirPath = CertificatesUtils.getCertificateDirPath();
        String name = CertificatesUtils.getFileNameForCertificate(certificate);
        StringBuilder builder = new StringBuilder();
        builder.append(certificateDirPath);
        builder.append(File.separator);
        builder.append(name);
        try {
            File file = new File(builder.toString());
            File parent = new File(file.getParent());
            if (parent.exists() || parent.mkdirs()) {
                FileOutputStream outputStream = new FileOutputStream(builder.toString());
                ((OutputStream)outputStream).write(certificate.getEncoded());
                return true;
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        catch (CertificateEncodingException e) {
            logger.error((Object)e);
        }
        return false;
    }

    private static String getParameter(String text, String key) {
        if (text == null || text.equals("") || key == null || key.equals("")) {
            throw new IllegalArgumentException();
        }
        int index = text.toLowerCase().indexOf(key.toLowerCase());
        if (index != -1) {
            String result = text.substring(index + key.length());
            if ((index = result.indexOf(",")) != -1) {
                result = result.substring(0, index);
            }
            return result;
        }
        return "";
    }

    public static String getIssuerAliasName(Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            X500Principal principal = x509Certificate.getIssuerX500Principal();
            String name = principal.getName();
            String O = CertificatesUtils.getParameter(name, "o=");
            String OU = CertificatesUtils.getParameter(name, "ou=");
            StringBuilder builder = new StringBuilder();
            builder.append(O);
            if (!O.equals("") && !OU.equals("")) {
                builder.append(" ");
            }
            builder.append(OU);
            return builder.toString();
        }
        return "";
    }

    public static String getSubjectAliasName(Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            X500Principal principal = x509Certificate.getSubjectX500Principal();
            String name = principal.getName();
            return CertificatesUtils.getParameter(name, "cn=");
        }
        return "";
    }

    public static String getFileNameForCertificate(Certificate certificate) {
        String tag;
        X500Principal principal;
        String name;
        int tagIndex;
        String path = "";
        if (certificate instanceof X509Certificate && (tagIndex = (name = (principal = ((X509Certificate)certificate).getSubjectX500Principal()).getName().toLowerCase()).indexOf(tag = "cn=")) != -1) {
            int index = (name = name.substring(tagIndex + tag.length())).indexOf(",");
            if (index != -1) {
                name = name.substring(0, index);
            }
            if (name.startsWith(".")) {
                name = name.substring(1, name.length());
            }
            path = name;
        }
        if (path.equals("")) {
            File file = new File(CertificatesUtils.getCertificateDirPath());
            int newIndex = 0;
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    Integer index;
                    String name2 = child.getName();
                    if (!name2.contains(UNKNOWN_CERTIFICATE) || (index = Integer.valueOf(name2 = name2.substring(0, UNKNOWN_CERTIFICATE.length() - 1))) <= newIndex) continue;
                    newIndex = index + 1;
                }
            }
            path = UNKNOWN_CERTIFICATE + newIndex;
        }
        return path;
    }

    public static InputStream convertEngineInputStream(EngineInputStream certStream) throws IOException {
        int b;
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        while ((b = certStream.read()) != -1) {
            byteList.add((byte)b);
        }
        int size = byteList.size();
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = (Byte)byteList.get(i);
        }
        return new ByteArrayInputStream(bytes);
    }

    public static Certificate[] extractCertificates(InputStream inputStream) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        Certificate[] certificates = null;
        Certificate tempCertificate = null;
        try {
            tempCertificate = factory.generateCertificate(inputStream);
        }
        catch (CertificateException e) {
            logger.error((Object)e);
        }
        if (tempCertificate != null) {
            certificates = new Certificate[]{tempCertificate};
        }
        return certificates;
    }
}

