/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import com.appframework.Tested;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Day
implements Comparable<Day> {
    private int year = 0;
    private int dayOfYear = 1;

    public Day(Calendar calendar) {
        this.setCalendar(calendar);
    }

    public Day(int year, int dayOfYear) {
        this.setYear(year);
        this.setDayOfYear(dayOfYear);
    }

    public int getDayOfYear() {
        return this.dayOfYear;
    }

    public void setDayOfYear(int dayOfYear) {
        if (dayOfYear < 1) {
            throw new IllegalArgumentException("invalid dayOfYear: " + dayOfYear);
        }
        this.dayOfYear = dayOfYear;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public void setCalendar(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("calendar is null");
        }
        this.setYear(calendar.get(1));
        this.setDayOfYear(calendar.get(6));
    }

    @Tested
    public Day addDays(int days) {
        if (days == 0) {
            return this;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, this.year);
        calendar.set(6, this.dayOfYear);
        calendar.get(1);
        calendar.add(6, days);
        this.setCalendar(calendar);
        return this;
    }

    @Tested
    public int getDifference(Day day) {
        if (day == null) {
            throw new IllegalArgumentException("day is null");
        }
        int difference = 0;
        if (!this.equals(day)) {
            if (this.year == day.year) {
                difference = this.dayOfYear - day.dayOfYear;
            } else {
                int step = this.year - day.year >= 0 ? 1 : -1;
                Day clone = day.makeClone();
                while (!clone.equals(this)) {
                    clone.addDays(step);
                    difference += step;
                }
            }
        }
        return difference;
    }

    public Day makeClone() {
        return new Day(this.year, this.dayOfYear);
    }

    public String toString() {
        return "Day[year = " + this.year + ", dayOfYear = " + this.dayOfYear + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Day day = (Day)o;
        if (this.dayOfYear != day.dayOfYear) {
            return false;
        }
        return this.year == day.year;
    }

    public int hashCode() {
        return 31 * this.year + this.dayOfYear;
    }

    @Override
    @Tested
    public int compareTo(Day day) {
        if (day == null) {
            throw new IllegalArgumentException("day is null");
        }
        if (this.equals(day)) {
            return 0;
        }
        if (this.year == day.year) {
            return this.dayOfYear - day.dayOfYear;
        }
        return this.year - day.year;
    }
}

