/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JavaVendor {
    SUN{

        @Override
        public List<String> getNameList() {
            ArrayList<String> names = new ArrayList<String>();
            names.add("Sun Microsystems Inc.");
            return names;
        }
    }
    ,
    BEA{

        @Override
        public List<String> getNameList() {
            ArrayList<String> names = new ArrayList<String>();
            names.add("BEA Systems, Inc.");
            return names;
        }
    }
    ,
    IBM{

        @Override
        public List<String> getNameList() {
            ArrayList<String> names = new ArrayList<String>();
            names.add("IBM Corporation");
            return names;
        }
    }
    ,
    APPLE{

        @Override
        public List<String> getNameList() {
            ArrayList<String> names = new ArrayList<String>();
            names.add("Apple Computer, Inc.");
            names.add("Apple Inc.");
            return names;
        }
    };

    private static Logger logger;

    public abstract List<String> getNameList();

    public static JavaVendor getVendor(String vendorName) {
        if (vendorName == null) {
            throw new IllegalArgumentException("vendorName is null");
        }
        vendorName = vendorName.trim();
        for (JavaVendor vendor : JavaVendor.values()) {
            if (!vendor.getNameList().contains(vendorName)) continue;
            return vendor;
        }
        logger.warn((Object)("strange java.vendor name: " + vendorName + " > assuming it is default (SUN)"));
        return SUN;
    }

    static {
        logger = Logger.getLogger(JavaVendor.class);
    }
}

