/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import com.appframework.Tested;
import com.appframework.utils.OS;
import com.appframework.utils.ProxyDesktop;
import com.appframework.utils.Utils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class NetUtils {
    private static Logger logger = Logger.getLogger(NetUtils.class);
    public static final String PROTOCOL_PREFIX_HTTP = "http:";
    public static final String PROTOCOL_PREFIX_HTTPS = "https:";
    public static final String PROTOCOL_PREFIX_FILE = "file:";
    public static final String PROTOCOL_PREFIX_JAR = "jar:";
    public static final String PROTOCOL_PREFIX_MAILTO = "mailto:";
    public static final ArrayList<String> ACCEPTABLE_PROTOCOL_PREFIXES;
    private static final Pattern DOMAIN_PATTERN;

    public static URL createUrl(String url) throws MalformedURLException {
        if (Utils.isNullOrEmpty(url)) {
            throw new IllegalArgumentException("url is null or empty");
        }
        url = url.trim();
        logger.debug((Object)("url: " + url));
        boolean protocolAccepted = false;
        int index = url.indexOf(58);
        if (index > -1) {
            String protocolPrefix = url.substring(0, index + 1);
            logger.debug((Object)("protocol prefix: " + protocolPrefix));
            if (ACCEPTABLE_PROTOCOL_PREFIXES.contains(protocolPrefix)) {
                protocolAccepted = true;
            } else {
                logger.warn((Object)("strange protocol: " + protocolPrefix));
            }
        } else {
            logger.debug((Object)"no protocol prefix");
        }
        if (!protocolAccepted) {
            if ((OS.isLinuxOS() || OS.isMacOS()) && url.startsWith("/")) {
                logger.debug((Object)"adding FILE protocol prefix");
                url = "file://" + url;
            } else {
                logger.debug((Object)"adding HTTP protocol prefix");
                url = "http://" + url;
            }
        }
        return new URL(url);
    }

    public static void showInSystemBrowser(String url) {
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        logger.debug((Object)("url: " + url));
        boolean browserLaunched = false;
        try {
            if (ProxyDesktop.isDesktopSupported()) {
                logger.debug((Object)"Desktop is supported");
                ProxyDesktop desktop = ProxyDesktop.getDesktop();
                if (desktop.isSupported(ProxyDesktop.Action.BROWSE)) {
                    logger.debug((Object)"BROWSE action is supported by desktop");
                    desktop.browse(new URI(url));
                    browserLaunched = true;
                }
            }
        }
        catch (IOException ex) {
            logger.error((Object)ex);
            logger.debug((Object)ex, (Throwable)ex);
        }
        catch (URISyntaxException ex) {
            logger.error((Object)ex);
            logger.debug((Object)ex, (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            logger.debug((Object)ex, (Throwable)ex);
        }
        if (!browserLaunched) {
            logger.debug((Object)"Desktop API failed > trying command line");
            Utils.callExternal(url);
        }
    }

    public static boolean isMailtoUrl(String url) {
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        return url.trim().startsWith(PROTOCOL_PREFIX_MAILTO);
    }

    @Tested
    public static boolean isUrlValid(String url) {
        if (Utils.isNullOrEmpty(url)) {
            throw new IllegalArgumentException("url is null or empty");
        }
        url = NetUtils.ensureProtocolForUrl(url);
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    @Tested
    public static boolean isDomainValid(String domain) {
        if (domain == null) {
            throw new IllegalArgumentException("domain is null");
        }
        return DOMAIN_PATTERN.matcher(domain).matches();
    }

    private static String ensureProtocolForUrl(String url) {
        assert (!Utils.isNullOrEmpty(url));
        int index = url.indexOf(58);
        if (index < 0) {
            url = "http://" + url;
        }
        return url;
    }

    public static boolean areURLEqualsIgnoringRequestParams(String url1, String url2) {
        if (url1.startsWith(PROTOCOL_PREFIX_FILE)) {
            url1 = NetUtils.fixFileProtocolPrefix(url1);
        }
        if (url2.startsWith(PROTOCOL_PREFIX_FILE)) {
            url2 = NetUtils.fixFileProtocolPrefix(url2);
        }
        if (url1.equals(url2)) {
            return true;
        }
        int queryBegin = url2.indexOf(63);
        return queryBegin > 0 && url1.indexOf(url2.substring(0, queryBegin)) >= 0;
    }

    private static String fixFileProtocolPrefix(String fileUrl) {
        if (!fileUrl.startsWith(PROTOCOL_PREFIX_FILE)) {
            throw new IllegalArgumentException("Illegal file url: " + fileUrl);
        }
        if ("//".equals(fileUrl.substring(6, 8))) {
            return PROTOCOL_PREFIX_FILE + fileUrl.substring(7);
        }
        return fileUrl;
    }

    static {
        DOMAIN_PATTERN = Pattern.compile("(\\.([a-zA-Z0-9-])+)+");
        ACCEPTABLE_PROTOCOL_PREFIXES = new ArrayList();
        ACCEPTABLE_PROTOCOL_PREFIXES.add(PROTOCOL_PREFIX_HTTP);
        ACCEPTABLE_PROTOCOL_PREFIXES.add(PROTOCOL_PREFIX_HTTPS);
        ACCEPTABLE_PROTOCOL_PREFIXES.add(PROTOCOL_PREFIX_FILE);
        ACCEPTABLE_PROTOCOL_PREFIXES.add(PROTOCOL_PREFIX_JAR);
    }
}

