/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import com.appframework.ApplicationFrameActionList;
import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.components.htmleditor.hyperlink.LinkParser;
import com.appframework.listener.ListenerType;
import com.appframework.utils.OS;
import com.appframework.utils.UnfocusedWindowVetoableChangeListener;
import com.novell.gw.engine.EngineLocale;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.skinnable.ComponentPropertyManager;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.frames.open.FrameOpen;
import com.novell.gw.jclient.application.frames.options.compose.country.Language;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.options.ToolBarOptions;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.GeneralPath;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UIUtils {
    private static Logger logger = Logger.getLogger(UIUtils.class);
    public static final double DISABLE_BUTTONS_TRANSPARENCY = 0.7;
    private static Set BACKWARD_KEYS;
    private static Set FORWARD_KEYS;
    private static ComponentOrientation uiOrientation;
    public static final Dimension TOOL_BUTTON_DIMENSION;
    public static final int MAX_CHARACTERS_PER_LINE = 100;
    public static final int DEFAULT_LEFT_INSET_FOR_DISCUSSIONS_THREAD_VIEW = 8;
    private static String[] SYSTEM_FONTS;
    private static final boolean USE_AATEXT;
    public static final int MAC_UNSAFE_BUTTON_SPACING = 24;
    public static final int BUTTON_SPACING = 12;

    public static void centerWindowOnScreen(Window window) {
        UIUtils.centerWindow(window, null);
    }

    public static void centerWindow(Window window, Component parentComponent) {
        UIUtils.centerWindow(window, ControlsUtils.getWindowForComponent(parentComponent));
    }

    public static void centerWindow(Window window, Window owner) {
        window.setLocationRelativeTo(owner);
    }

    public static void setPrefferedWindowSize(int width, int height, Window w) {
        Dimension screenSize;
        if (w != null && (screenSize = Toolkit.getDefaultToolkit().getScreenSize()) != null) {
            w.pack();
            w.setSize(new Dimension(Math.max(width, Math.min(w.getWidth(), (int)((double)screenSize.width * 0.75))), height));
        }
    }

    public static void setFocusTraversalKeys(JComponent c) {
        c.setFocusTraversalKeys(0, FORWARD_KEYS);
        c.setFocusTraversalKeys(1, BACKWARD_KEYS);
    }

    public static void restoreFrameState(Frame theFrame) {
        if (theFrame != null && theFrame.getExtendedState() == 1) {
            theFrame.setExtendedState(0);
            int i = 0;
            while (theFrame.getExtendedState() == 1) {
                try {
                    Thread.sleep(10L);
                    ++i;
                }
                catch (InterruptedException e) {
                    logger.error((Object)e);
                    logger.debug((Object)e, (Throwable)e);
                }
                if (i != 20) continue;
                logger.debug((Object)"Returned by time-out");
                return;
            }
        }
    }

    public static void closeOpenFrameForItem(AbstractItem theGWItem) {
        FrameOpen frameOpen = GWClient.getOpenFrame(theGWItem);
        if (frameOpen != null) {
            ((ApplicationFrameActionList)frameOpen.getController()).closeFrame();
            frameOpen = null;
        }
    }

    public static List<String> breakStringIntoSubstrings(String string, FontMetrics fontMetrics, int width) {
        ArrayList<String> result = new ArrayList<String>();
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            String remaindingString;
            String brokenString = remaindingString = string;
            while (true) {
                int strW;
                if ((strW = fontMetrics.stringWidth(brokenString)) < width || brokenString.length() == 1) {
                    int space;
                    if (remaindingString.length() > brokenString.length() && (space = brokenString.lastIndexOf(32)) > 0) {
                        brokenString = brokenString.substring(0, space + 1);
                    }
                    result.add(brokenString);
                    if (brokenString.length() < remaindingString.length()) {
                        brokenString = remaindingString = remaindingString.substring(brokenString.length());
                        continue;
                    }
                } else if (brokenString.length() > 0) {
                    brokenString = brokenString.substring(0, brokenString.length() - 1);
                    continue;
                }
                break;
            }
        } else {
            ArrayList<String> words = new ArrayList<String>();
            String currentWord = null;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == ' ') {
                    if (currentWord != null) {
                        words.add(currentWord);
                        currentWord = null;
                        continue;
                    }
                    words.add(" ");
                    continue;
                }
                if (currentWord == null) {
                    currentWord = "";
                }
                currentWord = currentWord + c;
                if (i != string.length() - 1) continue;
                words.add(currentWord);
            }
            Collections.reverse(words);
            String phrase = null;
            for (String word : words) {
                if (fontMetrics.stringWidth(word) >= width) {
                    if (phrase != null) {
                        result.add(phrase);
                        phrase = null;
                    }
                    String part = "";
                    while (word.length() > 0) {
                        char c = word.charAt(word.length() - 1);
                        String string2 = word.length() > 0 ? word.substring(0, word.length() - (word.length() > 1 ? 2 : 1)) : (word = "");
                        if (fontMetrics.stringWidth(c + part) < width) {
                            part = c + part;
                            continue;
                        }
                        result.add(part);
                        part = "" + c;
                    }
                    if (part.length() <= 0) continue;
                    result.add(part);
                    continue;
                }
                if (phrase == null) {
                    phrase = word;
                    continue;
                }
                if (fontMetrics.stringWidth(word + ' ' + phrase) <= width) {
                    phrase = word + ' ' + phrase;
                    continue;
                }
                result.add(phrase);
                phrase = word;
            }
            if (phrase != null) {
                result.add(phrase);
            }
        }
        return result;
    }

    public static void setComponentsEnabled(Container theContainer, boolean b) {
        Component[] components = theContainer.getComponents();
        UIUtils.setComponentsEnabled(components, b);
    }

    public static void setComponentsEnabled(Component[] components, boolean b) {
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).setEditable(b);
            } else if (!(component instanceof JLabel)) {
                component.setEnabled(b);
            }
            if (!(component instanceof Container)) continue;
            UIUtils.setComponentsEnabled((Container)components[i], b);
        }
    }

    public static void setText(AbstractButton button, String text) {
        if (button != null && text != null) {
            button.setText(text);
            if (!OS.isMacOS()) {
                button.setMnemonic(StringResources.getMnemonic(text));
                button.setDisplayedMnemonicIndex(StringResources.getDisplayedMnemonicIndex(text));
            }
        }
    }

    public static void setMnemonic(AbstractButton button, int index) {
        String strText;
        if (!OS.isMacOS() && EngineLocale.getCurrent().getLocale().getLanguage().equals("en") && (strText = button.getText()).length() > index + 1) {
            button.setDisplayedMnemonicIndex(index);
            button.setMnemonic(strText.charAt(index));
        }
    }

    public static int getYLocation(Container c) {
        if (c == null) {
            return 0;
        }
        return c.getY() + UIUtils.getYLocation(c.getParent());
    }

    public static void updateLabelHeight(JLabel label) {
        FontMetrics fm = label.getFontMetrics(label.getFont());
        int nDescent = fm.getDescent();
        if (fm != null && nDescent > 0) {
            Dimension d = label.getPreferredSize();
            d.height += nDescent;
            label.setPreferredSize(d);
        }
    }

    public static ComponentOrientation getComponentOrientation() {
        if (uiOrientation == null) {
            Locale locale = EngineCommandManager.getLocale();
            if (locale == null) {
                if (EngineCommandManager.getUserInfo() != null) {
                    Language l = OptionManager.getInstance().getGeneralOptions().getInterfaceLanguage();
                    if (l.getCode() != null) {
                        locale = new Locale(l.getCode().toLowerCase());
                    }
                } else {
                    String lang = System.getProperty("user.lang");
                    if (lang != null && lang.length() > 0) {
                        locale = new Locale(lang);
                    }
                }
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            uiOrientation = ComponentOrientation.getOrientation(locale);
        }
        return uiOrientation;
    }

    public static void resetOrientation() {
        uiOrientation = null;
    }

    public static void setPrefferedWindowSizeLocation(Window w, int height, int x, int y) {
        Dimension screenSize;
        if (w != null && (screenSize = Toolkit.getDefaultToolkit().getScreenSize()) != null) {
            w.setBounds(x, y, Math.min((int)w.getPreferredSize().getWidth(), (int)((double)screenSize.width * 0.75)), height);
        }
    }

    public static AbstractButton createToolButton(AbstractAction theAction) {
        ToolBarButton btn = new ToolBarButton(theAction);
        btn.setPreferredSize(TOOL_BUTTON_DIMENSION);
        return btn;
    }

    public static void initFocusTraversalKeys(Component c) {
        HashSet<KeyStroke> keys = new HashSet<KeyStroke>();
        keys.add(KeyStroke.getKeyStroke(9, 0));
        c.setFocusTraversalKeys(0, keys);
        keys.clear();
        keys.add(KeyStroke.getKeyStroke(9, 64));
        c.setFocusTraversalKeys(1, keys);
    }

    public static void initTabbedPaneMaps(JTabbedPane pane) {
        InputMap oldMap = SwingUtilities.getUIInputMap(pane, 1);
        KeyStroke[] keyStrokes = oldMap.allKeys();
        for (int i = 0; i < keyStrokes.length; ++i) {
            KeyStroke keyStroke = keyStrokes[i];
            int keyCode = keyStroke.getKeyCode();
            if (keyCode != 224 && keyCode != 38) continue;
            oldMap.remove(keyStroke);
        }
        InputMap newMap = new InputMap();
        keyStrokes = oldMap.allKeys();
        for (int i = 0; i < keyStrokes.length; ++i) {
            KeyStroke keyStroke = keyStrokes[i];
            Object action = oldMap.get(keyStroke);
            newMap.put(keyStroke, action);
        }
        SwingUtilities.replaceUIInputMap(pane, 1, newMap);
    }

    public static void initTableFocusTraversalKeys(JTable theTable) {
        HashSet<KeyStroke> set = new HashSet<KeyStroke>();
        set.add(KeyStroke.getKeyStroke(9, 0));
        theTable.setFocusTraversalKeys(0, set);
        set = new HashSet();
        set.add(KeyStroke.getKeyStroke(9, 1));
        theTable.setFocusTraversalKeys(1, set);
    }

    public static void scrollComponent(Point cursorPos, JComponent component, int step) {
        if (cursorPos.y + component.getY() + step > component.getVisibleRect().height) {
            cursorPos.y += step;
        }
        if (cursorPos.y + component.getY() < step) {
            cursorPos.y -= step;
        }
        if (cursorPos.x + component.getX() + step > component.getVisibleRect().width) {
            cursorPos.x += step;
        }
        if (cursorPos.x + component.getX() < step) {
            cursorPos.x -= step;
        }
        component.scrollRectToVisible(new Rectangle(cursorPos));
    }

    public static String[] getSystemFonts() {
        if (SYSTEM_FONTS == null) {
            SYSTEM_FONTS = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(EngineCommandManager.getLocale());
        }
        return (String[])SYSTEM_FONTS.clone();
    }

    public static String cutStringToWidth(String theString, Graphics theGrahpics, int theWidth) {
        return UIUtils.cutStringToWidth(theString, theGrahpics.getFontMetrics(), theWidth);
    }

    public static String cutStringToWidth(String theString, FontMetrics theFontMetrics, int theWidth) {
        if (theWidth <= 0) {
            return "";
        }
        int strWidth = SwingUtilities.computeStringWidth(theFontMetrics, theString);
        if (strWidth <= theWidth) {
            return theString;
        }
        double proportion = (double)theWidth / (double)strWidth;
        int stringLength = theString.length();
        int posToCut = (int)((double)stringLength * proportion) - 4;
        if (posToCut < 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(theString.substring(0, posToCut)).append("...");
        strWidth = SwingUtilities.computeStringWidth(theFontMetrics, sb.toString());
        while (strWidth > theWidth) {
            sb.deleteCharAt(sb.length() - 4);
            strWidth = SwingUtilities.computeStringWidth(theFontMetrics, sb.toString());
        }
        return sb.toString();
    }

    public static final int computeMaxWidth(JComponent component, String[] strings) {
        int[] widths = new int[strings.length];
        for (int i = 0; i < widths.length; ++i) {
            widths[i] = UIUtils.getStrWidthForComponent(component, strings[i]);
        }
        Arrays.sort(widths);
        return widths[widths.length - 1];
    }

    public static int getStrWidthForComponent(JComponent component, String str) {
        if (str == null) {
            return 0;
        }
        return SwingUtilities.computeStringWidth(component.getFontMetrics(component.getFont()), str);
    }

    public static void setButtonPreferedSize(AbstractButton button, String[] strings) {
        int maxWidth = UIUtils.computeMaxWidth(button, strings);
        int preferedWidth = button.getPreferredSize().width - UIUtils.getStrWidthForComponent(button, button.getText()) + maxWidth;
        button.setPreferredSize(new Dimension(preferedWidth, button.getPreferredSize().height));
    }

    public static boolean isJDKMoreThan5() {
        return System.getProperty("java.version").compareTo("1.5.0") >= 0;
    }

    public static String wrapIntoHTML(String theString) {
        StringBuffer result = new StringBuffer();
        result.append("<html><head></head>");
        result.append("<body>");
        result.append(LinkParser.createLinkedText(theString));
        result.append("</body></html>");
        return result.toString();
    }

    public static String wrapIntoRTF(String theString) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            JTextPane textPane = new JTextPane();
            textPane.setText(theString);
            Document document = textPane.getDocument();
            int length = document.getLength();
            new RTFEditorKit().write(baos, document, 0, length);
            baos.close();
        }
        catch (Exception e) {
            logger.debug((Object)e);
            logger.error((Object)e, (Throwable)e);
        }
        return baos.toString();
    }

    public static void changeToolbarButtonStyle(AbstractButton button, String text, ToolBarOptions.Style style, boolean showTextLabel) {
        switch (style) {
            case PICTURE: {
                button.setText(null);
                break;
            }
            case PICTURE_AND_TEXT: {
                button.setVerticalAlignment(1);
                button.setHorizontalTextPosition(0);
                button.setVerticalTextPosition(3);
                button.setText(text);
                break;
            }
            case PICTURE_AND_SELECTED_TEXT: {
                button.setVerticalTextPosition(0);
                button.setHorizontalTextPosition(11);
                if (!showTextLabel) {
                    text = null;
                }
                button.setText(text);
            }
        }
        button.updateUI();
    }

    public static Graphics enableAntialiasing(Graphics g) {
        if (USE_AATEXT && g instanceof Graphics2D && !OS.isMacOS()) {
            Graphics2D g2D = (Graphics2D)g;
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        }
        return g;
    }

    public static int getColumnWidth(int theCharactersCount, Component theComponent) {
        int result = 0;
        if (theCharactersCount > 0 && theComponent != null) {
            FontMetrics metrics = theComponent.getFontMetrics(theComponent.getFont());
            int columnWidth = metrics.charWidth('m');
            result = theCharactersCount * columnWidth;
        }
        return result;
    }

    public static void paintGradient(Graphics g, JComponent component) {
        UIUtils.paintGradient(g, component, "both", true, false);
    }

    public static void paintGradient(Graphics g, JComponent comp, String roundState, boolean isBorderPainted, boolean isPressed) {
        boolean needRightGradient;
        boolean needLeftGradient;
        Color borderColor;
        Color lowSegmentColorFrom;
        Color lowSegmentColorTo;
        Color highSegmentColorTo;
        Color highSegmentColorFrom;
        Graphics2D g2D = (Graphics2D)g;
        ComponentPropertyManager componentPropertyManager = ComponentPropertyManager.getInstance();
        if (!isPressed) {
            highSegmentColorFrom = (Color)componentPropertyManager.getSkinPropertyValue(SkinProperty.HILITE_START_COLOR);
            highSegmentColorTo = (Color)componentPropertyManager.getSkinPropertyValue(SkinProperty.HILITE_END_COLOR);
            lowSegmentColorTo = (Color)componentPropertyManager.getSkinPropertyValue(SkinProperty.HILITE_START_COLOR);
            lowSegmentColorFrom = (Color)componentPropertyManager.getSkinPropertyValue(SkinProperty.HILITE_END_COLOR);
            borderColor = (Color)componentPropertyManager.getSkinPropertyValue(SkinProperty.HILITE_BORDER_COLOR);
        } else {
            highSegmentColorTo = highSegmentColorFrom = (Color)componentPropertyManager.getSkinPropertyValue(SkinProperty.SELECTED_TOOLBAR_BTN_BACKROUND_COLOR);
            lowSegmentColorTo = highSegmentColorFrom;
            lowSegmentColorFrom = highSegmentColorFrom;
            borderColor = (Color)componentPropertyManager.getSkinPropertyValue(SkinProperty.HILITE_BORDER_COLOR);
        }
        int w = comp.getSize().width;
        int h = comp.getSize().height;
        g2D.setBackground(UIUtils.getNonOpaqueParentBackground(comp));
        g2D.clearRect(0, 0, w, h);
        GeneralPath border = new GeneralPath();
        boolean isLeft = UIUtils.getComponentOrientation().isLeftToRight();
        boolean bl = needLeftGradient = roundState.equals("both") || roundState.equals("left") && isLeft || roundState.equals("right") && !isLeft;
        if (needLeftGradient) {
            border.moveTo(5.0f, 0.0f);
            border.lineTo(4.0f, 1.0f);
            border.lineTo(3.0f, 1.0f);
            border.lineTo(1.0f, 3.0f);
            border.lineTo(1.0f, 4.0f);
            border.lineTo(0.0f, 5.0f);
        } else {
            border.moveTo(0.0f, 0.0f);
        }
        if (needLeftGradient) {
            border.lineTo(0.0f, h - 6);
            border.lineTo(1.0f, h - 5);
            border.lineTo(1.0f, h - 4);
            border.lineTo(3.0f, h - 2);
            border.lineTo(4.0f, h - 2);
            border.lineTo(5.0f, h - 1);
        } else {
            border.lineTo(0.0f, h - 1);
        }
        boolean bl2 = needRightGradient = roundState.equals("both") || roundState.equals("right") && isLeft || roundState.equals("left") && !isLeft;
        if (needRightGradient) {
            border.lineTo(w - 6, h - 1);
            border.lineTo(w - 5, h - 2);
            border.lineTo(w - 4, h - 2);
            border.lineTo(w - 2, h - 4);
            border.lineTo(w - 2, h - 5);
            border.lineTo(w - 1, h - 6);
        } else {
            border.lineTo(w - 1, h - 1);
        }
        if (needRightGradient) {
            border.lineTo(w - 1, 5.0f);
            border.lineTo(w - 2, 4.0f);
            border.lineTo(w - 2, 3.0f);
            border.lineTo(w - 4, 1.0f);
            border.lineTo(w - 5, 1.0f);
            border.lineTo(w - 6, 0.0f);
        } else {
            border.lineTo(w - 1, 0.0f);
        }
        if (needLeftGradient) {
            border.lineTo(5.0f, 0.0f);
        } else {
            border.lineTo(0.0f, 0.0f);
        }
        GradientPaint paintHigherSegment = new GradientPaint(0.0f, 0.0f, highSegmentColorFrom, 0.0f, (int)((double)comp.getHeight() * 0.3), highSegmentColorTo);
        g2D.setPaint(paintHigherSegment);
        g2D.fill(border);
        GradientPaint paintLowerSegment = new GradientPaint(0.0f, (int)((double)comp.getHeight() * 0.3), lowSegmentColorFrom, 0.0f, comp.getHeight(), lowSegmentColorTo);
        g2D.setPaint(paintLowerSegment);
        g2D.fill(border);
        if (borderColor != null && isBorderPainted) {
            g2D.setColor(borderColor);
            g2D.draw(border);
        }
    }

    public static int getLeftInsetDiscussionThread(IItemList itemList, int row) {
        return 8 * (itemList.getThreadDepthAt(row) - 1);
    }

    public static int getLeftInsetDiscussionThread(IItemList itemList, IItem item) {
        return 8 * (itemList.getThreadDepth(item) - 1);
    }

    public static Color getBrighterColor(Color color, float scale) {
        if (scale > 1.0f || scale < 0.0f) {
            throw new IllegalArgumentException();
        }
        float[] HSB = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float h = HSB[0];
        float s = HSB[1];
        float b = HSB[2];
        if ((double)b > 0.7) {
            s *= scale;
        } else {
            b += (1.0f - b) * (1.0f - scale);
        }
        return new Color(Color.HSBtoRGB(h, s, b));
    }

    public static Color getColorMidleBetween(Color c1, Color c2) {
        int r1 = c1.getRed();
        int r2 = c2.getRed();
        int g1 = c1.getGreen();
        int g2 = c2.getGreen();
        int b1 = c1.getBlue();
        int b2 = c2.getBlue();
        int r = (int)((double)(r1 + r2) * 0.5);
        int g = (int)((double)(g1 + g2) * 0.5);
        int b = (int)((double)(b1 + b2) * 0.5);
        return new Color(r, g, b);
    }

    public static String getShortCutText(String fullText, int maximumLength) {
        if (maximumLength <= 0) {
            throw new IllegalArgumentException("illegal maximumLength: " + maximumLength + " (must be a positive number)");
        }
        if (fullText == null) {
            throw new IllegalArgumentException("fullText is null");
        }
        String shortCutText = "";
        if (fullText.length() > 0) {
            if (fullText.length() <= maximumLength) {
                shortCutText = fullText;
            } else {
                String text = fullText.substring(0, maximumLength);
                for (int i = text.length() - 1; i > 0; --i) {
                    if (!Character.isWhitespace(text.charAt(i))) continue;
                    shortCutText = text.substring(0, i);
                    break;
                }
            }
        }
        return shortCutText;
    }

    public static void prepareDialogToShowUnfocused(GWDialog gwDialog) {
        Window focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (focusedWindow == null) {
            gwDialog.setFocusableWindowState(false);
        } else {
            ControlsUtils.getListenerManager(gwDialog.getController()).addListener(KeyboardFocusManager.getCurrentKeyboardFocusManager(), new UnfocusedWindowVetoableChangeListener(gwDialog), ListenerType.VETOABLE_CHANGE_LISTENER);
        }
    }

    private static Color getNonOpaqueParentBackground(Component child) {
        assert (child != null);
        Color background = null;
        while (child.getParent() != null) {
            Container parent = child.getParent();
            if (parent.isOpaque()) {
                background = parent.getBackground();
                break;
            }
            child = parent;
        }
        return background;
    }

    static {
        TOOL_BUTTON_DIMENSION = new Dimension(21, 21);
        SYSTEM_FONTS = null;
        USE_AATEXT = Boolean.valueOf(System.getProperty("swing.aatext"));
        FORWARD_KEYS = new HashSet();
        FORWARD_KEYS.add(KeyStroke.getKeyStroke(39, 0));
        FORWARD_KEYS.add(KeyStroke.getKeyStroke(9, 0));
        FORWARD_KEYS = Collections.unmodifiableSet(FORWARD_KEYS);
        BACKWARD_KEYS = new HashSet();
        BACKWARD_KEYS.add(KeyStroke.getKeyStroke(37, 0));
        BACKWARD_KEYS.add(KeyStroke.getKeyStroke(9, 1));
        BACKWARD_KEYS = Collections.unmodifiableSet(BACKWARD_KEYS);
    }
}

