/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.api.enums;

import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AppointmentAcceptLevel {
    BUSY(StringResources.BUSY, new Color(200, 200, 200)){

        public int getValue() {
            return 210;
        }
    }
    ,
    FREE(StringResources.FREE, Color.WHITE){

        public int getValue() {
            return 160;
        }
    }
    ,
    OUT_OF_OFFICE(StringResources.OUT_OF_OFFICE, new Color(140, 140, 140)){

        public int getValue() {
            return 251;
        }
    }
    ,
    TENTATIVE(StringResources.TENTATIVE, new Color(230, 230, 230)){

        public int getValue() {
            return 190;
        }
    }
    ,
    USE_SEND_VALUE(StringResources.SET_DURING_SEND, null){

        public int getValue() {
            return 0;
        }
    }
    ,
    NONE(StringResources.NONE, null){

        public int getValue() {
            return -1;
        }
    };

    public static final TexturePaint tentativeTexturePaint;
    private Color color;
    private String name;

    private AppointmentAcceptLevel(String name, Color color) {
        this.color = color;
        this.name = name;
    }

    public Color getColor() {
        return this.color;
    }

    public abstract int getValue();

    public static AppointmentAcceptLevel getEnum(int value) {
        if (value == 210) {
            return BUSY;
        }
        if (value == 251) {
            return OUT_OF_OFFICE;
        }
        if (value == 190) {
            return TENTATIVE;
        }
        return FREE;
    }

    public static AppointmentAcceptLevel getEnumForOptions(int value) {
        if (value == 210) {
            return BUSY;
        }
        if (value == 160) {
            return FREE;
        }
        if (value == 251) {
            return OUT_OF_OFFICE;
        }
        if (value == 190) {
            return TENTATIVE;
        }
        if (value == 0) {
            return USE_SEND_VALUE;
        }
        if (value == -1) {
            return NONE;
        }
        throw new IllegalArgumentException("Illegal value: " + value);
    }

    public String toString() {
        return this.name;
    }

    static {
        BufferedImage bi = new BufferedImage(10, 10, 1);
        Graphics2D big = bi.createGraphics();
        big.setColor(FREE.getColor());
        big.fillRect(0, 0, 10, 10);
        big.setColor(BUSY.getColor());
        big.drawLine(0, 8, 8, 0);
        big.drawLine(0, 9, 9, 0);
        big.drawLine(0, 10, 10, 0);
        big.drawLine(1, 10, 10, 1);
        big.drawLine(0, 1, 1, 0);
        big.drawLine(10, 9, 9, 10);
        big.drawLine(10, 8, 8, 10);
        Rectangle r = new Rectangle(0, 0, 10, 10);
        tentativeTexturePaint = new TexturePaint(bi, r);
    }
}

