/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.api.impl;

import com.novell.gw.ab.AddressBookItemListFilter;
import com.novell.gw.ab.PersonalAddressBook;
import com.novell.gw.engine.DisplaySettings;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.jclient.api.APIInternal;
import com.novell.gw.jclient.api.enums.CalendarViewType;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.impl.ColumnAndSortInfoImpl;
import com.novell.gw.jclient.api.impl.folder.APIFolderWrapperManager;
import com.novell.gw.jclient.api.interfaces.IColumnAndSortInfo;
import com.novell.gw.jclient.api.interfaces.IColumnFieldInfo;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IFolderDisplaySettings;
import com.novell.gw.jclient.api.interfaces.IPanelDisplaySettings;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import org.apache.log4j.Logger;

public class DisplaySettingsImpl
implements IFolderDisplaySettings,
IPanelDisplaySettings {
    private static final Logger logger = Logger.getLogger(DisplaySettingsImpl.class);
    private DisplaySettings displaySettings;
    int id;
    private Boolean contacts;

    public void setContacts(boolean contacts) {
        if (this.contacts == null) {
            this.contacts = contacts;
        }
    }

    public boolean isContacts() {
        try {
            String page = this.getPanelWebPage();
            if (this.contacts == null && (page == null || page.equals(""))) {
                throw new IllegalStateException("BUG 439200");
            }
        }
        catch (IllegalStateException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return this.contacts == null ? false : this.contacts;
    }

    protected DisplaySettingsImpl(DisplaySettings displaySettings) {
        if (displaySettings == null) {
            throw new IllegalArgumentException("displaySettings is null");
        }
        this.displaySettings = displaySettings;
    }

    @APIInternal
    public DisplaySettings getNativeDisplaySettings() {
        return this.displaySettings;
    }

    public boolean createPanelDisplaySettingsRec(IFolderDisplaySettings displaySettings) {
        return this.displaySettings.createPanelDisplaySettingsRec(displaySettings.getNativeDisplaySettings());
    }

    public void createPanelTemplateDisplaySettings() {
        this.displaySettings.createPanelTemplateDisplaySettings();
    }

    public boolean createTemplateDisplaySettingsRec() {
        return this.displaySettings.createTemplateDisplaySettingsRec();
    }

    public boolean deleteAllPanelSettings() {
        return this.displaySettings.deleteAllPanelSettings();
    }

    public boolean deletePanelSettings(IPanelDisplaySettings panelSettings) {
        return this.displaySettings.deletePanelSettings(panelSettings.getNativeDisplaySettings());
    }

    public boolean deleteSettings() {
        return this.displaySettings.deleteSettings();
    }

    public void dispose() {
        this.displaySettings.dispose();
    }

    public int getBoxType() {
        return this.displaySettings.getBoxType();
    }

    public CalendarViewType getCalViewType() {
        return CalendarViewType.getEnum(this.displaySettings.getCalViewType());
    }

    public int getCalWeekColumnCount() {
        return this.displaySettings.getCalWeekColumnCount();
    }

    public IColumnAndSortInfo getColumnAndSortInfo() {
        String webPage = this.getPanelWebPage();
        if (this.contacts == null && webPage != null && !webPage.equals("")) {
            return new ColumnAndSortInfoImpl(this.displaySettings.getColumnAndSortInfo(true));
        }
        return new ColumnAndSortInfoImpl(this.displaySettings.getColumnAndSortInfo(this.isContacts()));
    }

    public int getContactType() {
        return this.displaySettings.getContactType();
    }

    public String getDescription() {
        return this.displaySettings.getDescription();
    }

    public int getFilterDaysBackward() {
        return this.displaySettings.getFilterDaysBackward();
    }

    public int getFilterDaysForward() {
        return this.displaySettings.getFilterDaysForward();
    }

    public boolean getFolderTreeApplyPerFolder() {
        return this.displaySettings.getFolderTreeApplyPerFolder();
    }

    public boolean getFolderTreeSimple() {
        return this.displaySettings.getFolderTreeSimple();
    }

    public boolean getHideCompleted() {
        return this.displaySettings.getHideCompleted();
    }

    public boolean getHideCompletedAfterADay() {
        return this.displaySettings.getHideCompletedAfterADay();
    }

    public void setHideCompletedAfterADay(boolean value) {
        this.displaySettings.setHideCompletedAfterADay(value);
    }

    public int getId() {
        return this.displaySettings.getId();
    }

    public int getItemType() {
        return this.displaySettings.getItemType();
    }

    public boolean getMsgPreview() {
        return this.displaySettings.getMsgPreview();
    }

    public String getName() {
        return this.displaySettings.getName();
    }

    public AddressBookItemListFilter getPanelABFilter() {
        return this.displaySettings.getPanelABFilter();
    }

    public IFolder getPanelAddressBookFolder() {
        return APIFolderWrapperManager.getFolder(this.displaySettings.getPanelAddressBookFolder());
    }

    public String getPanelCalSplitbar() {
        return this.displaySettings.getPanelCalSplitbar();
    }

    public int getPanelCalView() {
        return this.displaySettings.getPanelCalView();
    }

    public int getPanelColumnCount() {
        return this.displaySettings.getPanelColumnCount();
    }

    public int getPanelColumnNum() {
        return this.displaySettings.getPanelColumnNum();
    }

    public int getPanelCount() {
        return this.displaySettings.getPanelCount();
    }

    public ItemListFilter getPanelFilter() {
        return this.displaySettings.getPanelFilter();
    }

    public IFolder getPanelFolder(IDataStore dataStore) {
        IFolder folder = APIFolderWrapperManager.getFolder(this.displaySettings.getPanelFolder(dataStore.getNativeDataStore()));
        if (folder != null) {
            boolean contactsFolder = folder.isContactsFolder();
            if (this.contacts == null) {
                this.setContacts(contactsFolder);
            } else if (contactsFolder != this.contacts) {
                throw new IllegalStateException();
            }
        }
        return folder;
    }

    public int getPanelHeight() {
        return this.displaySettings.getPanelHeight();
    }

    public int getPanelHScrollPos() {
        return this.displaySettings.getPanelHScrollPos();
    }

    public int getPanelIndex() {
        return this.displaySettings.getPanelIndex();
    }

    public String getPanelName() {
        return this.displaySettings.getPanelName();
    }

    public int getPanelOrigHeight() {
        return this.displaySettings.getPanelOrigHeight();
    }

    public int getPanelRefreshInterval() {
        return this.displaySettings.getPanelRefreshInterval();
    }

    public IPanelDisplaySettings getPanelSettings(int index) {
        return APIWrapperManager.getPanelDisplaySettings(this.displaySettings.getPanelSettings(index));
    }

    public int getPanelVScrollPos() {
        return this.displaySettings.getPanelVScrollPos();
    }

    public String getPanelWebPage() {
        return this.displaySettings.getPanelWebPage();
    }

    public int getPanelWidth() {
        return this.displaySettings.getPanelWidth();
    }

    public int getViewMode() {
        return this.displaySettings.getViewMode();
    }

    public void initHomeFolder() {
        this.displaySettings.initHomeFolder();
    }

    public boolean isFolderTreeVisible() {
        return this.displaySettings.isFolderTreeVisible();
    }

    public boolean isHideNonChecklist() {
        return this.displaySettings.isHideNonChecklist();
    }

    public boolean isMainMenuVisible() {
        return this.displaySettings.isMainMenuVisible();
    }

    public boolean isPanelCollapsed() {
        return this.displaySettings.isPanelCollapsed();
    }

    public boolean isPanelSettings() {
        return this.displaySettings.isPanelSettings();
    }

    public boolean isQuickViewerApplyPerFolder() {
        return this.displaySettings.isQuickViewerApplyPerFolder();
    }

    public boolean isQuickViewerVisible() {
        return this.displaySettings.isQuickViewerVisible();
    }

    public boolean isSummaryView() {
        return this.displaySettings.isSummaryView();
    }

    public void reorderPanels(int nColumnId, int nIndex) {
        this.displaySettings.reorderPanels(nColumnId, nIndex);
    }

    public void resetPanelSettings() {
        this.displaySettings.resetPanelSettings();
    }

    public boolean setBoxType(int boxTypeMask) {
        return this.displaySettings.setBoxType(boxTypeMask);
    }

    public void setCalViewType(CalendarViewType value) {
        this.displaySettings.setCalViewType(value == null ? 0 : value.getValue());
    }

    public void setCalWeekColumnCount(int value) {
        this.displaySettings.setCalWeekColumnCount(value);
    }

    public boolean setColumnAndSortInfo(IColumnFieldInfo[] visibleColumns, IColumnFieldInfo sortField) {
        return this.displaySettings.setColumnAndSortInfo(APIWrapperManager.getNativeColumnFieldInfoArray(visibleColumns), sortField == null ? null : sortField.getNativeColumnFieldInfo());
    }

    public boolean setContactType(int contactTypeMask) {
        return this.displaySettings.setContactType(contactTypeMask);
    }

    public boolean setDescription(String value) {
        return this.displaySettings.setDescription(value);
    }

    public void setFilterDaysBackward(int value) {
        this.displaySettings.setFilterDaysBackward(value);
    }

    public void setFilterDaysForward(int value) {
        this.displaySettings.setFilterDaysForward(value);
    }

    public void setFolderTreeApplyPerFolder(boolean value) {
        this.displaySettings.setFolderTreeApplyPerFolder(value);
    }

    public void setFolderTreeSimple(boolean value) {
        this.displaySettings.setFolderTreeSimple(value);
    }

    public void setFolderTreeVisible(boolean value) {
        this.displaySettings.setFolderTreeVisible(value);
    }

    public void setHideCompleted(boolean value) {
        this.displaySettings.setHideCompleted(value);
    }

    public void setHideNonChecklist(boolean value) {
        this.displaySettings.setHideNonChecklist(value);
    }

    public boolean setItemType(int itemTypeMask) {
        return this.displaySettings.setItemType(itemTypeMask);
    }

    public boolean setMainMenuVisible(boolean value) {
        return this.displaySettings.setMainMenuVisible(value);
    }

    public void setMsgPreview(boolean value) {
        this.displaySettings.setMsgPreview(value);
    }

    public boolean setName(String value) {
        return this.displaySettings.setName(value);
    }

    public void setPanelAddressBook(PersonalAddressBook book) {
        this.displaySettings.setPanelAddressBook(book);
    }

    public void setPanelCalView(int value) {
        this.displaySettings.setPanelCalView(value);
    }

    public boolean setPanelColumnCount(int value) {
        return this.displaySettings.setPanelColumnCount(value);
    }

    public void setPanelColumnNum(int value) {
        this.displaySettings.setPanelColumnNum(value);
    }

    public boolean setPanelFilter(ItemListFilter panelFilter) {
        return this.displaySettings.setPanelFilter(panelFilter);
    }

    public boolean setPanelFolder(IFolder folder) {
        boolean contactsFolder = folder.isContactsFolder();
        if (this.contacts == null) {
            this.setContacts(contactsFolder);
        } else if (contactsFolder != this.contacts) {
            throw new IllegalArgumentException();
        }
        return this.displaySettings.setPanelFolder(folder.getNativeFolder());
    }

    public void setPanelHeight(int value) {
        this.displaySettings.setPanelHeight(value);
    }

    public void setPanelHScrollPos(int value) {
        this.displaySettings.setPanelHScrollPos(value);
    }

    public void setPanelIndex(int value) {
        this.displaySettings.setPanelIndex(value);
    }

    public void setPanelIsCollapsed(boolean value) {
        this.displaySettings.setPanelIsCollapsed(value);
    }

    public boolean setPanelName(String value) {
        return this.displaySettings.setPanelName(value);
    }

    public void setPanelOrigHeight(int value) {
        this.displaySettings.setPanelOrigHeight(value);
    }

    public void setPanelRefreshInterval(int value) {
        this.displaySettings.setPanelRefreshInterval(value);
    }

    public void setPanelVScrollPos(int value) {
        this.displaySettings.setPanelVScrollPos(value);
    }

    public boolean setPanelWebPage(String value) {
        return this.displaySettings.setPanelWebPage(value);
    }

    public void setPanelWidth(int value) {
        this.displaySettings.setPanelWidth(value);
    }

    public void setQuickViewerApplyPerFolder(boolean value) {
        this.displaySettings.setQuickViewerApplyPerFolder(value);
    }

    public void setQuickViewerVisible(boolean value) {
        this.displaySettings.setQuickViewerVisible(value);
    }

    public void setShowCalSmallMonths(boolean value) {
        this.displaySettings.setShowCalSmallMonths(value);
    }

    public void setShowCalToolbar(boolean value) {
        this.displaySettings.setShowCalToolbar(value);
    }

    public void setShowGroupHeaders(boolean value) {
        this.displaySettings.setShowGroupHeaders(value);
    }

    public void setSummaryView(boolean value) {
        this.displaySettings.setSummaryView(value);
    }

    public boolean setViewMode(int viewMode) {
        return this.displaySettings.setViewMode(viewMode);
    }

    public boolean showCalSmallMonths() {
        return this.displaySettings.showCalSmallMonths();
    }

    public boolean showCalToolbar() {
        return this.displaySettings.showCalToolbar();
    }

    public boolean showGroupHeaders() {
        return this.displaySettings.showGroupHeaders();
    }

    public String toString() {
        return this.displaySettings.toString();
    }

    public boolean writeDisplaySettings() {
        return this.displaySettings.writeDisplaySettings();
    }

    public boolean writeDisplaySettings(IFolder folder) {
        return this.displaySettings.writeDisplaySettings(folder.getNativeFolder());
    }

    public IViewDisplaySettings asViewDisplaySettings() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisplaySettingsImpl that = (DisplaySettingsImpl)o;
        return this.getId() == that.getId();
    }

    public int hashCode() {
        return this.getId();
    }
}

