/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.api.impl.folder;

import com.novell.gw.folder.CalendarFolder;
import com.novell.gw.folder.ContactsFolder;
import com.novell.gw.folder.Folder;
import com.novell.gw.folder.JunkMailFolder;
import com.novell.gw.folder.NntpFolder;
import com.novell.gw.folder.SharedFolderReference;
import com.novell.gw.folder.TrashFolder;
import com.novell.gw.jclient.api.impl.folder.CalendarFolderImpl;
import com.novell.gw.jclient.api.impl.folder.ContactsFolderImpl;
import com.novell.gw.jclient.api.impl.folder.FolderImpl;
import com.novell.gw.jclient.api.impl.folder.JunkMailFolderImpl;
import com.novell.gw.jclient.api.impl.folder.NntpFolderImpl;
import com.novell.gw.jclient.api.impl.folder.SharedFolderReferenceImpl;
import com.novell.gw.jclient.api.impl.folder.TrashFolderImpl;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import org.apache.log4j.Logger;

public class APIFolderWrapperManager {
    private static Logger logger = Logger.getLogger(APIFolderWrapperManager.class);

    public static IFolder getFolder(Folder folder) {
        if (folder == null) {
            return null;
        }
        if (folder instanceof CalendarFolder) {
            return new CalendarFolderImpl((CalendarFolder)folder);
        }
        if (folder instanceof ContactsFolder) {
            return new ContactsFolderImpl((ContactsFolder)folder);
        }
        if (folder instanceof JunkMailFolder) {
            return new JunkMailFolderImpl((JunkMailFolder)folder);
        }
        if (folder instanceof NntpFolder) {
            return new NntpFolderImpl((NntpFolder)folder);
        }
        if (folder instanceof SharedFolderReference) {
            return new SharedFolderReferenceImpl((SharedFolderReference)folder);
        }
        if (folder instanceof TrashFolder) {
            return new TrashFolderImpl((TrashFolder)folder);
        }
        return new FolderImpl(folder);
    }

    public static IFolder[] getFolderArray(Folder[] folderArray) {
        if (folderArray == null) {
            return null;
        }
        IFolder[] folderWrapperArray = new IFolder[folderArray.length];
        for (int i = 0; i < folderArray.length; ++i) {
            folderWrapperArray[i] = APIFolderWrapperManager.getFolder(folderArray[i]);
        }
        return folderWrapperArray;
    }

    public static Folder[] getNativeFolderArray(IFolder[] folderArray) {
        if (folderArray == null) {
            return null;
        }
        Folder[] nativeFolderArray = new Folder[folderArray.length];
        for (int i = 0; i < folderArray.length; ++i) {
            if (folderArray[i] == null) {
                nativeFolderArray[i] = null;
                logger.warn((Object)"folder wrapper array element is null");
                continue;
            }
            nativeFolderArray[i] = folderArray[i].getNativeFolder();
        }
        return nativeFolderArray;
    }
}

