/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.api.impl.message;

import com.novell.gw.ab.DistributionList;
import com.novell.gw.ab.UnresolvedAddressException;
import com.novell.gw.account.Account;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.Item;
import com.novell.gw.engine.SendCallback;
import com.novell.gw.engine.TransferAttachments;
import com.novell.gw.engine.TransferItems;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.api.enums.MessageSentItemStatus;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.impl.ItemImpl;
import com.novell.gw.jclient.api.impl.folder.APIFolderWrapperManager;
import com.novell.gw.jclient.api.impl.message.APIMessageWrapperManager;
import com.novell.gw.jclient.api.interfaces.ICategory;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IAttachment;
import com.novell.gw.jclient.api.interfaces.message.IDelayDeliverInfo;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.api.interfaces.message.ISuggestedBody;
import com.novell.gw.message.Attachment;
import com.novell.gw.message.Message;
import java.io.InputStreamReader;
import java.util.Date;

public abstract class MessageImpl
extends ItemImpl
implements IMessage {
    protected Message message;

    protected MessageImpl(Message message) {
        super((Item)message);
        this.message = (Message)this.item;
    }

    public Message getNativeMessage() {
        return this.message;
    }

    public String getValue(int fieldId, IFolder selectedFolder) {
        return this.message.getValue(fieldId, selectedFolder.getNativeFolder());
    }

    public String getSummaryValue(int areaNum, IFolder selectedFolder, IViewDisplaySettings displaySettings) {
        return this.message.getSummaryValue(areaNum, selectedFolder.getNativeFolder(), displaySettings == null ? null : displaySettings.getNativeDisplaySettings());
    }

    public int getUID() {
        return this.message.getUid();
    }

    public String getGID() {
        return this.message.getGID();
    }

    public boolean isDraft() {
        return this.message.isDraft();
    }

    public void autoSave() {
        this.message.autoSave();
    }

    public void deleteAutoSaveFile() {
        this.message.deleteAutoSaveFile();
    }

    public boolean canAccept() {
        return this.message.canAccept();
    }

    public boolean canArchive() {
        return this.message.canArchive();
    }

    public boolean canChangeTo(ItemType destItemType) {
        return this.message.canChangeTo(destItemType.getValue());
    }

    public boolean canComplete() {
        return this.message.canComplete();
    }

    public boolean canDelete() {
        return this.message.canDelete();
    }

    public boolean canDeleteAndEmpty() {
        return this.message.canDeleteAndEmpty();
    }

    public boolean canDelegate() {
        return this.message.canDelegate();
    }

    public boolean canDialSender() {
        return this.message.canDialSender();
    }

    public boolean canDoInfo() {
        return this.message.canDoInfo();
    }

    public boolean canForward() {
        return this.message.canForward();
    }

    public boolean canMarkPrivate() {
        return this.message.canMarkPrivate();
    }

    public boolean canMarkRead() {
        return this.message.canMarkRead();
    }

    public boolean canMarkReadLater() {
        return this.message.canMarkReadLater();
    }

    public boolean canModify() {
        return this.message.canModify();
    }

    public boolean canPrint() {
        return this.message.canPrint();
    }

    public boolean canEmpty() {
        return this.message.canEmpty();
    }

    public boolean canOpen() {
        return this.message.canOpen();
    }

    public boolean canDecline() {
        return this.message.canDecline();
    }

    public boolean canReply() {
        return this.message.canReply();
    }

    public boolean canReplyToOriginalTopic() {
        return this.message.canReplyToOriginalTopic();
    }

    public boolean canResend() {
        return this.message.canResend();
    }

    public boolean canSave() {
        return this.message.canSave();
    }

    public boolean canSetAllDayEvent() {
        return this.message.canSetAllDayEvent();
    }

    public boolean canShowInChecklist() {
        return this.message.canShowInChecklist();
    }

    public boolean canUndelete() {
        return this.message.canUndelete();
    }

    public boolean canView() {
        return this.message.canView();
    }

    public boolean showHTMLOnlyWarning() {
        return this.message.showHTMLOnlyWarning();
    }

    public InputStreamReader getBodyRtfReader() {
        return this.message.getBodyRtfReader();
    }

    public int indexOf(IAttachment attachment) {
        return this.message.indexOf(attachment.getNativeAttachment());
    }

    public boolean isHTMLMessage() {
        return this.message.isHTMLMessage();
    }

    public boolean saveToFile(String saveFileName, int saveFormatType) {
        return this.message.saveToFile(saveFileName, saveFormatType);
    }

    public String saveBodyHtmlToTempFile() {
        return this.message.saveBodyHtmlToTempFile();
    }

    public String saveBodyHtmlToTempFile(String charSetEncoding) {
        return this.message.saveBodyHtmlToTempFile(charSetEncoding);
    }

    public String getHTMLCharSetEncoding() {
        return this.message.getHTMLCharSetEncoding();
    }

    public String getSenderID() {
        return this.message.getSenderId();
    }

    public MessageSentItemStatus getSentItemStatus() {
        return MessageSentItemStatus.getEnum(this.message.getSentItemStatus());
    }

    public int getNotifyWhenDeleted() {
        return this.message.getNotifyWhenDeleted();
    }

    public boolean setNotifyWhenDeleted(int how) {
        return this.message.setNotifyWhenDeleted(how);
    }

    public int getNotifyWhenOpened() {
        return this.message.getNotifyWhenOpened();
    }

    public boolean setNotifyWhenOpened(int how) {
        return this.message.setNotifyWhenOpened(how);
    }

    public boolean setReplyWithinDays(int day) {
        return this.message.setReplyWithinDays(day);
    }

    public boolean setReplyWhenConvenient(boolean set) {
        return this.message.setReplyWhenConvenient(set);
    }

    public boolean setReplyRequested(boolean set) {
        return this.message.setReplyRequested(set);
    }

    public boolean isReplyRequested() {
        return this.message.isReplyRequested();
    }

    public boolean isReplyWithinDays() {
        return this.message.isReplyWithinDays();
    }

    public int getReplyRequestDays() {
        return this.message.getReplyRequestDays();
    }

    public String getSenderEmailAddress() {
        return this.message.getSenderEmailAddress();
    }

    public String getFromText() {
        return this.message.getFromText();
    }

    public boolean setFromText(String from) {
        return this.message.setFromText(from);
    }

    public boolean setMimeEncoding(int mimeEncoding) {
        return this.message.setMimeEncoding(mimeEncoding);
    }

    public int getMimeEncoding() {
        return this.message.getMimeEncoding();
    }

    public String getSubject() {
        return this.message.getSubject();
    }

    public boolean setSubject(String subject) {
        return this.message.setSubject(subject);
    }

    public Date getCreationDate() {
        return this.message.getCreationDate();
    }

    public Date getDate() {
        return this.message.getDate();
    }

    public Date getDeletedDate() {
        return this.message.getDeletedDate();
    }

    public ItemType getItemType() {
        return ItemType.getEnum(this.message.getItemType());
    }

    public TransferAttachments getTransferAttachments(int[] indices) {
        return this.message.getTransferAttachments(indices);
    }

    public int getTransferOptions(TransferAttachments transferAttachs) {
        return this.message.getTransferOptions(transferAttachs);
    }

    public int getTransferOptions(TransferItems transferItems) {
        return this.message.getTransferOptions(transferItems);
    }

    public boolean transfer(TransferAttachments transferAttachs, int action) {
        return this.message.transfer(transferAttachs, action);
    }

    public boolean transfer(TransferItems transferItems, int action) {
        return this.message.transfer(transferItems, action);
    }

    public boolean isAllDayEvent() {
        return this.message.isAllDayEvent();
    }

    public boolean isChecklistDummyItem() {
        return this.message.isChecklistDummyItem();
    }

    public boolean isCompleted() {
        return this.message.isCompleted();
    }

    public boolean isDeleted() {
        return this.message.isDeleted();
    }

    public boolean isForwarded() {
        return this.message.isForwarded();
    }

    public boolean isIMAPDeleted() {
        return this.message.isIMAPDeleted();
    }

    public boolean isIMAPHeader() {
        return this.message.isImapHeader();
    }

    public boolean isIMAPMessage() {
        return this.message.isImapMessage();
    }

    public boolean isNNTPHeader() {
        return this.message.isNntpHeader();
    }

    public boolean isNNTPMessage() {
        return this.message.isNntpMessage();
    }

    public boolean isRSSMessage() {
        return this.message.isRssMessage();
    }

    public boolean isRead() {
        return this.message.isRead();
    }

    public boolean isRepliedTo() {
        return this.message.isRepliedTo();
    }

    public boolean isInChecklist() {
        return this.message.isInChecklist();
    }

    public boolean isPersonal() {
        return this.message.isPersonal();
    }

    public boolean setPostedViewName(boolean posted) {
        return this.message.setPostedViewName(posted);
    }

    public boolean isPrivate() {
        return this.message.isPrivate();
    }

    public boolean isPseudoItem() {
        return this.message.isPsuedoItem();
    }

    public String getRecordID() {
        return this.message.getRecordID();
    }

    public String getViewName() {
        return this.message.getViewName();
    }

    public int getPriority() {
        return this.message.getPriority();
    }

    public boolean setPriority(int priority) {
        return this.message.setPriority(priority);
    }

    public int getSecurity() {
        return this.message.getSecurity();
    }

    public int getSize() {
        return this.message.getSize();
    }

    public String getDisplaySize() {
        return this.message.getDisplaySize();
    }

    public int getMsgBodyAttachmentSize() {
        return this.message.getMsgBodyAttachmentSize();
    }

    public boolean setSecurity(int security) {
        return this.message.setSecurity(security);
    }

    public int getBoxType() {
        return this.message.getBoxType();
    }

    public IFolder getFolder() {
        return APIFolderWrapperManager.getFolder(this.message.getFolder());
    }

    public IFolder getViewFolder() {
        return APIFolderWrapperManager.getFolder(this.message.getViewFolder());
    }

    public DistributionList getDistributionList() {
        return this.message.getDistributionList();
    }

    public boolean setDistributionList(DistributionList dlist) {
        return this.message.setDistributionList(dlist);
    }

    public boolean setBodyTextForAutoSave(String bodyText) {
        return this.message.setBodyTextForAutoSave(bodyText);
    }

    public boolean setBodyTextForSend(String bodyText) {
        return this.message.setBodyTextForSend(bodyText);
    }

    public void send(Account account) throws EngineException {
        this.message.send(account);
    }

    public void send(Account account, SendCallback callBack) throws EngineException {
        this.message.send(account, callBack);
    }

    public void post(Account account) throws EngineException, IllegalArgumentException {
        this.message.post(account);
    }

    public void post(Account account, SendCallback callBack) throws EngineException, IllegalArgumentException {
        this.message.post(account, callBack);
    }

    public IMessage changeTo(ItemType itemType) {
        return APIMessageWrapperManager.getMessage(this.message.changeTo(itemType.getValue()));
    }

    public IMessage changeTo(ItemType itemType, boolean keepOriginalMessage, boolean keepDistributionList) {
        return APIMessageWrapperManager.getMessage(this.message.changeTo(itemType.getValue(), keepOriginalMessage, keepDistributionList));
    }

    public IMessage createSimpleForward() throws EngineException {
        return APIMessageWrapperManager.getMessage(this.message.createSimpleForward());
    }

    public IMessage createSimpleForward(String partialFwdText) throws EngineException {
        return APIMessageWrapperManager.getMessage(this.message.createSimpleForward(partialFwdText));
    }

    public IMessage createForward() throws EngineException {
        return APIMessageWrapperManager.getMessage(this.message.createForward());
    }

    public IMessage createReply(int style, boolean withBody) throws EngineException {
        return APIMessageWrapperManager.getMessage(this.message.createReply(style, withBody));
    }

    public IMessage createReply(int style, boolean withBody, boolean withAttachments) throws EngineException {
        return APIMessageWrapperManager.getMessage(this.message.createReply(style, withBody, withAttachments));
    }

    public IMessage createReply(int style, boolean withBody, boolean withAttachments, String partialReplyText) throws EngineException {
        return APIMessageWrapperManager.getMessage(this.message.createReply(style, withBody, withAttachments, partialReplyText));
    }

    public IMessage createResend(int option) {
        return APIMessageWrapperManager.getMessage(this.message.createResend(option));
    }

    public void markComplete(boolean fCompleted) throws EngineException {
        this.message.markComplete(fCompleted);
    }

    public void markOpen() throws EngineException {
        this.message.markOpen();
    }

    public void markPrivate(boolean fMarkPrivate) throws EngineException {
        this.message.markPrivate(fMarkPrivate);
    }

    public void archive() throws EngineException {
        this.message.archive();
    }

    public void markRead() throws EngineException {
        this.message.markRead();
    }

    public void markReadLater() throws EngineException {
        this.message.markReadLater();
    }

    public boolean delete() {
        return this.message.delete();
    }

    public boolean deleteAndEmpty() {
        return this.message.deleteAndEmpty();
    }

    public boolean restore() {
        return this.message.restore();
    }

    public boolean empty() {
        return this.message.empty();
    }

    public void unDelete() throws EngineException {
        this.message.unDelete();
    }

    public boolean deleteAttachment(int index) {
        return this.message.deleteAttachment(index);
    }

    public boolean deleteAttachment(IAttachment attachment) {
        return this.message.deleteAttachment(attachment.getNativeAttachment());
    }

    public boolean addAttachment(String fileName) {
        return this.message.addAttachment(fileName);
    }

    public boolean addAttachment(IMessage msg) {
        return this.message.addAttachment(msg.getNativeMessage());
    }

    public boolean saveDraft(String where) throws UnresolvedAddressException {
        return this.message.saveDraft(where);
    }

    public boolean saveDraft(String where, SendCallback callBack) throws UnresolvedAddressException {
        return this.message.saveDraft(where, callBack);
    }

    public void modify() throws EngineException {
        this.message.modify();
    }

    public void modify(SendCallback callBack) throws EngineException {
        this.message.modify(callBack);
    }

    public void modify(SendCallback callBack, boolean fPromptRecurring) throws EngineException {
        this.message.modify(callBack, fPromptRecurring);
    }

    public IAttachment[] getAttachments() {
        long time = System.currentTimeMillis();
        Attachment[] nativeAttachments = this.message.getAttachments();
        int length = nativeAttachments.length;
        IAttachment[] attachments = new IAttachment[length];
        for (int i = 0; i < length; ++i) {
            attachments[i] = APIMessageWrapperManager.getAttachment(nativeAttachments[i]);
        }
        return attachments;
    }

    public boolean hasSourceAttachment() {
        return this.message.hasSourceAttachment();
    }

    public int findSourceAttachment() {
        return this.message.findSourceAttachment();
    }

    public boolean hasPaperclipAttachments() {
        return this.message.hasPaperclipAttachments();
    }

    public boolean hasBodyText() {
        return this.message.hasBodyText();
    }

    public void getInfoFile(String sFilename) {
        this.message.getInfoFile(sFilename);
    }

    public void retractItem() {
        this.message.retractItem();
    }

    public ISuggestedBody getSuggestedBody() {
        return APIMessageWrapperManager.getSuggestedBody(this.message.getSuggestedBody());
    }

    public ISuggestedBody getSuggestedBody(boolean htmlMode) {
        return APIMessageWrapperManager.getSuggestedBody(this.message.getSuggestedBody(htmlMode));
    }

    public int getOpenTotals() {
        return this.message.getOpenTotals();
    }

    public Date getDueDate() {
        return this.message.getDueDate();
    }

    public int getPercentComplete() {
        return this.message.getPercentComplete();
    }

    public boolean canHandleJunkMailItem(int listType) {
        return this.message.canHandleJunkMailItem(listType);
    }

    public int canHandleJunkMailItem() {
        return this.message.canHandleJunkMailItem();
    }

    public int handleJunkMailItem(int listType) {
        return this.message.handleJunkMailItem(listType);
    }

    public boolean isDigitallySigned() {
        return this.message.isDigitallySigned();
    }

    public boolean isDigitallyClearSigned() {
        return this.message.isDigitallyClearSigned();
    }

    public boolean isDigitallySignedOrEncrypted() {
        return this.message.isDigitallySignedorEncrypted();
    }

    public boolean isEncrypted() {
        return this.message.isEncrypted();
    }

    public void showInChecklist(boolean bShow) {
        this.message.showInChecklist(bShow);
    }

    public ICategoryList getCategories() {
        return APIWrapperManager.getCategoryList(this.message.getCategories());
    }

    public void setCategories(ICategoryList categories) {
        this.message.setCategories(categories.getNativeCategoryList());
    }

    public ICategory getPrimaryCategory() {
        return APIWrapperManager.getCategory(this.message.getPrimaryCategory());
    }

    public String getPersonalizeNotes() {
        return this.message.getPersonalizeNotes();
    }

    public String getPersonalizeSubject() {
        return this.message.getPersonalizeSubject();
    }

    public boolean canUpdatePersonalizeData() {
        return this.message.canUpdatePersonalizeData();
    }

    public void updatePersonalizeData(String mySubject, String myNotes, ICategoryList categories) {
        this.message.updatePersonalizeData(mySubject, myNotes, categories.getNativeCategoryList());
    }

    public boolean canUpdateChecklistData() {
        return this.message.canUpdateChecklistData();
    }

    public void updateChecklistData(boolean bSetDueDate, Date dueDate, boolean bSetPercentComplete, int percentComplete, boolean bIsComplete, IItemList itemList, int newOrderIndex) {
        this.message.updateChecklistData(bSetDueDate, dueDate, bSetPercentComplete, percentComplete, bIsComplete, itemList == null ? null : itemList.getNativeItemList(), newOrderIndex);
    }

    public boolean containsExternalImages() {
        return this.message.containsExternalImages();
    }

    public boolean getUserEnabledImages() {
        return this.message.getUserEnabledImages();
    }

    public void setUserEnabledImages(boolean bEnabled) {
        this.message.setUserEnabledImages(bEnabled);
    }

    public void addVCard(String vCardFileName) {
        this.message.addVCard(vCardFileName);
    }

    public boolean isStubbedOr3rdPartyOnlyItem() {
        return this.message.isStubbedOr3rdPartyOnlyItem();
    }

    public int getSendOptionExpireDays() {
        return this.message.getSendOptionExpireDays();
    }

    public boolean setSendOptionExpireDays(int expireDays) {
        return this.message.setSendOptionExpireDays(expireDays);
    }

    public IDelayDeliverInfo getSendOptionDelayDeliverInfo() {
        return APIMessageWrapperManager.getDelayDeliverInfo(this.message.getSendOptionDelayDeliverInfo());
    }

    public boolean setSendOptionDelayDeliverInfo(IDelayDeliverInfo delay) {
        if (delay != null) {
            return this.message.setSendOptionDelayDeliverInfo(delay.getNativeDelayDeliverInfo());
        }
        return this.message.setSendOptionDelayDeliverInfo(null);
    }

    public boolean getSendOptionNotifyRecipients() {
        return this.message.getSendOptionNotifyRecipients();
    }

    public boolean setSendOptionNotifyRecipients(boolean bEnabled) {
        return this.message.setSendOptionNotifyRecipients(bEnabled);
    }

    public boolean getSendOptionCreateSentItem() {
        return this.message.getSendOptionCreateSentItem();
    }

    public boolean setSendOptionCreateSentItem(boolean bEnabled) {
        return this.message.setSendOptionCreateSentItem(bEnabled);
    }

    public int getSendOptionStatusTracking() {
        return this.message.getSendOptionStatusTracking();
    }

    public boolean setSendOptionStatusTracking(int setting) {
        return this.message.setSendOptionStatusTracking(setting);
    }

    public boolean getSendOptionMailAutoDelete() {
        return this.message.getSendOptionMailAutoDelete();
    }

    public boolean setSendOptionMailAutoDelete(boolean bEnabled) {
        return this.message.setSendOptionMailAutoDelete(bEnabled);
    }

    public int getSendOptionInternetStatusTracking() {
        return this.message.getSendOptionInternetStatusTracking();
    }

    public boolean setSendOptionInternetStatusTracking(int setting) {
        return this.message.setSendOptionInternetStatusTracking(setting);
    }

    public boolean getSendOptionConcealSubject() {
        return this.message.getSendOptionConcealSubject();
    }

    public boolean setSendOptionConcealSubject(boolean bEnabled) {
        return this.message.setSendOptionConcealSubject(bEnabled);
    }

    public boolean isDiscussionItem() {
        return this.message.isDiscussionItem();
    }

    public boolean isPostedViewName() {
        return this.message.isPostedViewName();
    }

    public Account getSendingAccount() {
        return this.message.getSendingAccount();
    }

    public void setSendingAccount(Account account) {
        this.message.setSendingAccount(account);
    }

    public String toString() {
        return this.message.toString() + " (" + this.getSubject() + ")";
    }

    public IDataStore getSendingDataStore() {
        return APIWrapperManager.getDataStore(this.message.getSendingDataStore());
    }

    public boolean setSendingDataStore(IDataStore dataStore) {
        return this.message.setSendingDataStore(dataStore == null ? null : dataStore.getNativeDataStore());
    }
}

