/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.api.impl.message;

import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.APIInternal;
import com.novell.gw.jclient.api.enums.NoteAutodate;
import com.novell.gw.jclient.api.impl.message.MessageImpl_Cached;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.INote;
import com.novell.gw.message.Note;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class NoteImpl_Cached
extends MessageImpl_Cached
implements INote {
    private static final Logger logger = Logger.getLogger(NoteImpl_Cached.class);
    private static Set<CacheKey> cacheKeySet = new HashSet<CacheKey>();
    private Map<CacheKey, Object> cache = new HashMap<CacheKey, Object>();
    protected INote note;

    protected NoteImpl_Cached(INote note) {
        super(note);
        this.note = note;
    }

    public void clearCachedValues() {
        super.clearCachedValues();
        this.cache.clear();
    }

    @APIInternal
    public Note getNativeNote() {
        return this.note.getNativeNote();
    }

    public Date getStartDate() {
        CacheKey cacheKey = CacheKey.GET_START_DATE;
        Date value = (Date)this.cache.get((Object)cacheKey);
        if (value == null) {
            value = this.note.getStartDate();
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.cache.put(cacheKey, value);
            }
        }
        return value;
    }

    public boolean setStartDate(Date startDate) {
        CacheKey cacheKey = CacheKey.GET_START_DATE;
        if (cacheKeySet.contains((Object)cacheKey)) {
            this.cache.put(cacheKey, null);
        }
        return this.note.setStartDate(startDate);
    }

    public Date[] getAutoDate() {
        CacheKey cacheKey = CacheKey.GET_AUTO_DATE;
        Date[] value = (Date[])this.cache.get((Object)cacheKey);
        if (value == null) {
            value = this.note.getAutoDate();
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.cache.put(cacheKey, value);
            }
        }
        return value;
    }

    public boolean setAutoDate(Date[] dates, long duration) {
        CacheKey cacheKey = CacheKey.GET_AUTO_DATE;
        if (cacheKeySet.contains((Object)cacheKey)) {
            this.cache.put(cacheKey, null);
        }
        return this.note.setAutoDate(dates, duration);
    }

    public boolean accept(NoteAutodate iAutodateExtent) {
        return this.note.accept(iAutodateExtent);
    }

    public boolean accept(String sReplyText, NoteAutodate iAutodateExtent, IFolder calendarFolder) {
        return this.note.accept(sReplyText, iAutodateExtent, calendarFolder);
    }

    public boolean decline(NoteAutodate iAutodateExtent) {
        return this.note.decline(iAutodateExtent);
    }

    public boolean decline(String sReplyText, NoteAutodate iAutodateExtent) {
        return this.note.decline(sReplyText, iAutodateExtent);
    }

    public INote delegate() throws EngineException {
        return this.note.delegate();
    }

    public boolean isAccepted() {
        return this.note.isAccepted();
    }

    public boolean isAutodate() {
        return this.note.isAutodate();
    }

    public boolean isDelegated() {
        Boolean isDelegated = (Boolean)this.cache.get((Object)CacheKey.IS_DELEGATED);
        if (isDelegated == null) {
            isDelegated = this.note.isDelegated();
            if (cacheKeySet.contains((Object)CacheKey.IS_DELEGATED)) {
                this.cache.put(CacheKey.IS_DELEGATED, isDelegated);
            }
        }
        return isDelegated;
    }

    public int getNotifyWhenAccepted() {
        return this.note.getNotifyWhenAccepted();
    }

    public boolean setNotifyWhenAccepted(int how) {
        return this.note.setNotifyWhenAccepted(how);
    }

    public int getNotifyWhenDeclined() {
        return this.note.getNotifyWhenDeclined();
    }

    public boolean setNotifyWhenDeclined(int how) {
        return this.note.setNotifyWhenDeclined(how);
    }

    public IItem[] getAutoDateItems() {
        return this.note.getAutoDateItems();
    }

    static {
        cacheKeySet.add(CacheKey.IS_DELEGATED);
        cacheKeySet.add(CacheKey.GET_START_DATE);
        cacheKeySet.add(CacheKey.GET_AUTO_DATE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CacheKey {
        IS_DELEGATED,
        GET_START_DATE,
        GET_AUTO_DATE;

    }
}

