/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.novell.gw.jclient.api.APIFactory;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.application.ContactsTableCache;
import com.novell.gw.jclient.application.controls.addressbook.table.AddressBookTableModel;
import com.novell.gw.jclient.application.controls.addressbook.table.EntriesTableRenderer;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;

public class CategoriesContactsEntryRenderer
extends EntriesTableRenderer {
    private ContactsTableCache cache = new ContactsTableCache();

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ICategoryList c = this.getCachedCategoryAt(table, row);
        JComponent comp = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (c != null) {
            Color backgroundColor = CategoryUtils.getPrimaryBackgroundColor(c);
            Color textColor = CategoryUtils.getPrimaryTextColor(c);
            if (isSelected) {
                if (backgroundColor != null) {
                    comp.setForeground(backgroundColor);
                } else {
                    comp.setForeground(table.getSelectionForeground());
                }
                if (textColor != null) {
                    comp.setBackground(textColor);
                } else {
                    comp.setBackground(table.getSelectionBackground());
                }
            } else {
                if (backgroundColor != null) {
                    comp.setBackground(backgroundColor);
                } else {
                    comp.setBackground(CategoryUtils.DEFAULT_CATEGORY_BACKGROUND_COLOR);
                }
                if (textColor != null) {
                    comp.setForeground(textColor);
                } else {
                    comp.setForeground(CategoryUtils.DEFAULT_CATEGORY_TEXT_COLOR);
                }
            }
        }
        return comp;
    }

    private ICategoryList getCachedCategoryAt(JTable table, int row) {
        ICategoryList c = (ICategoryList)this.cache.getItem(row);
        if (c == null) {
            c = this.getCategoryAt(table, row);
            this.cache.putItem(c, row);
        }
        return c;
    }

    private ICategoryList getCategoryAt(JTable table, int row) {
        AddressBookTableModel model = (AddressBookTableModel)table.getModel();
        if (model == null || model.getItemList() == null) {
            throw new NullPointerException();
        }
        IItem[] contacts = new IItem[]{model.getItemList().getItemAt(row)};
        return APIFactory.getAPIUtils().getCategories(contacts);
    }

    public void clearCache() {
        this.cache.clear();
    }
}

