/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.interfaces.IFolderDisplaySettings;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.controls.GWSplitPane;
import com.novell.gw.jclient.application.controls.itemview.QuickViewerLocation;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.options.AppearanceSettings;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.DividerPositionListener;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.apache.log4j.Logger;

public class GWMainAppFrameMainPanel
extends OrientablePanel {
    private static Logger logger = Logger.getLogger(GWMainAppFrameMainPanel.class);
    private GWMainAppFrame frame;
    private DividerPositionListener treeWidthListener;
    private QuickViewerDividerLocationListener quickViewerWidthAndHeightListener = new QuickViewerDividerLocationListener();
    private boolean startup = true;
    private JPanel pnlTable;
    private JPanel pnlTree;
    private JPanel pnlQuickViewer;
    private JSplitPane spMain;
    private JSplitPane spSecondary;
    private JSplitPane spFolderTree;
    private JSplitPane spQuickViewer;
    private boolean quickViewerVisible;
    private boolean folderTreeVisible;
    private boolean longFolderTree;
    private QuickViewerLocation quickViewerLocation;

    public GWMainAppFrameMainPanel(GWMainAppFrame parentFrame, JPanel tablePanel, JPanel treePanel) {
        super(new BorderLayout());
        if (parentFrame == null) {
            throw new IllegalArgumentException("parentFrame is null");
        }
        if (tablePanel == null) {
            throw new IllegalArgumentException("tablePanel is null");
        }
        if (treePanel == null) {
            throw new IllegalArgumentException("treePanel is null");
        }
        this.frame = parentFrame;
        this.pnlTable = tablePanel;
        this.pnlTree = treePanel;
        this.createSplitPanes();
        this.initFlags();
        this.layoutComponents();
    }

    private void createSplitPanes() {
        this.spMain = new GWSplitPane(0);
        this.spMain.setOneTouchExpandable(false);
        this.spMain.setBorder(BorderFactory.createEmptyBorder());
        this.spSecondary = new GWSplitPane(0);
        this.spSecondary.setOneTouchExpandable(false);
        this.spSecondary.setBorder(BorderFactory.createEmptyBorder());
        this.spMain.setName("GWMainAppFrameMainPanel_spMain");
        this.spSecondary.setName("GWMainAppFrameMainPanel_spSecondary");
    }

    private void initFlags() {
        AppearanceSettings appearanceSettings = EngineCommandManager.getInstance(this.frame.getUserGuid()).getAppearanceSettings();
        this.quickViewerVisible = false;
        this.folderTreeVisible = appearanceSettings.isFolderTreeVisible();
        this.quickViewerLocation = appearanceSettings.getQuickViewerLocation();
        this.longFolderTree = appearanceSettings.isFolderTreeLong();
        logger.debug((Object)("flags inited: QuickViewer: " + this.quickViewerVisible + " > " + (Object)((Object)this.quickViewerLocation) + ", FolderTree: " + this.folderTreeVisible + " > " + this.longFolderTree));
    }

    private void layoutComponents() {
        logger.debug((Object)"laying components out ...");
        this.removeAllListenersAndAliases();
        this.removeAll();
        this.createSplitPanes();
        if (!this.quickViewerVisible && !this.folderTreeVisible) {
            logger.debug((Object)"simplest case - only table");
            this.layoutTableOnly();
        } else if (!this.quickViewerVisible && this.folderTreeVisible) {
            logger.debug((Object)"only FolderTree and table");
            this.layoutTableAndTree();
        } else if (!this.folderTreeVisible) {
            logger.debug((Object)"only QuickViewer and table");
            if (this.pnlQuickViewer == null) {
                this.pnlQuickViewer = this.frame.getQuickViewerPanel();
            }
            this.layoutTableAndQuickViewer();
        } else {
            logger.debug((Object)"all three components present...");
            if (this.pnlQuickViewer == null) {
                this.pnlQuickViewer = this.frame.getQuickViewerPanel();
            }
            if (this.quickViewerLocation == QuickViewerLocation.RIGHT) {
                logger.debug((Object)"QuickViewer is at right");
                this.layoutAllQuickViewerAtRight();
            } else if (this.longFolderTree) {
                logger.debug((Object)"Folder tree long");
                this.layoutAllFolderTreeLong();
            } else {
                logger.debug((Object)"Folder tree short");
                this.layoutAllFolderTreeShort();
            }
        }
        this.updateComponentsStates();
        this.updateUI();
        logger.debug((Object)"... components layed out");
    }

    private void layoutTableOnly() {
        this.add((Component)this.pnlTable, "Center");
    }

    private void layoutTableAndTree() {
        this.spMain.setOneTouchExpandable(true);
        this.spMain.setOrientation(1);
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            this.spMain.setLeftComponent(this.pnlTree);
            this.spMain.setRightComponent(this.pnlTable);
        } else {
            this.spMain.setRightComponent(this.pnlTree);
            this.spMain.setLeftComponent(this.pnlTable);
        }
        this.add(this.spMain);
        this.spFolderTree = this.spMain;
        this.spFolderTree.setDividerLocation(this.fixWidth(this.loadTreeWidth()));
        this.treeWidthListener = new DividerPositionListener("FOLDERLIST_SPLITPOS", this.spFolderTree);
        this.spFolderTree.addPropertyChangeListener(this.treeWidthListener);
    }

    private void layoutTableAndQuickViewer() {
        this.spMain.setOneTouchExpandable(false);
        switch (this.quickViewerLocation) {
            case BOTTOM: {
                this.spMain.setOrientation(0);
                this.spMain.setTopComponent(this.pnlTable);
                this.spMain.setBottomComponent(this.pnlQuickViewer);
                break;
            }
            case RIGHT: {
                this.spMain.setOrientation(1);
                if (UIUtils.getComponentOrientation().isLeftToRight()) {
                    this.spMain.setLeftComponent(this.pnlTable);
                    this.spMain.setRightComponent(this.pnlQuickViewer);
                    break;
                }
                this.spMain.setRightComponent(this.pnlTable);
                this.spMain.setLeftComponent(this.pnlQuickViewer);
                break;
            }
            default: {
                throw new IllegalStateException("unexpected QuickViewer location: " + (Object)((Object)this.quickViewerLocation));
            }
        }
        this.add(this.spMain);
        this.spQuickViewer = this.spMain;
        switch (this.quickViewerLocation) {
            case BOTTOM: {
                this.spQuickViewer.setDividerLocation(this.loadQuickViewerHeight());
                break;
            }
            case RIGHT: {
                this.spQuickViewer.setDividerLocation(this.fixWidth(this.loadQuickViewerWidth()));
                break;
            }
            default: {
                throw new IllegalStateException("unexpected QuickViewer location: " + (Object)((Object)this.quickViewerLocation));
            }
        }
        this.pnlQuickViewer.addComponentListener(this.quickViewerWidthAndHeightListener);
    }

    private void layoutAllQuickViewerAtRight() {
        this.spSecondary.setOneTouchExpandable(true);
        this.spSecondary.setOrientation(1);
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            this.spSecondary.setLeftComponent(this.pnlTree);
            this.spSecondary.setRightComponent(this.pnlTable);
        } else {
            this.spSecondary.setRightComponent(this.pnlTree);
            this.spSecondary.setLeftComponent(this.pnlTable);
        }
        this.spFolderTree = this.spSecondary;
        this.spFolderTree.setDividerLocation(this.loadTreeWidth());
        this.spMain.setOneTouchExpandable(false);
        this.spMain.setOrientation(1);
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            this.spMain.setLeftComponent(this.spFolderTree);
            this.spMain.setRightComponent(this.pnlQuickViewer);
        } else {
            this.spMain.setRightComponent(this.spFolderTree);
            this.spMain.setLeftComponent(this.pnlQuickViewer);
        }
        this.add(this.spMain);
        this.spQuickViewer = this.spMain;
        this.spQuickViewer.setDividerLocation(this.fixWidth(this.loadQuickViewerWidth()));
        this.pnlQuickViewer.addComponentListener(this.quickViewerWidthAndHeightListener);
        this.treeWidthListener = new DividerPositionListener("FOLDERLIST_SPLITPOS", this.spFolderTree);
        this.spFolderTree.addPropertyChangeListener(this.treeWidthListener);
    }

    private void layoutAllFolderTreeLong() {
        this.spSecondary.setOneTouchExpandable(false);
        this.spSecondary.setOrientation(0);
        this.spSecondary.setTopComponent(this.pnlTable);
        this.spSecondary.setBottomComponent(this.pnlQuickViewer);
        this.spQuickViewer = this.spSecondary;
        this.spQuickViewer.setDividerLocation(this.loadQuickViewerHeight());
        this.spMain.setOneTouchExpandable(true);
        this.spMain.setOrientation(1);
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            this.spMain.setLeftComponent(this.pnlTree);
            this.spMain.setRightComponent(this.spQuickViewer);
        } else {
            this.spMain.setRightComponent(this.pnlTree);
            this.spMain.setLeftComponent(this.spQuickViewer);
        }
        this.add(this.spMain);
        this.spFolderTree = this.spMain;
        this.spFolderTree.setDividerLocation(this.loadTreeWidth());
        this.treeWidthListener = new DividerPositionListener("FOLDERLIST_SPLITPOS", this.spFolderTree);
        this.spFolderTree.addPropertyChangeListener(this.treeWidthListener);
        this.pnlQuickViewer.addComponentListener(this.quickViewerWidthAndHeightListener);
    }

    private void layoutAllFolderTreeShort() {
        this.spSecondary.setOneTouchExpandable(true);
        this.spSecondary.setOrientation(1);
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            this.spSecondary.setLeftComponent(this.pnlTree);
            this.spSecondary.setRightComponent(this.pnlTable);
        } else {
            this.spSecondary.setRightComponent(this.pnlTree);
            this.spSecondary.setLeftComponent(this.pnlTable);
        }
        this.spFolderTree = this.spSecondary;
        this.spFolderTree.setDividerLocation(this.loadTreeWidth());
        this.spMain.setOneTouchExpandable(false);
        this.spMain.setOrientation(0);
        this.spMain.setTopComponent(this.spFolderTree);
        this.spMain.setBottomComponent(this.pnlQuickViewer);
        this.add(this.spMain);
        this.spQuickViewer = this.spMain;
        this.spQuickViewer.setDividerLocation(this.loadQuickViewerHeight());
        this.treeWidthListener = new DividerPositionListener("FOLDERLIST_SPLITPOS", this.spFolderTree);
        this.spFolderTree.addPropertyChangeListener(this.treeWidthListener);
        this.pnlQuickViewer.addComponentListener(this.quickViewerWidthAndHeightListener);
    }

    private void removeAllListenersAndAliases() {
        if (this.spFolderTree != null) {
            this.spFolderTree.removePropertyChangeListener(this.treeWidthListener);
        }
        if (this.pnlQuickViewer != null) {
            this.pnlQuickViewer.removeComponentListener(this.quickViewerWidthAndHeightListener);
        }
        this.spQuickViewer = null;
        this.spQuickViewer = null;
        logger.debug((Object)"all listeners removed");
    }

    public void updatePanelForFolder(AbstractFolder folder) {
        if (folder == null) {
            throw new IllegalArgumentException("folder is null");
        }
        logger.debug((Object)("updating for folder: " + folder));
        boolean flagsChanged = false;
        IFolderDisplaySettings displaySettings = folder.getDisplaySettings();
        boolean isOverriddenQuickViewerSettings = displaySettings.isQuickViewerApplyPerFolder();
        if (isOverriddenQuickViewerSettings) {
            boolean folderValue = displaySettings.isQuickViewerVisible();
            if (this.quickViewerVisible != folderValue) {
                this.quickViewerVisible = folderValue;
                flagsChanged = true;
            }
        } else {
            boolean defaultValue = GWCommandManager.getInstance(this.frame.getUserGuid()).getAppearanceSettings().isQuickViewerVisible();
            if (this.quickViewerVisible != defaultValue) {
                this.quickViewerVisible = defaultValue;
                flagsChanged = true;
            }
        }
        boolean isOverridenFolderTreeSettings = displaySettings.getFolderTreeApplyPerFolder();
        if (isOverridenFolderTreeSettings) {
            boolean isFolderTreeVisible = displaySettings.isFolderTreeVisible();
            if (this.folderTreeVisible != isFolderTreeVisible) {
                this.folderTreeVisible = isFolderTreeVisible;
                flagsChanged = true;
            }
        } else {
            boolean defaultValue = GWCommandManager.getInstance(this.frame.getUserGuid()).getAppearanceSettings().isFolderTreeVisible();
            if (this.folderTreeVisible != defaultValue) {
                this.folderTreeVisible = defaultValue;
                flagsChanged = true;
            }
        }
        if (flagsChanged) {
            this.layoutComponents();
        }
        if (this.startup) {
            this.startup = false;
            this.frame.setFolderListVisible(this.folderTreeVisible);
        }
        logger.debug((Object)("updated for folder: " + folder));
    }

    public void setFolderTreeVisible(boolean visible) {
        if (this.folderTreeVisible != visible) {
            this.folderTreeVisible = visible;
            this.layoutComponents();
        }
    }

    public boolean isFolderTreeVisible() {
        return this.folderTreeVisible;
    }

    public void setQuickViewerVisible(boolean visible) {
        if (this.quickViewerVisible != visible) {
            this.quickViewerVisible = visible;
            this.layoutComponents();
            AbstractFolder folder = this.frame.getFolder();
            IFolderDisplaySettings displaySettings = folder.getDisplaySettings();
            if (displaySettings.isQuickViewerApplyPerFolder()) {
                displaySettings.setQuickViewerVisible(visible);
            }
        }
    }

    public boolean isQuickViewerVisible() {
        return this.quickViewerVisible;
    }

    public void setQuickViewerLocation(QuickViewerLocation position) {
        if (this.quickViewerLocation != position) {
            this.quickViewerLocation = position;
            this.layoutComponents();
        }
    }

    public boolean isLongFolderTree() {
        return this.longFolderTree;
    }

    public void setLongFolderTree(boolean longFolderTree) {
        AppearanceSettings settings = GWCommandManager.getInstance(this.frame.getUserGuid()).getAppearanceSettings();
        if (!settings.isLockedFolderTreeLength() && this.longFolderTree != longFolderTree) {
            this.longFolderTree = longFolderTree;
            this.layoutComponents();
            settings.setFolderTreeLong(longFolderTree);
        }
    }

    private int fixWidth(int leftToRidhtOrientationWidth) {
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            return leftToRidhtOrientationWidth;
        }
        return this.revertWidth(leftToRidhtOrientationWidth);
    }

    private int revertWidth(int leftToRidhtOrientationWidth) {
        int frameWidth = ApplicationOptions.getInstance().getInteger(this.frame.getOptionFrameName() + '.' + "WIN_WIDTH", 700);
        int rightToLeftOrientationWidth = frameWidth - leftToRidhtOrientationWidth;
        return rightToLeftOrientationWidth;
    }

    private int loadTreeWidth() {
        int width = ApplicationOptions.getInstance().getInteger("FOLDERLIST_SPLITPOS", 150);
        return width;
    }

    private int loadQuickViewerWidth() {
        int width = ApplicationOptions.getInstance().getInteger("QUICKVIEWER_SPLITPOS_RIGHT", 400);
        return width;
    }

    private int loadQuickViewerHeight() {
        int height = ApplicationOptions.getInstance().getInteger("QUICKVIEWER_SPLITPOS", 200);
        logger.debug((Object)("QuickViewer height: " + height));
        return height;
    }

    private void updateComponentsStates() {
        if (this.frame.isQuickViewerInited()) {
            if (this.pnlQuickViewer != null) {
                boolean wasVisible;
                boolean bl = wasVisible = !this.frame.getQuickViewer().isHidden();
                if (wasVisible != this.quickViewerVisible) {
                    this.frame.getQuickViewer().setHidden(!this.quickViewerVisible);
                }
            } else {
                logger.warn((Object)"QuickViewer panel is not initialized");
            }
        }
    }

    private class QuickViewerDividerLocationListener
    extends ComponentAdapter {
        private QuickViewerDividerLocationListener() {
        }

        public void componentResized(ComponentEvent e) {
            JSplitPane splitPane = GWMainAppFrameMainPanel.this.spQuickViewer;
            int dividerLocation = splitPane.getDividerLocation();
            ApplicationOptions applicationOptions = ApplicationOptions.getInstance();
            switch (GWMainAppFrameMainPanel.this.quickViewerLocation) {
                case BOTTOM: {
                    logger.debug((Object)("Saving option setting (bottom) to: [" + dividerLocation + ']'));
                    applicationOptions.put("QUICKVIEWER_SPLITPOS", dividerLocation);
                    break;
                }
                case RIGHT: {
                    logger.debug((Object)("Saving option setting (right) to: [" + dividerLocation + ']'));
                    applicationOptions.put("QUICKVIEWER_SPLITPOS_RIGHT", dividerLocation);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected QuickViewer location: " + (Object)((Object)GWMainAppFrameMainPanel.this.quickViewerLocation)));
                }
            }
            applicationOptions.saveChanges();
        }
    }
}

