/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.appframework.ActionList;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.toolbars.ApplicationFrameToolBar;
import com.novell.gw.jclient.application.controls.toolbars.AppointmentOperationsToolBar;
import com.novell.gw.jclient.application.controls.toolbars.CheckListToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ContactOperationsToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ContactsFolderToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ExtAccountFolderToolbar;
import com.novell.gw.jclient.application.controls.toolbars.GWApplicationFrameToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ItemOperationsEmptyToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ItemOperationsToolBar;
import com.novell.gw.jclient.application.controls.toolbars.NntpFolderToolBar;
import com.novell.gw.jclient.application.controls.toolbars.NntpSubFolderToolBar;
import com.novell.gw.jclient.application.controls.toolbars.QueryFolderToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ReminderNoteOperationsToolBar;
import com.novell.gw.jclient.application.controls.toolbars.SentItemOperationsToolBar;
import com.novell.gw.jclient.application.controls.toolbars.TaskOperationsToolBar;
import com.novell.gw.jclient.application.controls.toolbars.TrashFolderToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ext.DragableHeaderToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ext.DropableToolBarsPanel;
import com.novell.gw.jclient.application.controls.toolbars.ext.HeaderToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ext.ToolBarUtils;
import com.novell.gw.jclient.application.controls.toolbars.ext.ToolBarsPanelsPane;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CheckListFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import com.novell.gw.jclient.bl.om.folders.ImapFolder;
import com.novell.gw.jclient.bl.om.folders.NntpFolder;
import com.novell.gw.jclient.bl.om.folders.NntpSubFolder;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.folders.TrashFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;

class GWMainAppFrameToolBarsPanelsPane
extends ToolBarsPanelsPane {
    private static Logger logger = Logger.getLogger(GWMainAppFrameToolBarsPanelsPane.class);
    private static final int DEFAULT_MAIN_TOOLBAR_ROW = 0;
    private static final int DEFAULT_ITEM_CONTEXT_TOOLBAR_ROW = 1;
    private static final int DEFAULT_FOLDER_CONTEXT_TOOLBAR_ROW = 2;
    private static final int DEFAULT_TOOLBAR_LOCATION_AT_ROW = 0;
    private static final int MAX_NUMBER_OF_TOOLBARS = 3;
    private HeaderToolBar htlbMain = new DragableHeaderToolBar();
    private HeaderToolBar htlbItemContext = new DragableHeaderToolBar();
    private HeaderToolBar htlbFolderContext = new DragableHeaderToolBar();
    private JToolBar itemContextToolbar = null;
    private JToolBar folderContextToolbar = null;
    private GWMainAppFrame parentFrame;
    private Map<Class<? extends ApplicationFrameToolBar>, ApplicationFrameToolBar> toolBars = new HashMap<Class<? extends ApplicationFrameToolBar>, ApplicationFrameToolBar>();

    GWMainAppFrameToolBarsPanelsPane(GWMainAppFrame parentFrame) {
        super(parentFrame.getController());
        this.parentFrame = parentFrame;
        this.init();
    }

    private void init() {
        for (int i = 0; i < 3; ++i) {
            DropableToolBarsPanel dropablePanel = this.buildDropableToolBarsPanel(i);
            if (dropablePanel == null) continue;
            this.add(dropablePanel);
        }
        ActionList actionList = this.getController().getActionList();
        long time = System.currentTimeMillis();
        this.toolBars.put(GWApplicationFrameToolBar.class, new GWApplicationFrameToolBar(actionList));
        this.toolBars.put(ItemOperationsToolBar.class, new ItemOperationsToolBar(actionList));
        this.toolBars.put(ItemOperationsEmptyToolBar.class, new ItemOperationsEmptyToolBar(actionList));
        this.toolBars.put(SentItemOperationsToolBar.class, new SentItemOperationsToolBar(actionList));
        this.toolBars.put(AppointmentOperationsToolBar.class, new AppointmentOperationsToolBar(actionList));
        this.toolBars.put(TaskOperationsToolBar.class, new TaskOperationsToolBar(actionList));
        this.toolBars.put(ReminderNoteOperationsToolBar.class, new ReminderNoteOperationsToolBar(actionList));
        this.toolBars.put(TrashFolderToolBar.class, new TrashFolderToolBar(actionList));
        this.toolBars.put(CheckListToolBar.class, new CheckListToolBar(actionList));
        this.toolBars.put(QueryFolderToolBar.class, new QueryFolderToolBar(actionList));
        this.toolBars.put(NntpFolderToolBar.class, new NntpFolderToolBar(actionList));
        this.toolBars.put(NntpSubFolderToolBar.class, new NntpSubFolderToolBar(actionList));
        this.toolBars.put(ContactsFolderToolBar.class, new ContactsFolderToolBar(actionList));
        this.toolBars.put(ContactOperationsToolBar.class, new ContactOperationsToolBar(actionList));
        this.toolBars.put(ExtAccountFolderToolbar.class, new ExtAccountFolderToolbar(actionList));
        logger.debug((Object)("toolbars creation time, ms: " + (System.currentTimeMillis() - time)));
        this.htlbMain.setToolBar(this.toolBars.get(GWApplicationFrameToolBar.class));
    }

    private void rebuildFolderContextToolbar() {
        if (GWMainAppFrameToolBarsPanelsPane.isFolderContextToolBarVisible()) {
            if (this.folderContextToolbar != null) {
                if (!this.folderContextToolbar.equals(this.htlbFolderContext.getToolBar())) {
                    this.htlbFolderContext.setToolBar(this.folderContextToolbar);
                }
                this.htlbFolderContext.setVisible(true);
            } else {
                this.htlbFolderContext.setVisible(false);
            }
        } else {
            this.htlbFolderContext.setVisible(false);
        }
    }

    private void rebuildItemContextToolbar() {
        if (GWMainAppFrameToolBarsPanelsPane.isItemContextToolBarVisible() && !this.parentFrame.isShowQuickViewer()) {
            if (this.itemContextToolbar != null && !this.itemContextToolbar.equals(this.htlbItemContext.getToolBar())) {
                this.htlbItemContext.setToolBar(this.itemContextToolbar);
            }
            this.htlbItemContext.setVisible(true);
        } else {
            this.htlbItemContext.setVisible(false);
        }
    }

    private void updateItemContextToolbar() {
        Class toolbarClass;
        if (this.selectedItemsInfo != null) {
            if (this.selectedItemsInfo.hasFolders()) {
                assert (this.selectedItemsInfo.getFolders().size() == 1);
                assert (!this.selectedItemsInfo.hasItems());
                toolbarClass = ItemOperationsEmptyToolBar.class;
            } else {
                assert (this.selectedItemsInfo.hasItems());
                assert (this.selectedItemsInfo.getItems().size() == 1);
                assert (!this.selectedItemsInfo.hasFolders());
                AbstractItem selectedItem = this.selectedItemsInfo.getItem();
                toolbarClass = ControlsUtils.getItemToolbarClass(selectedItem);
            }
        } else {
            assert (this.selectedContactsInfo != null);
            toolbarClass = ContactOperationsToolBar.class;
        }
        this.itemContextToolbar = this.toolBars.get(toolbarClass);
    }

    private void updateFolderContextToolbar() {
        AbstractFolder folder = this.selectedPanel == null ? this.openedFolder : this.selectedPanel.getPanelFolder();
        Class toolbarClass = null;
        if (folder instanceof CheckListFolder) {
            toolbarClass = CheckListToolBar.class;
        }
        if (folder instanceof QueryFolder) {
            toolbarClass = QueryFolderToolBar.class;
        } else if (folder instanceof TrashFolder) {
            toolbarClass = TrashFolderToolBar.class;
        } else if (folder instanceof ContactsFolder) {
            toolbarClass = ContactsFolderToolBar.class;
        } else if (folder instanceof NntpFolder) {
            toolbarClass = NntpFolderToolBar.class;
        } else if (folder instanceof NntpSubFolder) {
            toolbarClass = NntpSubFolderToolBar.class;
        } else if (folder instanceof ImapFolder) {
            toolbarClass = ExtAccountFolderToolbar.class;
        }
        this.folderContextToolbar = toolbarClass == null ? null : this.toolBars.get(toolbarClass);
    }

    public void saveToolbarsPositions() {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (!(component instanceof Container) || ((Container)component).getComponents().length != 0) continue;
            this.remove(component);
        }
        components = this.getComponents();
        if (components.length > 3) {
            logger.warn((Object)("Too many components: " + components.length));
            logger.warn((Object)"Tool bars positions will NOT be saved!");
            return;
        }
        JToolBar toolbar = null;
        Container toolbarParent = null;
        Container toolbarSlot = null;
        String optionsPrefix = "MAIN_FRAME.";
        if (this.isMainToolBarVisible() && (toolbarParent = (toolbar = (JToolBar)this.toolBars.get(GWApplicationFrameToolBar.class)).getParent()) instanceof DragableHeaderToolBar && (toolbarSlot = toolbarParent.getParent()) instanceof DropableToolBarsPanel) {
            int toolbarSlotIndex = ToolBarUtils.indexOf(toolbarSlot);
            ApplicationOptions.getInstance().put(optionsPrefix + "TOOLBAR_MAIN" + "." + "TOOLBAR_ROW", toolbarSlotIndex);
            ApplicationOptions.getInstance().put(optionsPrefix + "TOOLBAR_MAIN" + "." + "TOOLBAR_LOCATION_AT_ROW", toolbarParent.getLocation().x);
        }
        if (GWMainAppFrameToolBarsPanelsPane.isItemContextToolBarVisible() && (toolbarParent = (toolbar = this.itemContextToolbar).getParent()) instanceof DragableHeaderToolBar && (toolbarSlot = toolbarParent.getParent()) instanceof DropableToolBarsPanel) {
            int toolbarSlotIndex = ToolBarUtils.indexOf(toolbarSlot);
            ApplicationOptions.getInstance().put(optionsPrefix + "TOOLBAR_ITEM_CONTEXT" + "." + "TOOLBAR_ROW", toolbarSlotIndex);
            ApplicationOptions.getInstance().put(optionsPrefix + "TOOLBAR_ITEM_CONTEXT" + "." + "TOOLBAR_LOCATION_AT_ROW", toolbarParent.getLocation().x);
        }
        if (GWMainAppFrameToolBarsPanelsPane.isFolderContextToolBarVisible() && (toolbar = this.folderContextToolbar) != null && (toolbarParent = toolbar.getParent()) instanceof DragableHeaderToolBar && (toolbarSlot = toolbarParent.getParent()) instanceof DropableToolBarsPanel) {
            int toolbarSlotIndex = ToolBarUtils.indexOf(toolbarSlot);
            ApplicationOptions.getInstance().put(optionsPrefix + "TOOLBAR_FOLDER_CONTEXT" + "." + "TOOLBAR_ROW", toolbarSlotIndex);
            ApplicationOptions.getInstance().put(optionsPrefix + "TOOLBAR_FOLDER_CONTEXT" + "." + "TOOLBAR_LOCATION_AT_ROW", toolbarParent.getLocation().x);
        }
    }

    protected DropableToolBarsPanel buildDropableToolBarsPanel(int rowIndex) {
        if (rowIndex >= 3 || rowIndex < 0) {
            throw new IllegalArgumentException("illegal rowIndex: " + rowIndex);
        }
        String optionsPrefix = "MAIN_FRAME.";
        int mainToolBarRow = ApplicationOptions.getInstance().getInteger(optionsPrefix + "TOOLBAR_MAIN" + "." + "TOOLBAR_ROW", 0);
        int mainToolBarSift = ApplicationOptions.getInstance().getInteger(optionsPrefix + "TOOLBAR_MAIN" + "." + "TOOLBAR_LOCATION_AT_ROW", 0);
        int itemContextToolBarRow = ApplicationOptions.getInstance().getInteger(optionsPrefix + "TOOLBAR_ITEM_CONTEXT" + "." + "TOOLBAR_ROW", 1);
        int itemContextToolBarShift = ApplicationOptions.getInstance().getInteger(optionsPrefix + "TOOLBAR_ITEM_CONTEXT" + "." + "TOOLBAR_LOCATION_AT_ROW", 0);
        int folderContextToolBarRow = ApplicationOptions.getInstance().getInteger(optionsPrefix + "TOOLBAR_FOLDER_CONTEXT" + "." + "TOOLBAR_ROW", 2);
        int folderContextToolBarShift = ApplicationOptions.getInstance().getInteger(optionsPrefix + "TOOLBAR_FOLDER_CONTEXT" + "." + "TOOLBAR_LOCATION_AT_ROW", 0);
        logger.debug((Object)("Main toolbar row = " + mainToolBarRow + ", shift = " + mainToolBarSift));
        logger.debug((Object)("Item Context toolbar row = " + itemContextToolBarRow + ", shift = " + itemContextToolBarShift));
        logger.debug((Object)("Folder Context toolbar row = " + folderContextToolBarRow + ", shift = " + folderContextToolBarShift));
        if (mainToolBarRow != rowIndex && itemContextToolBarRow != rowIndex && folderContextToolBarRow != rowIndex) {
            return null;
        }
        DropableToolBarsPanel dropablePanel = new DropableToolBarsPanel();
        TreeMap<Integer, HeaderToolBar> shiftsAndToolbars = new TreeMap<Integer, HeaderToolBar>();
        if (mainToolBarRow == rowIndex) {
            shiftsAndToolbars.put(mainToolBarSift, this.htlbMain);
        }
        if (itemContextToolBarRow == rowIndex) {
            if (shiftsAndToolbars.containsKey(itemContextToolBarShift)) {
                logger.info((Object)"shift of item context toolbar fixed");
                itemContextToolBarShift += 100;
            }
            shiftsAndToolbars.put(itemContextToolBarShift, this.htlbItemContext);
        }
        if (folderContextToolBarRow == rowIndex) {
            if (shiftsAndToolbars.containsKey(folderContextToolBarShift)) {
                logger.info((Object)"shift of selectedFolder context toolbar fixed");
                folderContextToolBarShift += 200;
            }
            shiftsAndToolbars.put(folderContextToolBarShift, this.htlbFolderContext);
        }
        HeaderToolBar previousPanel = null;
        int previousShift = 0;
        for (Integer shift : shiftsAndToolbars.keySet()) {
            HeaderToolBar panel = (HeaderToolBar)shiftsAndToolbars.get(shift);
            dropablePanel.add(panel);
            if (previousPanel != null) {
                previousPanel.setCurrentWidth(shift - previousShift);
            }
            previousPanel = panel;
            previousShift = shift;
        }
        return dropablePanel;
    }

    public void updateToolbars() {
        this.htlbMain.setVisible(this.isMainToolBarVisible());
        this.rebuildItemContextToolbar();
        this.rebuildFolderContextToolbar();
    }

    private boolean isMainToolBarVisible() {
        return GWCommandManager.getInstance(ControlsUtils.getUserGuid(this.getController())).getAppearanceSettings().isMainToolBarVisible();
    }

    private static boolean isItemContextToolBarVisible() {
        return ApplicationOptions.getInstance().getBoolean("ITEM_CONTEXT_TOOLBAR_VISIBLE", true);
    }

    private static boolean isFolderContextToolBarVisible() {
        return ApplicationOptions.getInstance().getBoolean("FOLDER_CONTEXT_TOOLBAR_VISIBLE", true);
    }

    protected void processSingleItemSelected() {
        this.updateItemContextToolbar();
        this.updateToolbars();
    }

    protected void processOpeningFolderStarted() {
        this.updateFolderContextToolbar();
        this.itemContextToolbar = this.toolBars.get(ItemOperationsEmptyToolBar.class);
        this.updateToolbars();
    }

    protected void processPanelSelected() {
        this.updateFolderContextToolbar();
        this.itemContextToolbar = this.toolBars.get(ItemOperationsEmptyToolBar.class);
        this.updateToolbars();
    }

    protected void processSingleContactSelected() {
        this.updateItemContextToolbar();
        this.updateToolbars();
    }
}

