/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.PathManager;
import com.novell.gw.jclient.bl.om.options.DateTimeOptions;
import java.io.File;
import org.apache.log4j.Logger;

class SettingsMigrator {
    private static Logger logger = Logger.getLogger(SettingsMigrator.class);

    SettingsMigrator() {
    }

    static void migrateUserSettings() {
        assert (EngineCommandManager.getUserInfo() != null) : "user not logged in yet";
        SettingsMigrator.migrateTimeZoneLabels();
    }

    private static void migrateTimeZoneLabels() {
        String alternateTimeZoneLabelKeySuffix = ".alternate time zone label";
        String workstationTimeZoneLabelKeySuffix = ".workstation time zone label";
        String alternateTimeZoneLabelKey = null;
        String workstationTimeZoneLabelKey = null;
        String defaultTimeZoneLabel = "";
        String alternateTimeZoneLabel = null;
        String workstationTimeZoneLabel = null;
        ApplicationOptions options = ApplicationOptions.getInstance();
        for (String key : options.keySet()) {
            if (alternateTimeZoneLabelKey == null && key.endsWith(alternateTimeZoneLabelKeySuffix)) {
                alternateTimeZoneLabelKey = key;
                alternateTimeZoneLabel = options.getString(alternateTimeZoneLabelKey, defaultTimeZoneLabel);
            } else if (workstationTimeZoneLabelKey == null && key.endsWith(workstationTimeZoneLabelKeySuffix)) {
                workstationTimeZoneLabelKey = key;
                workstationTimeZoneLabel = options.getString(workstationTimeZoneLabelKey, defaultTimeZoneLabel);
            }
            if (alternateTimeZoneLabelKey == null || workstationTimeZoneLabelKey == null) continue;
            break;
        }
        if (alternateTimeZoneLabelKey != null) {
            options.remove(alternateTimeZoneLabelKey);
        }
        if (workstationTimeZoneLabelKey != null) {
            options.remove(workstationTimeZoneLabelKey);
        }
        if (alternateTimeZoneLabelKey != null || workstationTimeZoneLabelKey != null) {
            options.saveChanges();
        }
        if (alternateTimeZoneLabelKey != null || workstationTimeZoneLabelKey != null) {
            OptionManager optionManager = OptionManager.getInstance();
            DateTimeOptions dateTimeOptions = optionManager.getDateTimeOptions();
            if (alternateTimeZoneLabelKey != null && defaultTimeZoneLabel.equals(dateTimeOptions.getAlternateTimeZoneLabel())) {
                dateTimeOptions.setAlternateTimeZoneLabel(alternateTimeZoneLabel);
            }
            if (workstationTimeZoneLabelKey != null && defaultTimeZoneLabel.equals(dateTimeOptions.getWorkstationTimeZoneLabel())) {
                dateTimeOptions.setWorkstationTimeZoneLabel(workstationTimeZoneLabel);
            }
            optionManager.setDateTimeOptions(dateTimeOptions);
        }
    }

    static void migrateGlobalSettings() {
        SettingsMigrator.migrateInterfaceFontToInterface();
    }

    private static void migrateInterfaceFontToInterface() {
        String oldName = "interface_font.properties";
        String newName = "interface.properties";
        File newFile = new File(PathManager.getBaseOptionsPath() + newName);
        File oldFile = new File(PathManager.getBaseOptionsPath() + oldName);
        if (!newFile.exists() && oldFile.exists()) {
            oldFile.renameTo(newFile);
        }
    }
}

