/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.ApplicationFrame;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.actions.AbstractAttachmentAction;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.filechoser.GWFileChooser;
import com.novell.gw.jclient.application.controls.filechoser.GWMacFileChooser;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionsDefaults;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;

public class ActionAttachmentSave
extends AbstractAttachmentAction {
    private File lastSelectedFile = null;

    public ActionAttachmentSave(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.ATTACHMENT_SAVE, StringResources.SAVE_AS_D);
    }

    private File getLastSelectedFile() {
        if (this.lastSelectedFile == null) {
            this.lastSelectedFile = new File(ApplicationOptions.getInstance().getString("LAST_ATTACHMENT_SAVING_PATH", OptionsDefaults.LAST_ATTACHMENT_SAVING_PATH));
        }
        return this.lastSelectedFile;
    }

    private void setLastSelectedFile(File theLastSelectedFile) {
        this.lastSelectedFile = theLastSelectedFile;
        if (theLastSelectedFile.isDirectory()) {
            ApplicationOptions.getInstance().put("LAST_ATTACHMENT_SAVING_PATH", theLastSelectedFile.getPath());
        } else {
            ApplicationOptions.getInstance().put("LAST_ATTACHMENT_SAVING_PATH", theLastSelectedFile.getParent());
        }
    }

    protected void performAction(ActionEvent e) {
        GWAttachment attachment = ((GWAttachment[])this.getMVCModel())[0];
        if (OS.isMacOS()) {
            GWMacFileChooser fileChoser = new GWMacFileChooser((ApplicationFrame)this.getActionList().getMVCView(), StringResources.SAVE_ATTACHMENT, this.getLastSelectedFile(), new File(attachment.getFileName()), 1);
            UIUtils.centerWindow((Window)fileChoser, (ApplicationFrame)this.getActionList().getMVCView());
            fileChoser.setVisible(true);
            String selectedFile = fileChoser.getFile();
            if (selectedFile != null) {
                String selecteddirectory = fileChoser.getDirectory();
                this.setLastSelectedFile(new File(selecteddirectory + selectedFile));
                MessageUtils.saveAttachment(attachment, this.getLastSelectedFile().getPath());
            }
        } else {
            GWFileChooser fileChoser = new GWFileChooser((ApplicationFrame)this.getActionList().getMVCView(), StringResources.SAVE_ATTACHMENT, this.getLastSelectedFile(), new File(attachment.getFileName()), 0, 1, false);
            fileChoser.setVisible(true);
            String[] paths = fileChoser.getResult();
            if (paths != null) {
                int res;
                String path = paths[0];
                File theFile = new File(path);
                if (theFile.exists() && (res = JOptionPane.showConfirmDialog(this.getActionList().getOwnerComponent(), StringResources.formatString(StringResources.FILE_ALREADY_EXISTS_OVERWRITE_Q, theFile.getPath()), StringResources.SAVE_ATTACHMENT_D, 0, 2)) == 1) {
                    return;
                }
                this.setLastSelectedFile(theFile.getParentFile());
                MessageUtils.saveAttachment(attachment, path);
            }
        }
    }
}

