/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.utils.OS;
import com.novell.gw.ab.UnresolvedAddressException;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.ActionSaveDraft;
import com.novell.gw.jclient.application.actions.send.SendCallbackImpl;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.frames.compose.FrameComposePostedItem;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.MessageBody;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ActionCancelFrame
extends AppAction {
    private static Logger logger = Logger.getLogger(ActionCancelFrame.class);
    boolean performing = false;

    public ActionCancelFrame(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.CANCEL_FRAME, StringResources.CANCEL, ImageResources.ICON_ACT_CANCEL);
        if (OS.isMacOS()) {
            this.setAccelerator(KeyStroke.getKeyStroke(87, OS.getMetaKey()));
        } else if (!(theAppActionList instanceof GWMainAppFrameActionList)) {
            this.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        }
    }

    protected void performAction(ActionEvent e) {
        if (logger.isDebugEnabled() && e != null) {
            logger.debug((Object)("e.getSource(): " + e.getSource()));
            logger.debug((Object)("getController().getMVCView(): " + this.getController().getMVCView()));
        }
        this.doPerformAction();
    }

    public boolean doPerformAction() {
        this.performing = true;
        boolean result = this.doCancelFrame();
        this.performing = false;
        return result;
    }

    private boolean doCancelFrame() {
        ApplicationFrame frame = (ApplicationFrame)this.getActionList().getMVCView();
        if (frame instanceof FrameCompose) {
            FrameCompose frameCompose = (FrameCompose)frame;
            AbstractItem item = frameCompose.getGwItem();
            SendCallbackImpl callback = new SendCallbackImpl(frameCompose, (IMessage)item.getNativeItem());
            frameCompose.stopTimer();
            boolean makeConfirmation = frameCompose.getItemEdit().isDirty();
            if (makeConfirmation) {
                boolean isPersonal = item.isPersonal();
                String message = !isPersonal ? StringResources.SAVE_CHANGES_TO_THIS_ITEM_Q : StringResources.YOU_MADE_CHANGES_ON_THIS_ITEM_WHAT_WOULD_YOU;
                Object[] options = new Object[]{StringResources.SAVE_AND_CLOSE, StringResources.CLOSE, StringResources.CANCEL};
                int option = JOptionPane.showOptionDialog(frame, message, StringResources.CANCEL, -1, 3, null, options, options[0]);
                switch (option) {
                    case -1: 
                    case 2: {
                        frameCompose.startTimer();
                        return false;
                    }
                    case 1: {
                        break;
                    }
                    case 0: {
                        if (frameCompose instanceof FrameComposePostedItem && !item.isDraft()) {
                            frameCompose.getNewItem();
                            if (isPersonal) {
                                try {
                                    GWCommandManager.getInstance(this.getUserGuid()).modifyItem(item, callback);
                                }
                                catch (UnresolvedAddressException e1) {
                                    frame.setVisible(true);
                                    JOptionPane.showMessageDialog(frame, StringResources.SOME_ADDRESSES_ARE_UNDELIVERABLE, StringResources.UNDELIVERABLE_MESSAGE, 2);
                                }
                                catch (GWCommandException e1) {
                                    frame.setVisible(true);
                                    ErrorDialog.processGWException(e1, this.getActionList().getOwnerComponent());
                                }
                            } else {
                                try {
                                    GWCommandManager.getInstance(this.getUserGuid()).postItem(item, callback, frameCompose.getFromDataStore());
                                }
                                catch (GWCommandException e1) {
                                    frame.setVisible(true);
                                    ErrorDialog.processGWException(e1, this.getActionList().getOwnerComponent());
                                }
                            }
                            return false;
                        }
                        ActionSaveDraft action = (ActionSaveDraft)frame.getAppActionList().getAction(ActionKey.SAVE_DRAFT);
                        if (!action.doSaveDraft()) {
                            return false;
                        }
                        ActionCancelFrame.clearPosted(frameCompose);
                        break;
                    }
                }
            } else {
                ActionCancelFrame.clearPosted(frameCompose);
            }
            frameCompose.getGwItem().getNativeItem().deleteAutoSaveFile();
        }
        ((ApplicationFrameActionList)frame.getController()).closeFrame();
        return true;
    }

    private static void clearPosted(FrameCompose theFrameCompose) {
        try {
            AbstractItem initialItem = theFrameCompose.getItemEdit().getInitialItem();
            initialItem.clear();
            initialItem.setMessage(new MessageBody(initialItem));
        }
        catch (Exception e1) {
            logger.error((Object)e1, (Throwable)e1);
        }
    }

    public JComponent getToolBarComponent() {
        AbstractButton button = this.createActionButton();
        button.setText(StringResources.CANCEL);
        return button;
    }

    public boolean isPerforming() {
        return this.performing;
    }
}

