/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.components.ButtonList;
import com.appframework.utils.OS;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.AbstractMultipleItemsAction;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ActionMarkPrivate
extends AbstractMultipleItemsAction {
    private static Logger logger = Logger.getLogger(ActionMarkPrivate.class);
    protected ButtonList buttons = new ButtonList();

    public ActionMarkPrivate(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.MARK_PRIVATE, StringResources.ACTION_MARK_PRIVATE, ImageResources.ACT_MARKPRIVATE);
        this.setType(AppAction.ActionType.CHECKABLE);
        this.setToolTipText(StringResources.DESCRIPTION_MARK_PRIVATE);
        this.setAccelerator(KeyStroke.getKeyStroke(119, 0));
    }

    protected void performAction(ActionEvent e) {
        if (this.isSingleItemModel()) {
            AbstractItem item = this.getItem();
            if (this.getItemList() == null) {
                try {
                    boolean isPrivate = !item.isPrivate();
                    this.getItem().getNativeItem().markPrivate(isPrivate);
                    this.buttons.setSelected(isPrivate);
                }
                catch (EngineException e1) {
                    logger.error((Object)e1);
                    logger.debug((Object)e1, (Throwable)e1);
                }
            } else {
                this.buttons.setSelected(!item.isPrivate());
                GWEngineUtils.markItemPrivate(this.getItemList(), item);
            }
        } else if (this.isMultipleItemsModel()) {
            GWEngineUtils.markItemsPrivate(this.getItemList());
        } else {
            JOptionPane.showMessageDialog(this.getActionList().getOwnerComponent(), StringResources.NO_ITEM_IS_SELECTED, StringResources.GROUPWISE_CLIENT, 2);
        }
    }

    protected boolean checkEnableOnSelect() {
        if (this.isSingleItemModel()) {
            this.buttons.setSelected(this.getItem().isPrivate());
            return this.getItem().canMarkPrivate();
        }
        if (this.isMultipleItemsModel()) {
            this.buttons.setSelected(GWEngineUtils.isItemsPrivate(this.getItems()));
            return this.getItemList().canMarkSelectedItemsPrivate();
        }
        return false;
    }

    public JMenuItem getMenuItem() {
        JMenuItem menuItem = OS.createMenuItem(this);
        this.buttons.add(menuItem);
        return menuItem;
    }

    public JComponent getToolBarComponent() {
        AbstractButton button = (AbstractButton)super.getToolBarComponent();
        this.buttons.add(button);
        return button;
    }
}

