/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.ApplicationFrameActionList;
import com.appframework.components.customizedbutton.listpopuppane.HeaderGradientButton;
import com.appframework.components.customizedbutton.listpopuppane.ListPopupPane;
import com.appframework.mvc.GlobalCommand;
import com.appframework.utils.OS;
import com.novell.gw.jclient.api.enums.DataStoreAccessRequestType;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.actions.AbstractNewCalendarItemAction;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ToolbarGradientComponent;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.compose.FrameComposeActionList;
import com.novell.gw.jclient.application.frames.compose.FrameComposeAppointment;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.exceptions.ItemNotCreatedException;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionNewAppointment
extends AbstractNewCalendarItemAction<AppointmentItem>
implements ToolbarGradientComponent {
    private static Logger logger = Logger.getLogger(ActionNewAppointment.class);
    private boolean isCreatedFromBusySearch;
    private TimeInterval appointmentTime = new TimeInterval();

    public ActionNewAppointment(ApplicationFrameActionList theAppActionList) {
        this((ActionList)theAppActionList, ActionKey.NEW_APPOINTMENT, StringResources.ACTION_APPOINTMENT, ImageResources.ICON_ACT_NEW_APPOINTMENT);
        this.setToolTipText(StringResources.DESCRIPTION_NEW_APPT);
        this.setAccelerator(KeyStroke.getKeyStroke(65, 1 + OS.getMetaKey()));
    }

    public ActionNewAppointment(ActionList actionList, ActionKey actionKey, String name) {
        super(actionList, actionKey, name);
    }

    public ActionNewAppointment(ActionList actionList, ActionKey actionKey, String name, Icon icon) {
        super(actionList, actionKey, name, icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performAction(ActionEvent e) {
        if (!this.validateRecipients()) {
            return;
        }
        try {
            IAddressable self;
            MessageUtils.showBusyCursor(true);
            AppointmentItem newItem = this.getAppointment();
            this.applyInitialDates(newItem);
            FrameComposeAppointment frameCompose = new FrameComposeAppointment(newItem, true, ComposeMode.NEW, this.getUserGuid());
            frameCompose.getItemEdit().setSendingFromAddressBook(this.isSendingFromAddressBook);
            if ((this.allRecipients.isEmpty() || this.isCreatedFromBusySearch) && (self = GWCommandManager.getInstance(this.getUserGuid()).getUserFields()) != null && ((Boolean)EngineCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore().getSettings().getAppointmentIncludeSelf().getValue()).booleanValue()) {
                boolean isSelfInValidRecipients = false;
                for (IRecipient validRecipient : this.validRecipients) {
                    if (!validRecipient.getAddressable().getEmailAddress().equals(self.getEmailAddress())) continue;
                    isSelfInValidRecipients = true;
                }
                if (!isSelfInValidRecipients) {
                    this.validRecipients.add(APIAbWrapperManager.createRecipient(self));
                }
            }
            this.sendRecipients(frameCompose);
            this.isCreatedFromBusySearch = false;
            frameCompose.showMe();
            GlobalCommand command = new GlobalCommand(480, frameCompose);
            ((FrameComposeActionList)frameCompose.getController()).processCommand(command);
        }
        catch (ItemNotCreatedException ex) {
        }
        catch (GWCommandException e1) {
            logger.error((Object)e1, (Throwable)e1);
            ErrorDialog.processGWException(e1);
        }
        finally {
            MessageUtils.showBusyCursor(false);
        }
    }

    @Override
    protected void applyInitialDates(AppointmentItem newItem) {
        if (this.isCreatedFromBusySearch) {
            newItem.setStartDates(new Date[]{this.appointmentTime.getStartDateAsDate()});
            newItem.setEndDate(this.appointmentTime.getEndDateAsDate());
        } else {
            super.applyInitialDates(newItem);
        }
    }

    protected AppointmentItem getAppointment() throws GWCommandException {
        AppointmentItem newItem = (AppointmentItem)GWCommandManager.getInstance(this.getUserGuid()).composeNewItem(AppointmentItem.class);
        return newItem;
    }

    @Override
    public JComponent getToolBarComponent() {
        ListPopupPane buttons = new ListPopupPane(this, StringResources.NEW_APPT);
        buttons.setToolTipText(this.getToolTipText());
        buttons.addAction(this.getActionList().getAction(ActionKey.NEW_POSTED_APPOINTMENT));
        buttons.addSeparator();
        buttons.addAction(this.getActionList().getAction(ActionKey.NEW_APPOINTMENT), StringResources.APPOINTMENT);
        return buttons;
    }

    @Override
    public JComponent getToolBarGradientComponent() {
        HeaderGradientButton buttons = new HeaderGradientButton(this, StringResources.NEW_APPT);
        buttons.setToolTipText(this.getToolTipText());
        buttons.setArrowVisible(true);
        buttons.addAction(this.getActionList().getAction(ActionKey.NEW_POSTED_APPOINTMENT));
        buttons.addSeparator();
        buttons.addAction(this.getActionList().getAction(ActionKey.NEW_APPOINTMENT), StringResources.APPOINTMENT);
        return buttons;
    }

    @Override
    public void setMVCModel(Object model) {
        super.setMVCModel(model);
        if (model instanceof GWBusySearch) {
            this.isCreatedFromBusySearch = true;
            GWBusySearch uiBusySearch = (GWBusySearch)model;
            this.appointmentTime = uiBusySearch.getAppointmentTime();
            this.allRecipients = uiBusySearch.getRecipientDescriptionsList().getSelectedRecipients(null);
        }
    }

    @Override
    protected boolean checkAccess() {
        return GWCommandManager.getInstance(this.getUserGuid()).getCurrentDataStore().checkAccess(DataStoreAccessRequestType.ITEM_CREATE, ItemType.APPT, 0);
    }
}

