/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionNewCalendarItem;
import com.novell.gw.jclient.application.actions.ActionNewPostedItem;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.exceptions.ItemNotCreatedException;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class ActionNewPostedCalendarItem
extends ActionNewPostedItem
implements ActionNewCalendarItem {
    private static Logger logger = Logger.getLogger(ActionNewPostedCalendarItem.class);
    protected boolean calendarView = true;
    protected Date selectedDate = new Date();

    protected ActionNewPostedCalendarItem(ActionList actionList, ActionKey actionKey, String name) {
        super(actionList, actionKey, name);
    }

    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getController().getFrameLevel();
        ActionNewCalendarItem.NewCalendarItemListener listener = new ActionNewCalendarItem.NewCalendarItemListener(this);
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 70, listener));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 10, listener));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1860, listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(ActionEvent e) {
        AbstractCalendarItem item = null;
        try {
            MessageUtils.showBusyCursor(true);
            item = this.getItem();
            this.setInitialDates(item);
            this.doOpenItem(item);
        }
        catch (ItemNotCreatedException ex) {
        }
        catch (GWCommandException e1) {
            logger.error((Object)e1, (Throwable)e1);
            ErrorDialog.processGWException(e1);
        }
        finally {
            MessageUtils.showBusyCursor(false);
        }
    }

    protected void setInitialDates(AbstractCalendarItem item) {
        int duratioMin = (Integer)EngineCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore().getSettings().getAppointmentDefaultLength().getValue();
        if (this.isCalendarView()) {
            item.setStartDates(new Date[]{this.getSelectedDate()});
            item.setEndDate(new Date(this.selectedDate.getTime() + (long)(duratioMin * 60 * 1000)));
        }
    }

    protected abstract AbstractCalendarItem getItem() throws GWCommandException;

    public boolean isCalendarView() {
        return this.calendarView;
    }

    public void setCalendarView(boolean theCalendarView) {
        this.calendarView = theCalendarView;
    }

    public Date getSelectedDate() {
        return this.selectedDate;
    }

    public void setSelectedDate(Date theSelectedDate) {
        this.selectedDate = theSelectedDate;
    }
}

