/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.ApplicationFrameActionList;
import com.appframework.components.customizedbutton.listpopuppane.ListPopupPane;
import com.appframework.mvc.GlobalCommand;
import com.appframework.utils.OS;
import com.novell.gw.jclient.api.enums.DataStoreAccessRequestType;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.application.actions.AbstractNewCalendarItemAction;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.compose.FrameComposeActionList;
import com.novell.gw.jclient.application.frames.compose.FrameComposeTask;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.exceptions.ItemNotCreatedException;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionNewTask
extends AbstractNewCalendarItemAction<TaskItem> {
    private static Logger logger = Logger.getLogger(ActionNewTask.class);

    public ActionNewTask(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.NEW_TASK, StringResources.ACTION_TASK, ImageResources.ICON_ACT_NEW_TASK);
        this.setToolTipText(StringResources.DESCRIPTION_NEW_TASK);
        this.setAccelerator(KeyStroke.getKeyStroke(84, 1 + OS.getMetaKey()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performAction(ActionEvent e) {
        if (!this.validateRecipients()) {
            return;
        }
        try {
            MessageUtils.showBusyCursor(true);
            TaskItem newItem = (TaskItem)GWCommandManager.getInstance(this.getUserGuid()).composeNewItem(TaskItem.class);
            this.applyInitialDates(newItem);
            FrameComposeTask frameCompose = new FrameComposeTask(newItem, true, ComposeMode.NEW, this.getUserGuid());
            frameCompose.getItemEdit().setSendingFromAddressBook(this.isSendingFromAddressBook);
            this.sendRecipients(frameCompose);
            frameCompose.showMe();
            GlobalCommand command = new GlobalCommand(480, frameCompose);
            ((FrameComposeActionList)frameCompose.getController()).processCommand(command);
        }
        catch (ItemNotCreatedException ex) {
        }
        catch (GWCommandException e1) {
            logger.error((Object)e1, (Throwable)e1);
            ErrorDialog.processGWException(e1);
        }
        finally {
            MessageUtils.showBusyCursor(false);
        }
    }

    @Override
    public JComponent getToolBarComponent() {
        ListPopupPane buttons = new ListPopupPane(this, StringResources.NEW_TASK);
        buttons.addAction(this.getActionList().getAction(ActionKey.NEW_POSTED_TASK));
        buttons.addSeparator();
        buttons.addAction(this.getActionList().getAction(ActionKey.NEW_TASK), StringResources.TASK);
        return buttons;
    }

    @Override
    protected boolean checkAccess() {
        return GWCommandManager.getInstance(this.getUserGuid()).getCurrentDataStore().checkAccess(DataStoreAccessRequestType.ITEM_CREATE, ItemType.TODO, 0);
    }

    @Override
    protected void applyInitialDates(TaskItem newItem) {
        if (this.isCalendarView() && this.getSelectedDate() != null) {
            Date startDate = GWCalendarUtils.clearTime(this.getSelectedDate());
            newItem.setStartDates(new Date[]{startDate});
            newItem.setEndDate(new Date(startDate.getTime()));
        }
    }
}

