/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.components.ButtonList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.StorageMode;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;

public class ActionOpenBackup
extends AppAction {
    private ButtonList buttons = new ButtonList();

    public ActionOpenBackup(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.OPEN_BACKUP, StringResources.OPEN_BACKUP);
        this.setType(AppAction.ActionType.CHECKABLE);
    }

    protected void performAction(ActionEvent e) {
        if (this.isSelected()) {
            this.getActionList().performAction(ActionKey.SHOW_USER_STORE);
        } else {
            this.getActionList().performAction(ActionKey.SWITCH_BACKUP_STORAGE);
        }
        this.setSelected(this.isSelected());
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 800, new STORE_MODE_CHANGED_EventListener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 750, new PROXY_DATA_STORE_INSTALLED_EventListener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 740, new ACTION_SWITCH_ONLINE_PERFORMED_EventListener()));
    }

    public JMenuItem getMenuItem() {
        JMenuItem menuItem = super.getMenuItem();
        this.buttons.add(menuItem);
        this.setSelected(this.isSelected());
        return menuItem;
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (this.buttons != null && this.buttons.size() > 0) {
            this.buttons.setSelected(selected);
        }
    }

    private class ACTION_SWITCH_ONLINE_PERFORMED_EventListener
    extends AppEventListener {
        private ACTION_SWITCH_ONLINE_PERFORMED_EventListener() {
        }

        public void handle(AppEvent theEvent) {
            ActionOpenBackup.this.setEnabled(true);
        }
    }

    private class PROXY_DATA_STORE_INSTALLED_EventListener
    extends AppEventListener {
        private PROXY_DATA_STORE_INSTALLED_EventListener() {
        }

        public void handle(AppEvent theEvent) {
            ActionOpenBackup.this.setEnabled(false);
        }
    }

    private class STORE_MODE_CHANGED_EventListener
    extends AppEventListener {
        private STORE_MODE_CHANGED_EventListener() {
        }

        public void handle(AppEvent theEvent) {
            StorageMode storageMode = (StorageMode)theEvent.getData();
            ActionOpenBackup.this.setEnabled(!storageMode.isArchive());
            ActionOpenBackup.this.setSelected(storageMode.isBackup());
        }
    }
}

