/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.components.customizedbutton.listpopuppane.ListPopupPane;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.novell.gw.jclient.api.enums.ContactType;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.addressbook.AbstractAddressSelectorDialog;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsDialog;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GroupContactDetailsDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.FrequentContactsAddressBook;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ActionSaveGroup
extends AppAction {
    private static Logger logger = Logger.getLogger(ActionSaveGroup.class);
    private AbstractAddressBook addressBook;
    private List subActions = new ArrayList();

    public ActionSaveGroup(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.SAVE_GROUP, StringResources.SAVE_GROUP, ImageResources.ICON_ADDRESS_BOOK_GROUP);
        this.setEnabled(false);
    }

    protected void performAction(ActionEvent e) {
        Window parentWindow = (Window)this.getActionList().getMVCView();
        FrequentContactsAddressBook frequentContactsAddressBook = EngineCommandManager.getFrequentContactsAddressBook();
        if (this.addressBook == null) {
            this.addressBook = frequentContactsAddressBook;
        }
        GroupContactDetailsDialog dialog = (GroupContactDetailsDialog)ContactDetailsDialog.createContactDetailsDialog(parentWindow, this.addressBook, ContactType.GROUP);
        dialog.addRecipients((List)this.getMVCModel());
        dialog.showMe();
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 260, new RECIPIENTS_LIST_ENTRY_CHANGED_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 250, new RECIPIENTS_LIST_EMPTY_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 390, new REMOVE_ENTRY_FROM_RECIPIENTS_LIST_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(this.getActionList().getLevel(), 360, new DIRECTORY_SELECTED_Listener()));
    }

    private void setAddressBook(AbstractAddressBook addressBook) {
        this.addressBook = addressBook;
    }

    public AbstractAddressBook getAddressBook() {
        return this.addressBook;
    }

    public JComponent getToolBarComponent() {
        ActionSaveGroup actionSaveGroup;
        ListPopupPane popupPane = new ListPopupPane(this);
        for (AbstractAddressBook addressBook : EngineCommandManager.getAddressBooks()) {
            if (addressBook.isReadOnly()) continue;
            actionSaveGroup = new ActionSaveGroupTo(this.getActionList());
            actionSaveGroup.putValue("SmallIcon", null);
            actionSaveGroup.setEnabled(true);
            actionSaveGroup.addressBook = addressBook;
            this.subActions.add(actionSaveGroup);
        }
        for (AbstractAddressBook subAction : this.subActions) {
            actionSaveGroup = (ActionSaveGroup)((Object)subAction);
            popupPane.addAction(actionSaveGroup, actionSaveGroup.addressBook.getName());
        }
        return popupPane;
    }

    protected void handle_DIRECTORY_SELECTED(AbstractAddressBook addressBook) {
        if (!(this.getActionList().getMVCView() instanceof AbstractAddressSelectorDialog) || this.getActionList().getMVCView() == AbstractAddressSelectorDialog.getLastInstance()) {
            this.addressBook = addressBook.isReadOnly() ? EngineCommandManager.getFrequentContactsAddressBook() : addressBook;
        }
    }

    private class ActionSaveGroupTo
    extends ActionSaveGroup {
        public ActionSaveGroupTo(ActionList theAppActionList) {
            super(theAppActionList);
        }

        public Object getMVCModel() {
            return ActionSaveGroup.this.getMVCModel();
        }

        public JComponent getToolBarComponent() {
            return this.createActionButton();
        }

        protected void handle_DIRECTORY_SELECTED(AbstractAddressBook addressBook) {
        }
    }

    private class RECIPIENTS_LIST_EMPTY_Listener
    extends AppEventListener {
        private RECIPIENTS_LIST_EMPTY_Listener() {
        }

        public void handle(AppEvent theEvent) {
            if (!(ActionSaveGroup.this.getActionList().getMVCView() instanceof AbstractAddressSelectorDialog) || ActionSaveGroup.this.getActionList().getMVCView() == AbstractAddressSelectorDialog.getLastInstance()) {
                ActionSaveGroup.this.setEnabled(false);
            }
        }
    }

    private class DIRECTORY_SELECTED_Listener
    extends AppEventListener {
        private DIRECTORY_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            if (!(ActionSaveGroup.this.getActionList().getMVCView() instanceof AbstractAddressSelectorDialog) || ActionSaveGroup.this.getActionList().getMVCView() == AbstractAddressSelectorDialog.getLastInstance()) {
                ActionSaveGroup.this.handle_DIRECTORY_SELECTED((AbstractAddressBook)theEvent.getData());
            }
        }
    }

    private class REMOVE_ENTRY_FROM_RECIPIENTS_LIST_Listener
    extends AppEventListener {
        private REMOVE_ENTRY_FROM_RECIPIENTS_LIST_Listener() {
        }

        public void handle(AppEvent theEvent) {
            if (!(ActionSaveGroup.this.getActionList().getMVCView() instanceof AbstractAddressSelectorDialog) || ActionSaveGroup.this.getActionList().getMVCView() == AbstractAddressSelectorDialog.getLastInstance()) {
                List data = (List)theEvent.getData();
                List recipients = (List)ActionSaveGroup.this.getMVCModel();
                recipients.removeAll(data);
                ActionSaveGroup.this.setEnabled(true);
            }
        }
    }

    private class RECIPIENTS_LIST_ENTRY_CHANGED_Listener
    extends AppEventListener {
        private RECIPIENTS_LIST_ENTRY_CHANGED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            if (!(ActionSaveGroup.this.getActionList().getMVCView() instanceof AbstractAddressSelectorDialog) || ActionSaveGroup.this.getActionList().getMVCView() == AbstractAddressSelectorDialog.getLastInstance()) {
                Object data = theEvent.getData();
                ActionSaveGroup.this.setMVCModel(data);
                ActionSaveGroup.this.setEnabled(true);
            }
        }
    }
}

