/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.actions.AbstractMainFrameAction;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.options.AppearanceSettings;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;

public class ActionShowHideNavBar
extends AbstractMainFrameAction {
    private JMenuItem menuItem;

    public ActionShowHideNavBar(ActionList appActionList) {
        super(appActionList, ActionKey.SHOW_HIDE_NAV_BAR, StringResources.NAV_BAR);
        this.setType(AppAction.ActionType.CHECKABLE);
        this.menuItem = OS.createMenuItem(this);
        this.menuItem.setSelected(this.isNavBarVisible());
    }

    protected void performAction(ActionEvent e) {
        boolean selected = ((AbstractButton)e.getSource()).isSelected();
        AppearanceSettings settings = EngineCommandManager.getInstance(this.getUserGuid()).getAppearanceSettings();
        settings.setNavBarVisible(selected);
        if (this.getFrame() instanceof GWMainAppFrame) {
            GWMainAppFrame mainFrame = (GWMainAppFrame)this.getActionList().getMVCView();
            mainFrame.setNavBarVisible(selected);
        }
        this.menuItem.setSelected(selected);
    }

    public JMenuItem getMenuItem() {
        return this.menuItem;
    }

    private boolean isNavBarVisible() {
        return EngineCommandManager.getInstance(this.getUserGuid()).getAppearanceSettings().isNavBarVisible();
    }

    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1830, new ACTION_SHOW_HIDE_NAV_BAR_Listener()));
    }

    private class ACTION_SHOW_HIDE_NAV_BAR_Listener
    extends AppEventListener {
        private ACTION_SHOW_HIDE_NAV_BAR_Listener() {
        }

        public void handle(AppEvent event) {
            if (ActionShowHideNavBar.this.getFrame() instanceof GWMainAppFrame) {
                ActionShowHideNavBar.this.menuItem.setSelected(ActionShowHideNavBar.this.isNavBarVisible());
            }
        }
    }
}

