/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.components.AbstractCancelAction;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.BasicDialog;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

public class AutodatePrompt
extends BasicDialog {
    private static Logger logger = Logger.getLogger(AutodatePrompt.class);
    public static final int THIS_INSTANCE = 0;
    public static final int ALL_INSTANCES = 1;
    public static final int FROM_THIS_INSTANCE_FORWARD = 2;
    public static final int ACTION_CANCELED = 3;
    private int result = -1;
    private JLabel messageLabel;
    private JButton btnCancel;
    private JButton btnThisForward;

    private AutodatePrompt(Dialog parentDialog) {
        super(parentDialog);
        this.buildUI();
    }

    private AutodatePrompt(Frame parentFrame) {
        super(parentFrame);
        this.buildUI();
    }

    private AutodatePrompt() {
        this.buildUI();
    }

    private void buildUI() {
        this.setTitle(StringResources.DELETE_ITEM);
        this.getContentPane().setLayout(new BorderLayout());
        this.messageLabel = new OrientableLabel(" ");
        this.messageLabel.setBorder(BorderFactory.createEmptyBorder(15, 15, 5, 15));
        this.getContentPane().add((Component)this.messageLabel, "North");
        OrientablePanel pnl = new OrientablePanel();
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 15, 10, 15));
        JMnemonicButton btn = new JMnemonicButton(new ButtonThisInstanceAction());
        this.setDefaultButton(btn);
        Insets margin = new Insets(2, 5, 2, 5);
        btn.setMargin(margin);
        pnl.add(btn);
        btn = new JMnemonicButton(new ButtonAllInstancesAction());
        btn.setMargin(margin);
        pnl.add(btn);
        this.btnThisForward = new JMnemonicButton(new ButtonFromThisInstanceForwardAction());
        this.btnThisForward.setMargin(margin);
        pnl.add(this.btnThisForward);
        this.btnCancel = new JButton(new ButtonCancelAction());
        this.btnCancel.setMargin(margin);
        pnl.add(this.btnCancel);
        this.getContentPane().add((Component)pnl, "South");
        this.setCancelButton(this.btnCancel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AutodatePrompt.this.result = 3;
            }
        });
    }

    private void setMessage(String theMessage) {
        this.messageLabel.setText(theMessage);
    }

    private int getResultID() {
        return this.result;
    }

    public static Result showDialog(Component parentComponent, String title, String message, boolean askThisForward) {
        Window window = ControlsUtils.getWindowForComponent(parentComponent);
        AutodatePrompt dd = window instanceof Frame ? new AutodatePrompt((Frame)parentComponent) : (window instanceof Dialog ? new AutodatePrompt((Dialog)parentComponent) : new AutodatePrompt());
        dd.setTitle(title);
        dd.setMessage(message);
        dd.setModal(true);
        dd.btnThisForward.setVisible(askThisForward);
        UIUtils.centerWindow((Window)dd, parentComponent);
        dd.pack();
        dd.setVisible(true);
        return new Result(dd.result, "");
    }

    private class ButtonCancelAction
    extends AbstractCancelAction {
        private ButtonCancelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            AutodatePrompt.this.result = 3;
            AutodatePrompt.this.setVisible(false);
        }
    }

    private class ButtonFromThisInstanceForwardAction
    extends AbstractAction {
        public ButtonFromThisInstanceForwardAction() {
            super(StringResources.FROM_THIS_INSTANCE_FORWARD);
        }

        public void actionPerformed(ActionEvent e) {
            AutodatePrompt.this.result = 2;
            AutodatePrompt.this.setVisible(false);
        }
    }

    private class ButtonAllInstancesAction
    extends AbstractAction {
        public ButtonAllInstancesAction() {
            super(StringResources.ALL_INSTANCES);
        }

        public void actionPerformed(ActionEvent e) {
            AutodatePrompt.this.result = 1;
            AutodatePrompt.this.setVisible(false);
        }
    }

    private class ButtonThisInstanceAction
    extends AbstractAction {
        public ButtonThisInstanceAction() {
            super(StringResources.THIS_INSTANCE);
        }

        public void actionPerformed(ActionEvent e) {
            AutodatePrompt.this.result = 0;
            AutodatePrompt.this.setVisible(false);
        }
    }

    public static class Result {
        private int resultID;
        private String comment = "";

        private Result(int theResultID, String theComment) {
            if (theResultID < 0 || theResultID > 3) {
                throw new IllegalArgumentException();
            }
            this.resultID = theResultID;
            this.comment = theComment;
        }

        public String getComment() {
            return this.comment;
        }

        public int getResultID() {
            return this.resultID;
        }
    }
}

