/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.filter;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.filter.FiltersFactory;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.filter.AbstractFilter;
import com.novell.gw.jclient.application.controls.filter.AdvancedFilter;
import com.novell.gw.jclient.application.controls.filter.QuickFilter;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButtonMenuItem;
import com.novell.gw.jclient.bl.om.filter.Filter;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;

public abstract class ActionSwitchFilter
extends AppAction {
    protected JMenuItem menuItem;

    protected ActionSwitchFilter(ActionList actionList, ActionKey actionKey, String name) {
        super(actionList, actionKey, name);
        this.setEnabled(true);
    }

    protected void performAction(ActionEvent e) {
        Filter resultFilter;
        Filter ModelFilter = (Filter)this.getMVCModel();
        int box = ModelFilter.getBoxType();
        Filter filter = FiltersFactory.getInstance().getFilter(this.getController());
        if (filter == null) {
            resultFilter = new QuickFilter("", false);
            resultFilter.setBoxType(box);
        } else if (filter instanceof QuickFilter) {
            ((QuickFilter)filter).setBoxType(box);
            resultFilter = filter;
        } else {
            resultFilter = new AdvancedFilter(filter.getItemListFilter(), true);
            ((AdvancedFilter)resultFilter).setBoxType(box);
        }
        Command command = new Command(400, resultFilter);
        this.getController().processCommand(command);
    }

    public JMenuItem getMenuItem() {
        if (this.menuItem == null) {
            this.menuItem = new OrientableRadioButtonMenuItem(this);
            this.menuItem.setComponentOrientation(UIUtils.getComponentOrientation());
        }
        return this.menuItem;
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 400, new FILTER_CHANGED_Listener()));
    }

    private class FILTER_CHANGED_Listener
    extends AppEventListener {
        private FILTER_CHANGED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionSwitchFilter action = ActionSwitchFilter.this;
            if (action.menuItem == null) {
                return;
            }
            Object data = theEvent.getData();
            if (data instanceof AbstractFilter) {
                if (!(data instanceof AdvancedFilter) || ((AdvancedFilter)data).canDiplayType()) {
                    int boxtype2;
                    AbstractFilter filter = (AbstractFilter)data;
                    AbstractFilter filter2 = (AbstractFilter)ActionSwitchFilter.this.getMVCModel();
                    int boxType = filter.getBoxType();
                    if (boxType == (boxtype2 = filter2.getBoxType())) {
                        action.menuItem.setSelected(true);
                    } else {
                        action.menuItem.setSelected(false);
                    }
                }
            } else {
                action.menuItem.setSelected(false);
            }
        }
    }
}

