/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.folder;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.novell.gw.jclient.api.enums.DataStoreAccessRequestType;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.componentrelated.ActionFoldersTree;
import com.novell.gw.jclient.application.controls.folderstree.MainGWFoldersTree;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.WeakHashMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionDeleteFolder
extends AppAction<AbstractFolder>
implements ActionFoldersTree {
    private static Logger logger = Logger.getLogger(ActionDeleteFolder.class);
    private WeakHashMap<JMenuItem, JMenuItem> menuItems = new WeakHashMap();

    public ActionDeleteFolder(ApplicationFrameActionList theAppActionList, ActionKey actionKey) {
        super((ActionList)theAppActionList, actionKey, StringResources.ACTION_DELETE, ImageResources.ICON_ACT_DELETE);
        this.setEnabled(false);
    }

    public ActionDeleteFolder(ApplicationFrameActionList theAppActionList) {
        this(theAppActionList, ActionKey.DELETE_FOLDER);
        this.setAccelerator(KeyStroke.getKeyStroke(OptionManager.getInstance().getGeneralOptions().getItemDeleteKey(), 0));
    }

    @Override
    protected void performAction(ActionEvent e) {
        boolean deleted = ActionDeleteFolder.doPerformAction((AbstractFolder)this.getMVCModel(), this.getActionList().getOwnerComponent(), this.getUserGuid());
        if (deleted) {
            MainGWFoldersTree tree = ((GWMainAppFrame)this.getController().getMVCView()).getFoldersTree();
            AbstractFolder oldSelectedFolder = (AbstractFolder)this.getMVCModel();
            Command command = new Command(2060);
            this.getController().processCommand(command);
            if (tree.getSelectedFolder().equals(oldSelectedFolder)) {
                AbstractFolder selectFolder = oldSelectedFolder.getParent();
                tree.selectFolder(selectFolder);
            } else {
                AbstractFolder selectFolder = tree.getSelectedFolder();
                command = new Command(10, selectFolder);
                this.getController().processCommand(command);
            }
        }
    }

    public static boolean doPerformAction(AbstractFolder folder, Component parent, String userGuid) {
        if (folder == null) {
            JOptionPane.showMessageDialog(parent, StringResources.FOLDER_IS_NOT_SELECTED, StringResources.GROUPWISE_CLIENT, 2);
            return false;
        }
        String folderType = folder.getType();
        int result = folderType.equals("NntpFolder") || folderType.equals("ImapFolder") ? JOptionPane.showConfirmDialog(parent, StringResources.formatString(StringResources.ARE_YOU_SURE_YOU_WANT_TO_DELETE_ACCOUNT, folder.getName()), StringResources.CONFIRM_ACCOUNT_DELETE, 0) : JOptionPane.showConfirmDialog(parent, StringResources.formatString(StringResources.ARE_YOU_SURE_YOU_WANT_TO_DELETE_FOLDER, folder.getName()), StringResources.CONFIRM_FOLDER_DELETE, 0);
        return result == 0 && EngineCommandManager.deleteFolder(folder, userGuid);
    }

    private boolean checkAccess() {
        return GWCommandManager.getInstance(this.getUserGuid()).getCurrentDataStore().checkAccess(DataStoreAccessRequestType.ITEM_DELETE, ItemType.FOLDER, 0);
    }

    @Override
    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        AppEventListener listener = new ITEM_DELETE_KEY_CHANGED_listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1410, listener));
        listener = new FOLDER_SELECTED_Listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 10, listener));
        listener = new FOLDER_UNSELECTED_Listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1930, listener));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1330, listener));
        listener = new GWITEM_SELECTED_OR_NO_Listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 20, listener));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 470, listener));
    }

    @Override
    public JMenuItem getMenuItem() {
        JMenuItem menuItem = super.getMenuItem();
        this.menuItems.put(menuItem, menuItem);
        return menuItem;
    }

    protected void handle_GWITEM_SELECTED_OR_NO(AppEvent theEvent) {
        if (!(this.actionList.getMVCView() instanceof GWMainAppFrame) || !((GWMainAppFrame)this.actionList.getMVCView()).getFoldersTree().isFocused()) {
            this.setMVCModel(null);
            this.setEnabled(false);
        }
    }

    private class GWITEM_SELECTED_OR_NO_Listener
    extends AppEventListener {
        private GWITEM_SELECTED_OR_NO_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionDeleteFolder.this.handle_GWITEM_SELECTED_OR_NO(theEvent);
        }
    }

    private class FOLDER_UNSELECTED_Listener
    extends AppEventListener {
        private FOLDER_UNSELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionDeleteFolder.this.setEnabled(false);
        }
    }

    private class ITEM_DELETE_KEY_CHANGED_listener
    extends AppEventListener {
        private ITEM_DELETE_KEY_CHANGED_listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionDeleteFolder.this.setAccelerator(KeyStroke.getKeyStroke(OptionManager.getInstance().getGeneralOptions().getItemDeleteKey(), 0));
            for (JMenuItem menuItem : ActionDeleteFolder.this.menuItems.values()) {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(OptionManager.getInstance().getGeneralOptions().getItemDeleteKey(), 0));
            }
        }
    }

    class FOLDER_SELECTED_Listener
    extends AppEventListener {
        FOLDER_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractFolder folder = (AbstractFolder)theEvent.getData();
            ActionDeleteFolder.this.setMVCModel(folder);
            ActionDeleteFolder.this.setEnabled(folder.canDelete() && ActionDeleteFolder.this.checkAccess());
        }
    }
}

