/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.folder;

import com.appframework.ApplicationFrameActionList;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.folder.AbstractFolderAction;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTreeModelUtils;
import com.novell.gw.jclient.application.dialogs.RenameFolderDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ActionRenameFolder
extends AbstractFolderAction {
    private boolean isClickInTree;

    public ActionRenameFolder(ApplicationFrameActionList theAppActionList) {
        super(theAppActionList, ActionKey.RENAME_FOLDER, StringResources.RENAME);
    }

    protected void performAction(ActionEvent e) {
        if (this.getActionList() instanceof GWMainAppFrameActionList) {
            if (this.isClickInTree) {
                ActionRenameFolder.doPerformActionForTree(this.getTargetFolder(), ((GWMainAppFrame)((GWMainAppFrameActionList)this.getActionList()).getMVCView()).getFoldersTree());
            } else {
                ActionRenameFolder.doPerformActionForTable(this.getTargetFolder());
            }
        }
    }

    public void setIsClickInTree(boolean isTree) {
        this.isClickInTree = isTree;
    }

    public static void doPerformActionForTree(AbstractFolder folder, JTree tree) {
        if (folder != null) {
            ArrayList<DefaultMutableTreeNode> arr = new ArrayList<DefaultMutableTreeNode>();
            AbstractFolder f = folder;
            while (f != null) {
                DefaultMutableTreeNode node = GWFoldersTreeModelUtils.getFolderTreeNode((DefaultMutableTreeNode)tree.getModel().getRoot(), f);
                arr.add(node);
                if (node.getParent() == null) break;
                f = (AbstractFolder)((DefaultMutableTreeNode)node.getParent()).getUserObject();
            }
            int size = arr.size();
            for (int i = 0; i < size / 2; ++i) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)arr.get(i);
                arr.set(i, (DefaultMutableTreeNode)arr.get(size - 1 - i));
                arr.set(size - 1 - i, n);
            }
            TreePath path = new TreePath(arr.toArray());
            tree.setSelectionPath(path);
            tree.startEditingAtPath(path);
        }
    }

    private static void doPerformActionForTable(AbstractFolder folder) {
        if (folder != null) {
            RenameFolderDialog renameDialog = new RenameFolderDialog(folder);
            renameDialog.showMe();
        }
    }

    protected boolean checkEnablement() {
        return ActionRenameFolder.canRename(this.getTargetFolder());
    }

    private static boolean canRename(AbstractFolder folder) {
        return folder != null && folder.canRename();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append("[opened: ");
        builder.append(this.getOpenedFolder());
        builder.append(", selected: ");
        builder.append(this.getSelectedFolders());
        builder.append(", target: ");
        builder.append(this.getTargetFolder());
        builder.append(']');
        return builder.toString();
    }
}

