/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.components.ButtonList;
import com.appframework.utils.OS;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.AbstractMultipleItemsAction;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.skinnable.SkinnableCheckBox;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionComplete
extends AbstractMultipleItemsAction {
    private static Logger logger = Logger.getLogger(ActionComplete.class);
    private JMenuItem menuItem;
    private ButtonList buttons = new ButtonList(false);

    public ActionComplete(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.COMPLETE, StringResources.ACTION_MARK_COMPLETED, ImageResources.ACT_TASKCOMPLETE);
        this.setType(AppAction.ActionType.CHECKABLE);
    }

    private void markItemComplete(AbstractItem item) {
        boolean selected = !item.isStatusCompleted();
        try {
            item.markComplete(selected);
            this.buttons.setSelected(selected);
        }
        catch (EngineException e1) {
            logger.error((Object)e1, (Throwable)e1);
        }
    }

    private void markItemsComplete(List<AbstractItem> items) {
        if (items != null && items.size() > 0) {
            boolean itemsStatus = GWEngineUtils.areItemsStatusCompleted(items);
            for (AbstractItem item : items) {
                if (itemsStatus != item.isStatusCompleted()) continue;
                this.markItemComplete(item);
            }
        }
    }

    @Override
    protected boolean checkEnableOnSelect() {
        boolean enableOnSelect = false;
        if (this.hasItems()) {
            if (this.isSingleItemModel()) {
                AbstractItem item = this.getItem();
                enableOnSelect = item.canComplete();
                this.buttons.setSelected(enableOnSelect & item.isStatusCompleted());
            } else if (this.isMultipleItemsModel()) {
                List<AbstractItem> items = this.getItems();
                enableOnSelect = GWEngineUtils.canCompleteItems(items);
                this.buttons.setSelected(enableOnSelect & GWEngineUtils.areItemsStatusCompleted(items));
            }
        }
        return enableOnSelect;
    }

    @Override
    protected void performAction(ActionEvent e) {
        if (this.isSingleItemModel()) {
            AbstractItem item = this.getItem();
            this.markItemComplete(item);
        } else if (this.isMultipleItemsModel()) {
            List<AbstractItem> items = this.getItems();
            this.markItemsComplete(items);
        }
    }

    @Override
    public JMenuItem getMenuItem() {
        this.menuItem = OS.createMenuItem(this);
        this.buttons.add(this.menuItem);
        return this.menuItem;
    }

    @Override
    public JComponent getToolBarComponent() {
        AbstractButton button = (AbstractButton)super.getToolBarComponent();
        this.buttons.add(button);
        return button;
    }

    public static void decorateCheckBox(OrientableCheckBox checkBox) {
        checkBox.setText(StringResources.COMPLETED);
        checkBox.setIcon(null);
        checkBox.setHorizontalAlignment(4);
        checkBox.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                e.getComponent().setCursor(new Cursor(12));
            }
        });
    }

    public SkinnableCheckBox getCheckBox() {
        SkinnableCheckBox cbCompleted = new SkinnableCheckBox(this);
        ActionComplete.decorateCheckBox(cbCompleted);
        this.buttons.add(cbCompleted);
        return cbCompleted;
    }

    @Override
    public void setEnabled(boolean newValue) {
        super.setEnabled(newValue);
        if (this.buttons != null && this.buttons.size() > 0) {
            this.buttons.setEnabled(newValue);
        }
    }

    @Override
    public boolean showWithText() {
        return false;
    }

    public ButtonList getGroup() {
        return this.buttons;
    }
}

