/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.ApplicationFrameActionList;
import com.appframework.components.customizedbutton.listpopuppane.ListPopupPane;
import com.appframework.event.AppEvent;
import com.appframework.mvc.Command;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.ActionDeleteOrEmptyItem;
import com.novell.gw.jclient.application.commands.AttributeKey;
import com.novell.gw.jclient.application.frames.open.FrameOpen;
import com.novell.gw.jclient.application.impl.SelectedItemsInfoImpl;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class ActionDeleteItem
extends ActionDeleteOrEmptyItem {
    public ActionDeleteItem(ActionList actionList, ActionKey actionKey, String name, Icon icon) {
        super(actionList, actionKey, name, icon);
    }

    public ActionDeleteItem(ApplicationFrameActionList theAppActionList) {
        this((ActionList)theAppActionList, ActionKey.DELETE_ITEM, StringResources.ACTION_DELETE, ImageResources.ICON_ACT_DELETE);
        this.setToolTipText(StringResources.DESCRIPTION_DELETE);
    }

    protected void performAction(ActionEvent e) {
        if (this.isSingleItemModel()) {
            AbstractItem item = this.getItem();
            AbstractItem nextItem = this.getNextItem();
            IItemList itemList = this.getItemList();
            String userGuid = this.getUserGuid();
            boolean hasOpenNext = this.hasOpenNext();
            if (MessageUtils.delete(itemList, item, this.getActionList().getOwnerComponent()) && hasOpenNext) {
                ActionDeleteItem.openItem(itemList, nextItem, userGuid);
                if (this.getController() != null) {
                    this.selectItem(nextItem, itemList);
                }
            }
        } else if (this.isMultipleItemsModel()) {
            AbstractItem nextItem = this.getNextItem();
            IItemList itemList = this.getItemList();
            if (MessageUtils.delete(this.getItems(), itemList, this.getActionList().getOwnerComponent())) {
                this.selectItem(nextItem, itemList);
            }
        } else if (this.isMultipleFoldersModel()) {
            GWEngineUtils.deleteItems(this.getItemList());
        } else {
            JOptionPane.showMessageDialog(this.getActionList().getOwnerComponent(), StringResources.NO_ITEM_IS_SELECTED, StringResources.GROUPWISE_CLIENT, 2);
        }
    }

    private void selectItem(AbstractItem item, IItemList itemList) {
        if (item != null) {
            Command command = new Command(20, new SelectedItemsInfoImpl(itemList, item));
            command.setAttribute((Object)AttributeKey.FOCUSED, Boolean.TRUE);
            this.getController().processCommand(command);
            command = new Command(870, item);
            command.setAttribute((Object)AttributeKey.FOCUSED, Boolean.TRUE);
            this.getController().processCommand(command);
        }
    }

    protected KeyStroke getCustomAccelerator() {
        return KeyStroke.getKeyStroke(OptionManager.getInstance().getGeneralOptions().getItemDeleteKey(), 0);
    }

    protected void applyAccelerator(KeyStroke oldValue, KeyStroke newValue) {
        super.applyAccelerator(oldValue, this.canEmpty() ? null : newValue);
    }

    protected boolean checkEnableOnSelect() {
        if (this.isSingleItemModel()) {
            return this.getItem().canDelete();
        }
        if (this.isMultipleItemsModel() || this.isMultipleFoldersModel()) {
            return this.getItemList().canDeleteSelectedItems();
        }
        return false;
    }

    protected void handle_FOLDER_SELECTED(AppEvent theEvent) {
        this.setEnabled(this.checkEnableOnSelect());
        super.handle_FOLDER_SELECTED(theEvent);
    }

    public JComponent getToolBarComponent() {
        ListPopupPane buttons = new ListPopupPane(this, "");
        buttons.addAction(this);
        buttons.addSeparator();
        buttons.addAction(this.getActionList().getAction(ActionKey.DELETE_AND_EMPTY_ITEM), StringResources.DELETE_AND_EMPTY);
        return buttons;
    }

    public boolean showWithText() {
        return false;
    }

    protected boolean hasOpenNext() {
        Component component = this.getActionList().getOwnerComponent();
        boolean isFrameOpen = component instanceof FrameOpen;
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        boolean readNextOnDelete = (Boolean)dataStoreSettings.getReadNextOnDelete().getValue();
        return readNextOnDelete && isFrameOpen;
    }

    private static void openItem(IItemList itemList, AbstractItem item, String userGuid) {
        if (item != null && userGuid != null) {
            MessageUtils.openItem(itemList, item, userGuid);
        }
    }
}

