/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.ApplicationFrameActionList;
import com.appframework.mvc.Command;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.AbstractMultipleItemsAction;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ActionMarkReadLater
extends AbstractMultipleItemsAction {
    private static Logger logger = Logger.getLogger(ActionMarkReadLater.class);

    public ActionMarkReadLater(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.MARK_READ_LATER, StringResources.READ_LATER, ImageResources.ACT_READLATER);
        this.setToolTipText(StringResources.DESCRIPTION_MARK_READ_LATER);
        this.setAccelerator(KeyStroke.getKeyStroke(82, OS.getMetaKey()));
    }

    protected void performAction(ActionEvent e) {
        String itemId = null;
        if (this.isSingleItemModel()) {
            AbstractItem item = this.getItem();
            itemId = item.getID();
            GWEngineUtils.markReadLater(this.getItemList(), item);
        } else if (this.isMultipleItemsModel()) {
            MessageUtils.showBusyCursor(true);
            GWEngineUtils.markReadLater(this.getItemList());
            MessageUtils.showBusyCursor(false);
        } else {
            JOptionPane.showMessageDialog(this.getActionList().getOwnerComponent(), StringResources.NO_ITEM_IS_SELECTED, StringResources.GROUPWISE_CLIENT, 2);
        }
        this.actionList.processCommand(new Command(1870, itemId));
        this.getController().processCommand(new Command(1430, Boolean.TRUE));
    }

    protected boolean checkEnableOnSelect() {
        return this.hasItemList() && this.getItemList().canMarkSelectedItemsReadLater();
    }
}

