/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.components.ButtonList;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.AbstractMultipleItemsAction;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.compose.FrameComposeActionList;
import com.novell.gw.jclient.application.frames.open.FrameOpenActionList;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class ActionMoveToArchive
extends AbstractMultipleItemsAction {
    private ButtonList buttons = new ButtonList();

    public ActionMoveToArchive(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.MOVE_TO_ARCHIVE, StringResources.MOVE_TO_ARCHIVE, ImageResources.ACT_MOVE_TO_ARCHIVE);
        this.setType(AppAction.ActionType.CHECKABLE);
        this.setToolTipText(StringResources.DESCRIPTION_MOVE_TO_ARCHIVE);
        this.buttons.setSelected(this.isSelected());
    }

    protected void performAction(ActionEvent e) {
        if (this.isSingleItemModel() || this.isMultipleItemsModel()) {
            ActionList actionList = this.getController().getActionList();
            boolean moved = this.moveToArchive();
            this.setEnabled(this.canBeEnabled());
            this.buttons.setSelected(GWCommandManager.getInstance(this.getUserGuid()).isArchive());
            if (moved && (actionList instanceof FrameOpenActionList || actionList instanceof FrameComposeActionList)) {
                ((ApplicationFrameActionList)actionList).closeFrame();
            }
        } else {
            JOptionPane.showMessageDialog(this.getActionList().getOwnerComponent(), StringResources.NO_ITEM_IS_SELECTED, StringResources.GROUPWISE_CLIENT, 2);
        }
    }

    private boolean moveToArchive() {
        try {
            return GWCommandManager.getInstance(this.getUserGuid()).archiveItems(this.getItems());
        }
        catch (GWCommandException e) {
            ErrorDialog.processGWException(e);
            return false;
        }
    }

    private boolean canBeEnabled() {
        if (this.isSingleItemModel()) {
            return this.getItem().canArchive();
        }
        if (this.isMultipleItemsModel()) {
            for (AbstractItem item : this.getItems()) {
                if (item.canArchive()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean checkEnableOnSelect() {
        boolean enabled = false;
        GWCommandManager commandManager = GWCommandManager.getInstance(this.getUserGuid());
        if (!commandManager.isProxyDataStore()) {
            if (commandManager.isArchive()) {
                enabled = true;
            } else if (commandManager.isOnlineDataStore() || commandManager.isCachingDataStore()) {
                enabled = this.canBeEnabled();
            }
        }
        this.buttons.setSelected(this.isSelected());
        return enabled;
    }

    public JMenuItem getMenuItem() {
        JMenuItem menuItem = OS.createMenuItem(this);
        this.buttons.add(menuItem);
        return menuItem;
    }

    public JComponent getToolBarComponent() {
        AbstractButton button = (AbstractButton)super.getToolBarComponent();
        this.buttons.add(button);
        return button;
    }

    public boolean isSelected() {
        return GWCommandManager.getInstance(this.getUserGuid()).isArchive();
    }
}

