/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.ApplicationFrameActionList;
import com.appframework.components.customizedbutton.listpopuppane.ListPopupPane;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.AbstractGWItemAction;
import com.novell.gw.jclient.application.printing.PrintInformation;
import com.novell.gw.jclient.application.printing.preview.PrintUtils;
import com.novell.gw.jclient.application.printing.printingitem.ItemPrintManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ActionPrintNoConfirmation
extends AbstractGWItemAction {
    private static Logger logger = Logger.getLogger(ActionPrintNoConfirmation.class);
    private boolean propertiesSelected = false;

    public ActionPrintNoConfirmation(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.PRINT_NO_CONFIRMATION, StringResources.ACTION_PRINT, ImageResources.ACT_PRINT);
        this.setAccelerator(KeyStroke.getKeyStroke(80, OS.getMetaKey()));
    }

    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1350, new OPEN_FRAME_SHOW_ITEM_CONTENT_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1360, new OPEN_FRAME_SHOW_PROPERTIES_Listener()));
    }

    protected void performAction(ActionEvent e) {
        int res = JOptionPane.showConfirmDialog(this.getActionList().getOwnerComponent(), StringResources.PRINT_ITEM_Q, StringResources.PRINTING_ITEM, 0);
        if (res == 0) {
            AbstractItem item = this.getItem();
            ItemPrintManager printManager = new ItemPrintManager(this.getController(), null, this.propertiesSelected);
            printManager.setMVCModel(item);
            PrintUtils.print(new PrintInformation(printManager.getSelectedForm(), item), this.getActionList());
        }
    }

    protected boolean checkEnableOnSelect() {
        return this.hasItems() && this.getItem().canPrint();
    }

    public JComponent getToolBarComponent() {
        ListPopupPane popupPane = new ListPopupPane(this);
        popupPane.addAction(this.getActionList().getAction(ActionKey.PRINT_CALENDAR_NO_CONFIRMATION), StringResources.CALENDAR);
        popupPane.addSeparator();
        popupPane.addAction(this);
        return popupPane;
    }

    private class OPEN_FRAME_SHOW_PROPERTIES_Listener
    extends AppEventListener {
        private OPEN_FRAME_SHOW_PROPERTIES_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionPrintNoConfirmation.this.propertiesSelected = true;
        }
    }

    private class OPEN_FRAME_SHOW_ITEM_CONTENT_Listener
    extends AppEventListener {
        private OPEN_FRAME_SHOW_ITEM_CONTENT_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionPrintNoConfirmation.this.propertiesSelected = false;
        }
    }
}

